# Copyright (c) Facebook, Inc. and its affiliates.
# 
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

import numpy as np
import sys
import os
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
sys.path.append(BASE_DIR)
ROOT_DIR = os.path.dirname(BASE_DIR)
sys.path.append(os.path.join(ROOT_DIR, 'utils'))

class scannetDatasetConfig(object):
    def __init__(self):
        self.num_class = 365 #change this 
        self.num_heading_bin = 12
        self.num_size_cluster = 365 #change this 
        #training sets
        self.type2class={"human": 0,
                            "sneakers": 1,
                            "chair": 2,
                            "hat": 3,
                            "lamp": 4,
                            "bottle": 5,
                            "cabinet/shelf": 6,
                            "cup": 7,
                            "car": 8,
                            "glasses": 9,
                            "picture/frame": 10,
                            "desk": 11,
                            "handbag": 12,
                            "street lights": 13,
                            "book": 14,
                            "plate": 15,
                            "helmet": 16,
                            "leather shoes": 17,
                            "pillow": 18,
                            "glove": 19,
                            "potted plant": 20,
                            "bracelet": 21,
                            "flower": 22,
                            "monitor": 23,
                            "storage box": 24,
                            "plants pot/vase": 25,
                            "bench": 26,
                            "wine glass": 27,
                            "boots": 28,
                            "dining table": 29,
                            "umbrella": 30,
                            "boat": 31,
                            "flag": 32,
                            "speaker": 33,
                            "trash bin/can": 34,
                            "stool": 35,
                            "backpack": 36,
                            "sofa": 37,
                            "belt": 38,
                            "carpet": 39,
                            "basket": 40,
                            "towel/napkin": 41,
                            "slippers": 42,
                            "bowl": 43,
                            "barrel/bucket": 44,
                            "coffee table": 45,
                            "suv": 46,
                            "toy": 47,
                            "tie": 48,
                            "bed": 49,
                            "traffic light": 50,
                            "pen/pencil": 51,
                            "microphone": 52,
                            "sandals": 53,
                            "canned": 54,
                            "necklace": 55,
                            "mirror": 56,
                            "faucet": 57,
                            "bicycle": 58,
                            "bread": 59,
                            "high heels": 60,
                            "ring": 61,
                            "van": 62,
                            "watch": 63,
                            "combine with bowl": 64,
                            "sink": 65,
                            "horse": 66,
                            "fish": 67,
                            "apple": 68,
                            "traffic sign": 69,
                            "camera": 70,
                            "candle": 71,
                            "stuffed animal": 72,
                            "cake": 73,
                            "motorbike/motorcycle": 74,
                            "wild bird": 75,
                            "laptop": 76,
                            "knife": 77,
                            "cellphone": 78,
                            "paddle": 79,
                            "truck": 80,
                            "cow": 81,
                            "power outlet": 82,
                            "clock": 83,
                            "drum": 84,
                            "fork": 85,
                            "bus": 86,
                            "hanger": 87,
                            "nightstand": 88,
                            "pot/pan": 89,
                            "sheep": 90,
                            "guitar": 91,
                            "traffic cone": 92,
                            "tea pot": 93,
                            "keyboard": 94,
                            "tripod": 95,
                            "hockey stick": 96,
                            "fan": 97,
                            "dog": 98,
                            "spoon": 99,
                            "blackboard/whiteboard": 100,
                            "balloon": 101,
                            "air conditioner": 102,
                            "cymbal": 103,
                            "mouse": 104,
                            "telephone": 105,
                            "pickup truck": 106,
                            "orange": 107,
                            "banana": 108,
                            "airplane": 109,
                            "luggage": 110,
                            "skis": 111,
                            "soccer": 112,
                            "trolley": 113,
                            "oven": 114,
                            "remote": 115,
                            "combine with glove": 116,
                            "paper towel": 117,
                            "refrigerator": 118,
                            "train": 119,
                            "tomato": 120,
                            "machinery vehicle": 121,
                            "tent": 122,
                            "shampoo/shower gel": 123,
                            "head phone": 124,
                            "lantern": 125,
                            "donut": 126,
                            "cleaning products": 127,
                            "sailboat": 128,
                            "tangerine": 129,
                            "pizza": 130,
                            "kite": 131,
                            "computer box": 132,
                            "elephant": 133,
                            "toiletries": 134,
                            "gas stove": 135,
                            "broccoli": 136,
                            "toilet": 137,
                            "stroller": 138,
                            "shovel": 139,
                            "baseball bat": 140,
                            "microwave": 141,
                            "skateboard": 142,
                            "surfboard": 143,
                            "surveillance camera": 144,
                            "gun": 145,
                            "Life saver": 146,
                            "cat": 147,
                            "lemon": 148,
                            "liquid soap": 149,
                            "zebra": 150,
                            "duck": 151,
                            "sports car": 152,
                            "giraffe": 153,
                            "pumpkin": 154,
                            "Accordion/keyboard/piano": 155,
                            "radiator": 156,
                            "converter": 157,
                            "tissue": 158,
                            "carrot": 159,
                            "washing machine": 160,
                            "vent": 161,
                            "cookies": 162,
                            "cutting/chopping board": 163,
                            "tennis racket": 164,
                            "candy": 165,
                            "skating and skiing shoes": 166,
                            "scissors": 167,
                            "folder": 168,
                            "baseball": 169,
                            "strawberry": 170,
                            "bow tie": 171,
                            "pigeon": 172,
                            "pepper": 173,
                            "coffee machine": 174,
                            "bathtub": 175,
                            "snowboard": 176,
                            "suitcase": 177,
                            "grapes": 178,
                            "ladder": 179,
                            "pear": 180,
                            "american football": 181,
                            "basketball": 182,
                            "potato": 183,
                            "paint brush": 184,
                            "printer": 185,
                            "billiards": 186,
                            "fire hydrant": 187,
                            "goose": 188,
                            "projector": 189,
                            "sausage": 190,
                            "fire extinguisher": 191,
                            "extension cord": 192,
                            "facial mask": 193,
                            "tennis ball": 194,
                            "chopsticks": 195,
                            "Electronic stove and gas st": 196,
                            "pie": 197,
                            "frisbee": 198,
                            "kettle": 199,
                            "hamburger": 200,
                            "golf club": 201,
                            "cucumber": 202,
                            "clutch": 203,
                            "blender": 204,
                            "tong": 205,
                            "slide": 206,
                            "hot dog": 207,
                            "toothbrush": 208,
                            "facial cleanser": 209,
                            "mango": 210,
                            "deer": 211,
                            "egg": 212,
                            "violin": 213,
                            "marker": 214,
                            "ship": 215,
                            "chicken": 216,
                            "onion": 217,
                            "ice cream": 218,
                            "tape": 219,
                            "wheelchair": 220,
                            "plum": 221,
                            "bar soap": 222,
                            "scale": 223,
                            "watermelon": 224,
                            "cabbage": 225,
                            "router/modem": 226,
                            "golf ball": 227,
                            "pine apple": 228,
                            "crane": 229,
                            "fire truck": 230,
                            "peach": 231,
                            "cello": 232,
                            "notepaper": 233,
                            "tricycle": 234,
                            "toaster": 235,
                            "helicopter": 236,
                            "green beans": 237,
                            "brush": 238,
                            "carriage": 239,
                            "cigar": 240,
                            "earphone": 241,
                            "penguin": 242,
                            "hurdle": 243,
                            "swing": 244,
                            "radio": 245,
                            "CD": 246,
                            "parking meter": 247,
                            "swan": 248,
                            "garlic": 249,
                            "french fries": 250,
                            "horn": 251,
                            "avocado": 252,
                            "saxophone": 253,
                            "trumpet": 254,
                            "sandwich": 255,
                            "cue": 256,
                            "kiwi fruit": 257,
                            "bear": 258,
                            "fishing rod": 259,
                            "cherry": 260,
                            "tablet": 261,
                            "green vegetables": 262,
                            "nuts": 263,
                            "corn": 264,
                            "key": 265,
                            "screwdriver": 266,
                            "globe": 267,
                            "broom": 268,
                            "pliers": 269,
                            "hammer": 270,
                            "volleyball": 271,
                            "eggplant": 272,
                            "trophy": 273,
                            "board eraser": 274,
                            "dates": 275,
                            "rice": 276,
                            "tape measure/ruler": 277,
                            "dumbbell": 278,
                            "hamimelon": 279,
                            "stapler": 280,
                            "camel": 281,
                            "lettuce": 282,
                            "goldfish": 283,
                            "meat balls": 284,
                            "medal": 285,
                            "toothpaste": 286,
                            "antelope": 287,
                            "shrimp": 288,
                            "rickshaw": 289,
                            "trombone": 290,
                            "pomegranate": 291,
                            "coconut": 292,
                            "jellyfish": 293,
                            "mushroom": 294,
                            "calculator": 295,
                            "treadmill": 296,
                            "butterfly": 297,
                            "egg tart": 298,
                            "cheese": 299,
                            "pomelo": 300,
                            "pig": 301,
                            "race car": 302,
                            "rice cooker": 303,
                            "tuba": 304,
                            "crosswalk sign": 305,
                            "papaya": 306,
                            "hair dryer": 307,
                            "green onion": 308,
                            "chips": 309,
                            "dolphin": 310,
                            "sushi": 311,
                            "urinal": 312,
                            "donkey": 313,
                            "electric drill": 314,
                            "spring rolls": 315,
                            "tortoise/turtle": 316,
                            "parrot": 317,
                            "flute": 318,
                            "measuring cup": 319,
                            "shark": 320,
                            "steak": 321,
                            "poker card": 322,
                            "binoculars": 323,
                            "llama": 324,
                            "radish": 325,
                            "noodles": 326,
                            "mop": 327,
                            "yak": 328,
                            "crab": 329,
                            "microscope": 330,
                            "barbell": 331,
                            "Bread/bun": 332,
                            "baozi": 333,
                            "lion": 334,
                            "red cabbage": 335,
                            "polar bear": 336,
                            "lighter": 337,
                            "mangosteen": 338,
                            "seal": 339,
                            "comb": 340,
                            "eraser": 341,
                            "pitaya": 342,
                            "scallop": 343,
                            "pencil case": 344,
                            "saw": 345,
                            "table tennis  paddle": 346,
                            "okra": 347,
                            "starfish": 348,
                            "monkey": 349,
                            "eagle": 350,
                            "durian": 351,
                            "rabbit": 352,
                            "game board": 353,
                            "french horn": 354,
                            "ambulance": 355,
                            "asparagus": 356,
                            "hoverboard": 357,
                            "pasta": 358,
                            "target": 359,
                            "hotair balloon": 360,
                            "chainsaw": 361,
                            "lobster": 362,
                            "iron": 363,
                            "flashlight": 364,}
        self.class2type = {self.type2class[t]:t for t in self.type2class}
        #change this 
        self.type_mean_size = {"Accordion/keyboard/piano": np.array([0.881167,0.43099,0.303829]),
"Bread/bun": np.array([0.150416,0.102846,0.048771]),
"CD": np.array([0.125401,0.087775,0.029752]),
"Electronic stove and gas st": np.array([0.798172,0.527447,0.3037]),
"air conditioner": np.array([0.641285,0.25451,0.457654]),
"airplane": np.array([0.201513,0.0984,0.172818]),
"apple": np.array([0.076238,0.043103,0.056813]),
"asparagus": np.array([0.043519,0.039069,0.017135]),
"avocado": np.array([0.239573,0.120583,0.09403]),
"backpack": np.array([0.489555,0.36688,0.342496]),
"balloon": np.array([0.164761,0.075738,0.115491]),
"banana": np.array([0.141526,0.057461,0.015844]),
"bar soap": np.array([0.127425,0.077292,0.040352]),
"barbell": np.array([0.308224,0.193698,0.158933]),
"barrel/bucket": np.array([0.39851,0.267862,0.301967]),
"baseball bat": np.array([0.354759,0.087689,0.192376]),
"basket": np.array([0.375159,0.23024,0.212633]),
"basketball": np.array([0.424831,0.120536,0.110257]),
"bathtub": np.array([0.927642,0.443203,0.462844]),
"bear": np.array([0.099928,0.060943,0.112126]),
"bed": np.array([1.455372,0.843464,0.562523]),
"belt": np.array([0.159451,0.07312,0.094659]),
"bench": np.array([1.042123,0.431801,0.448564]),
"bicycle": np.array([0.80673,0.480739,0.560347]),
"billiards": np.array([1.9245,1.130068,0.475203]),
"binoculars": np.array([0.291319,0.117739,0.116893]),
"blackboard/whiteboard": np.array([1.136647,0.130382,0.693649]),
"blender": np.array([0.340591,0.159107,0.274976]),
"board eraser": np.array([0.121208,0.062215,0.033901]),
"boat": np.array([0.240493,0.051341,0.018324]),
"book": np.array([0.167052,0.058189,0.20651]),
"boots": np.array([0.274806,0.113885,0.126597]),
"bottle": np.array([0.256264,0.075952,0.182934]),
"bow tie": np.array([0.282607,0.21479,0.188879]),
"bowl": np.array([0.26542,0.149437,0.089438]),
"bracelet": np.array([0.096692,0.050444,0.061586]),
"bread": np.array([0.246822,0.263471,0.125257]),
"broccoli": np.array([0.107518,0.052851,0.025398]),
"broom": np.array([0.394964,0.139754,0.722543]),
"brush": np.array([0.164915,0.063554,0.087911]),
"butterfly": np.array([0.133331,0.025241,0.047839]),
"cabbage": np.array([0.185594,0.130056,0.071582]),
"cabinet/shelf": np.array([0.530827,0.133727,0.6638]),
"cake": np.array([0.22543,0.161098,0.102658]),
"calculator": np.array([0.251687,0.125848,0.059149]),
"camel": np.array([0.355475,0.281176,0.277134]),
"camera": np.array([0.239687,0.092265,0.0927]),
"candle": np.array([0.187688,0.073973,0.102544]),
"candy": np.array([0.097759,0.044802,0.033766]),
"canned": np.array([0.17317,0.081635,0.136386]),
"car": np.array([0.410693,0.224242,0.121086]),
"carpet": np.array([0.901411,0.513213,0.096086]),
"carrot": np.array([0.078268,0.03462,0.050357]),
"cat": np.array([0.389362,0.217139,0.155328]),
"cello": np.array([0.477913,0.288535,0.760559]),
"cellphone": np.array([0.16239,0.090796,0.038498]),
"chainsaw": np.array([0.259947,0.223899,0.523236]),
"chair": np.array([0.724327,0.395231,0.51279]),
"cheese": np.array([0.28054,0.221419,0.158233]),
"chopsticks": np.array([0.236491,0.043535,0.07157]),
"cigar": np.array([0.11886,0.056376,0.080373]),
"cleaning products": np.array([0.141753,0.058051,0.235497]),
"clock": np.array([0.165242,0.073213,0.09556]),
"coconut": np.array([0.14528,0.068488,0.099516]),
"coffee machine": np.array([0.514655,0.251767,0.329482]),
"coffee table": np.array([0.914785,0.595214,0.425894]),
"comb": np.array([0.172391,0.075724,0.057287]),
"combine with bowl": np.array([0.15723,0.1474,0.098282]),
"computer box": np.array([0.383548,0.208528,0.228772]),
"cookies": np.array([0.043049,0.021395,0.029683]),
"cow": np.array([0.499327,0.292649,0.350618]),
"crab": np.array([0.117879,0.015811,0.145493]),
"crosswalk sign": np.array([0.19524,0.047114,0.168298]),
"cucumber": np.array([0.111663,0.12542,0.038625]),
"cup": np.array([0.22791,0.088586,0.105]),
"cutting/chopping board": np.array([0.401191,0.244931,0.060853]),
"cymbal": np.array([0.438532,0.305432,0.152635]),
"deer": np.array([0.287405,0.086766,0.321048]),
"desk": np.array([1.138047,0.62891,0.510891]),
"dining table": np.array([1.213788,0.715519,0.328306]),
"dog": np.array([0.542489,0.263036,0.292073]),
"dolphin": np.array([0.428076,0.145919,0.170403]),
"donut": np.array([0.056908,0.035636,0.014567]),
"drum": np.array([0.794587,0.230097,0.333967]),
"duck": np.array([0.221595,0.092882,0.12382]),
"dumbbell": np.array([0.204595,0.083552,0.106683]),
"durian": np.array([0.255452,0.109246,0.153231]),
"eagle": np.array([0.37471,0.068474,0.394585]),
"earphone": np.array([0.253205,0.14867,0.077452]),
"egg": np.array([0.136273,0.059213,0.057786]),
"egg tart": np.array([0.079221,0.061976,0.0304]),
"electric drill": np.array([0.241978,0.088606,0.101854]),
"elephant": np.array([0.274771,0.070324,0.137365]),
"eraser": np.array([0.089019,0.04262,0.018885]),
"extension cord": np.array([0.253069,0.094294,0.195534]),
"facial cleanser": np.array([0.174476,0.091224,0.204478]),
"fan": np.array([0.456538,0.264643,0.385052]),
"faucet": np.array([0.213423,0.094371,0.121385]),
"fire extinguisher": np.array([0.166809,0.096447,0.222391]),
"fire hydrant": np.array([0.295737,0.125355,0.292658]),
"fire truck": np.array([0.289842,0.044789,0.197352]),
"fish": np.array([0.08273,0.029247,0.112248]),
"fishing rod": np.array([0.281472,0.051051,0.064002]),
"flag": np.array([0.142439,0.075387,0.174576]),
"flashlight": np.array([0.219621,0.070972,0.078922]),
"flower": np.array([0.293256,0.104217,0.113308]),
"flute": np.array([0.338014,0.064753,0.330982]),
"folder": np.array([0.337729,0.102541,0.295895]),
"fork": np.array([0.191857,0.061863,0.049305]),
"french horn": np.array([0.197363,0.102916,0.149314]),
"frisbee": np.array([0.240001,0.140203,0.053162]),
"game board": np.array([0.719543,0.256587,0.277275]),
"garlic": np.array([0.091667,0.048045,0.030289]),
"gas stove": np.array([0.634835,0.462368,0.118908]),
"giraffe": np.array([0.204126,0.061416,0.368281]),
"glasses": np.array([0.292784,0.143692,0.034241]),
"globe": np.array([0.320318,0.218608,0.254621]),
"glove": np.array([0.368468,0.161571,0.125464]),
"goldfish": np.array([0.106276,0.06182,0.018029]),
"golf ball": np.array([0.115746,0.054396,0.060795]),
"golf club": np.array([0.260649,0.112244,0.246228]),
"green onion": np.array([0.225462,0.048302,0.110547]),
"green vegetables": np.array([0.046137,0.038915,0.017135]),
"guitar": np.array([0.499386,0.365755,0.787601]),
"hair dryer": np.array([0.282663,0.123861,0.188281]),
"hammer": np.array([0.131143,0.066332,0.212641]),
"handbag": np.array([0.398436,0.243899,0.242192]),
"hanger": np.array([0.394507,0.067334,0.15777]),
"hat": np.array([0.311241,0.193523,0.140555]),
"head phone": np.array([0.241761,0.139313,0.09347]),
"helicopter": np.array([0.818533,0.561311,0.330942]),
"helmet": np.array([0.318228,0.249897,0.2021]),
"high heels": np.array([0.291716,0.153069,0.084687]),
"hockey stick": np.array([0.321309,0.079901,0.270031]),
"horn": np.array([0.04684,0.0336,0.130192]),
"horse": np.array([0.10543,0.033485,0.11273]),
"hotair balloon": np.array([0.181281,0.074247,0.108803]),
"hoverboard": np.array([0.415367,0.227893,0.191937]),
"human": np.array([0.28831,0.08121,0.565063]),
"hurdle": np.array([1.562057,0.824915,0.753194]),
"ice cream": np.array([0.049856,0.019905,0.05493]),
"jellyfish": np.array([0.1343,0.038648,0.036467]),
"kettle": np.array([0.370459,0.164576,0.220164]),
"key": np.array([0.082217,0.03557,0.044361]),
"keyboard": np.array([0.455751,0.202716,0.051637]),
"kite": np.array([0.122224,0.038818,0.124427]),
"kiwi fruit": np.array([0.095911,0.028412,0.074771]),
"knife": np.array([0.183985,0.049105,0.075485]),
"ladder": np.array([0.593215,0.300849,0.917918]),
"lamp": np.array([0.468342,0.24007,0.410696]),
"lantern": np.array([0.360276,0.143864,0.200838]),
"laptop": np.array([0.473147,0.306272,0.13252]),
"leather shoes": np.array([0.290376,0.139186,0.093368]),
"lemon": np.array([0.142887,0.053867,0.046567]),
"lettuce": np.array([0.139829,0.089753,0.083606]),
"lighter": np.array([0.155409,0.049098,0.071825]),
"lion": np.array([0.186482,0.094427,0.138479]),
"liquid soap": np.array([0.169204,0.087639,0.182928]),
"luggage": np.array([0.555987,0.333298,0.450498]),
"mango": np.array([0.520469,0.18279,0.413043]),
"mangosteen": np.array([0.080738,0.050656,0.048899]),
"marker": np.array([0.143552,0.047745,0.025291]),
"measuring cup": np.array([0.260546,0.107847,0.117133]),
"medal": np.array([0.137215,0.090183,0.315351]),
"microphone": np.array([0.241497,0.075902,0.135238]),
"microscope": np.array([0.5152,0.147782,0.204427]),
"microwave": np.array([0.598704,0.363278,0.304187]),
"mirror": np.array([1.120323,0.324142,0.666397]),
"monkey": np.array([0.157834,0.053954,0.162468]),
"mop": np.array([0.427517,0.201987,0.748327]),
"motorbike/motorcycle": np.array([0.735849,0.424758,0.44412]),
"mouse": np.array([0.152885,0.082586,0.048039]),
"mushroom": np.array([0.053457,0.030533,0.027513]),
"necklace": np.array([0.252799,0.187831,0.033099]),
"nightstand": np.array([0.850691,0.453255,0.650812]),
"notepaper": np.array([0.237173,0.136643,0.030501]),
"onion": np.array([0.092679,0.053245,0.073437]),
"oven": np.array([0.754694,0.247435,0.636582]),
"paddle": np.array([0.305691,0.085237,0.25868]),
"paint brush": np.array([0.125538,0.053937,0.154692]),
"paper towel": np.array([0.216518,0.115487,0.150933]),
"parking meter": np.array([0.446535,0.387993,0.8595]),
"parrot": np.array([0.164121,0.170163,0.193448]),
"peach": np.array([0.107387,0.02164,0.060459]),
"pen/pencil": np.array([0.144721,0.032738,0.018642]),
"pencil case": np.array([0.256142,0.113139,0.100883]),
"penguin": np.array([0.156058,0.10337,0.09799]),
"pepper": np.array([0.110136,0.040566,0.085375]),
"picture/frame": np.array([0.419814,0.11158,0.289443]),
"pie": np.array([0.22769,0.199854,0.049177]),
"pig": np.array([0.130409,0.068305,0.079229]),
"pillow": np.array([0.581876,0.320063,0.225343]),
"pine apple": np.array([0.231282,0.138976,0.107897]),
"pizza": np.array([0.204578,0.142117,0.049177]),
"plants pot/vase": np.array([0.24677,0.131222,0.156088]),
"plate": np.array([0.295438,0.2182,0.058406]),
"pliers": np.array([0.225074,0.116267,0.038859]),
"poker card": np.array([0.131883,0.06956,0.046245]),
"polar bear": np.array([0.783802,0.038333,0.369619]),
"pomegranate": np.array([0.12525,0.089706,0.086424]),
"pomelo": np.array([0.128964,0.065761,0.095666]),
"pot/pan": np.array([0.404082,0.220156,0.147353]),
"potato": np.array([0.086371,0.028428,0.065482]),
"potted plant": np.array([0.496057,0.288471,0.35957]),
"power outlet": np.array([0.112617,0.054163,0.123601]),
"printer": np.array([0.636678,0.47787,0.318204]),
"projector": np.array([0.422286,0.196412,0.145841]),
"pumpkin": np.array([0.148839,0.060149,0.09534]),
"rabbit": np.array([0.257997,0.113173,0.224657]),
"radiator": np.array([0.706238,0.238757,0.509222]),
"radio": np.array([0.30857,0.164943,0.123112]),
"refrigerator": np.array([0.771431,0.297441,0.99631]),
"remote": np.array([0.212074,0.092491,0.046119]),
"rice cooker": np.array([0.489334,0.272758,0.277905]),
"rickshaw": np.array([1.355568,0.717065,1.101669]),
"ring": np.array([0.029973,0.013691,0.033539]),
"router/modem": np.array([0.288045,0.143577,0.103339]),
"sailboat": np.array([0.13269,0.079537,0.535882]),
"sandwich": np.array([0.400478,0.247277,0.071601]),
"sausage": np.array([0.166208,0.07241,0.03805]),
"saw": np.array([0.212441,0.097995,0.416761]),
"scale": np.array([0.311118,0.18891,0.079136]),
"scissors": np.array([0.19045,0.079857,0.049209]),
"screwdriver": np.array([0.10509,0.037667,0.072216]),
"shampoo/shower gel": np.array([0.158912,0.061243,0.152385]),
"shark": np.array([0.150127,0.065275,0.077154]),
"shovel": np.array([0.356158,0.121885,0.706017]),
"sink": np.array([0.537233,0.359214,0.174754]),
"skateboard": np.array([0.460023,0.293374,0.159994]),
"skating and skiing shoes": np.array([0.320795,0.14309,0.116133]),
"skis": np.array([0.218997,0.0969,0.02338]),
"slippers": np.array([0.252835,0.133596,0.087668]),
"sneakers": np.array([0.278929,0.098985,0.123416]),
"snowboard": np.array([0.960444,0.873201,0.809991]),
"sofa": np.array([1.291901,0.78383,0.702356]),
"speaker": np.array([0.272342,0.129205,0.19576]),
"spoon": np.array([0.174407,0.065811,0.099549]),
"stapler": np.array([0.23576,0.100746,0.072561]),
"starfish": np.array([0.135361,0.076811,0.083782]),
"steak": np.array([0.166936,0.17613,0.090832]),
"stool": np.array([0.690228,0.377382,0.480247]),
"storage box": np.array([0.380345,0.205615,0.211766]),
"strawberry": np.array([0.065816,0.029396,0.048276]),
"street lights": np.array([0.164189,0.111169,0.11459]),
"stroller": np.array([0.732523,0.360162,0.725105]),
"stuffed animal": np.array([0.370251,0.206891,0.165484]),
"suitcase": np.array([0.582711,0.360117,0.340082]),
"surfboard": np.array([0.341321,0.196948,0.527834]),
"surveillance camera": np.array([0.307558,0.104378,0.131668]),
"swan": np.array([0.135589,0.045083,0.111032]),
"table tennis  paddle": np.array([1.172215,0.707807,0.22758]),
"tangerine": np.array([0.097216,0.044105,0.076557]),
"tape": np.array([0.134574,0.066742,0.055846]),
"tape measure/ruler": np.array([0.185584,0.067942,0.063505]),
"tea pot": np.array([0.277366,0.129288,0.104306]),
"telephone": np.array([0.30255,0.151499,0.129378]),
"tennis ball": np.array([0.078771,0.058702,0.051577]),
"tennis racket": np.array([0.255322,0.109677,0.072816]),
"tent": np.array([0.378732,0.40739,0.400298]),
"tie": np.array([0.186809,0.052616,0.344474]),
"tissue": np.array([0.186944,0.101618,0.107731]),
"toaster": np.array([0.420981,0.242211,0.215922]),
"toilet": np.array([0.690693,0.437427,0.570262]),
"toiletries": np.array([0.09398,0.032316,0.105702]),
"tomato": np.array([0.079952,0.042409,0.093549]),
"toothbrush": np.array([0.174416,0.047481,0.093469]),
"toothpaste": np.array([0.172868,0.0686,0.052701]),
"tortoise/turtle": np.array([0.388786,0.356051,0.375159]),
"towel/napkin": np.array([0.273065,0.137777,0.159707]),
"toy": np.array([0.214286,0.107082,0.095651]),
"traffic cone": np.array([0.606504,0.261401,0.460274]),
"traffic light": np.array([0.372228,0.209649,0.167941]),
"traffic sign": np.array([0.309607,0.155914,0.347642]),
"trash bin/can": np.array([0.49345,0.279352,0.403399]),
"treadmill": np.array([0.938107,0.377733,0.486246]),
"tricycle": np.array([0.603521,0.197538,0.231392]),
"tripod": np.array([0.577789,0.304541,0.487458]),
"trolley": np.array([1.244134,0.634785,0.869505]),
"trombone": np.array([1.075783,0.119907,0.663596]),
"trophy": np.array([0.29009,0.088085,0.186019]),
"trumpet": np.array([1.075112,0.244041,0.036581]),
"tuba": np.array([0.524025,0.193082,0.131579]),
"umbrella": np.array([0.42413,0.264045,0.327409]),
"urinal": np.array([0.312046,0.156493,0.405969]),
"vent": np.array([0.21869,0.083358,0.10118]),
"volleyball": np.array([0.358415,0.376067,0.254528]),
"washing machine": np.array([0.74772,0.444927,0.808303]),
"watch": np.array([0.207448,0.04037,0.105894]),
"watermelon": np.array([0.420207,0.136749,0.135523]),
"wheelchair": np.array([0.796271,0.38169,0.540375]),
"wild bird": np.array([0.153613,0.114494,0.142778]),
"wine glass": np.array([0.257736,0.082744,0.157989]),
"monitor": np.array([1,1,1]),
"suv": np.array([1,1,1]),
"sandals": np.array([1,1,1]),
"van": np.array([1,1,1]),
"truck": np.array([1,1,1]),
"bus": np.array([1,1,1]),
"sheep": np.array([1,1,1]),
"pickup truck": np.array([1,1,1]),
"orange": np.array([1,1,1]),
"soccer": np.array([1,1,1]),
"combine with glove": np.array([1,1,1]),
"train": np.array([1,1,1]),
"machinery vehicle": np.array([1,1,1]),
"gun": np.array([1,1,1]),
"Life saver": np.array([1,1,1]),
"zebra": np.array([1,1,1]),
"sports car": np.array([1,1,1]),
"converter": np.array([1,1,1]),
"baseball": np.array([1,1,1]),
"pigeon": np.array([1,1,1]),
"grapes": np.array([1,1,1]),
"pear": np.array([1,1,1]),
"american football": np.array([1,1,1]),
"goose": np.array([1,1,1]),
"facial mask": np.array([1,1,1]),
"hamburger": np.array([1,1,1]),
"clutch": np.array([1,1,1]),
"tong": np.array([1,1,1]),
"slide": np.array([1,1,1]),
"hot dog": np.array([1,1,1]),
"violin": np.array([1,1,1]),
"ship": np.array([1,1,1]),
"chicken": np.array([1,1,1]),
"plum": np.array([1,1,1]),
"crane": np.array([1,1,1]),
"green beans": np.array([1,1,1]),
"carriage": np.array([1,1,1]),
"swing": np.array([1,1,1]),
"french fries": np.array([1,1,1]),
"saxophone": np.array([1,1,1]),
"cue": np.array([1,1,1]),
"cherry": np.array([1,1,1]),
"tablet": np.array([1,1,1]),
"nuts": np.array([1,1,1]),
"corn": np.array([1,1,1]),
"eggplant": np.array([1,1,1]),
"dates": np.array([1,1,1]),
"rice": np.array([1,1,1]),
"hamimelon": np.array([1,1,1]),
"meat balls": np.array([1,1,1]),
"antelope": np.array([1,1,1]),
"shrimp": np.array([1,1,1]),
"race car": np.array([1,1,1]),
"papaya": np.array([1,1,1]),
"chips": np.array([1,1,1]),
"sushi": np.array([1,1,1]),
"donkey": np.array([1,1,1]),
"spring rolls": np.array([1,1,1]),
"llama": np.array([1,1,1]),
"radish": np.array([1,1,1]),
"noodles": np.array([1,1,1]),
"yak": np.array([1,1,1]),
"baozi": np.array([1,1,1]),
"red cabbage": np.array([1,1,1]),
"seal": np.array([1,1,1]),
"pitaya": np.array([1,1,1]),
"scallop": np.array([1,1,1]),
"okra": np.array([1,1,1]),
"ambulance": np.array([1,1,1]),
"pasta": np.array([1,1,1]),
"target": np.array([1,1,1]),
"lobster": np.array([1,1,1]),
"iron": np.array([1,1,1]),}

        self.mean_size_arr = np.zeros((self.num_size_cluster, 3))
        for i in range(self.num_size_cluster):
            self.mean_size_arr[i,:] = self.type_mean_size[self.class2type[i]]
        
        #testing set
        self.num_eval_class = 20 #change this 
        self.type2class_eval ={
                            "toilet": 0,
                            "bed": 1,
                            "chair": 2,
                            "sofa": 3,
                            "dresser": 4,
                            "table": 5,
                            "cabinet": 6,
                            "bookshelf": 7,
                            "pillow": 8,
                            "sink": 9,
                            "bathtub": 10,
                            "refrigerator": 11,
                            "desk": 12,
                            "night stand": 13,
                            "counter": 14,
                            "door": 15,
                            "curtain": 16,
                            "box": 17,
                            "lamp": 18,
                            "bag": 19}
       
        self.class2type_eval = {self.type2class_eval[t]:t for t in self.type2class_eval}
        #change this 
        self.type_mean_size_eval = {
                            'toilet' : np.array([0.697272, 0.454178, 0.75625]),
                            'bed' : np.array([2.115816, 1.621716, 0.936364]),
                            'chair' : np.array([0.592329, 0.552978, 0.827272]),
                            'sofa' : np.array([0.924369, 1.8750179999999999, 0.847046]),
                            'dresser' : np.array([0.528526, 1.0013420000000002, 1.183333]),
                            'table' : np.array([0.792666, 1.285808, 0.718182]),
                            'cabinet' : np.array([0.571631, 1.214407, 0.963636]),
                            'bookshelf' : np.array([0.40298500000000004, 1.063498, 1.727273]),
                            'pillow' : np.array([0.355497, 0.56077, 0.318182]),
                            'sink' : np.array([0.502248, 0.599351, 0.457344]),
                            'bathtub' : np.array([0.767272, 1.398258, 0.45663]),
                            'refrigerator': np.array([0.809094,0.336209,1.150021]),
                            'desk' : np.array([0.68826, 1.337694, 0.7375]),
                            'night stand': np.array([0.491573,0.304834,0.316977]),
                            'counter' : np.array([0.760644, 2.23633, 0.85]),
                            'door' : np.array([2.154671, 0.913235, 0.056667]),
                            'curtain' : np.array([2.791732, 3.495345, 0.015742]),
                            'box' : np.array([0.446893, 0.423085, 0.445675]),
                            'lamp' : np.array([0.367022, 0.379614, 0.69091]),
                            'bag' : np.array([0.256476, 0.323536, 0.145785])}
        
        
        self.mean_size_arr_eval = np.zeros((self.num_eval_class, 3))
        for i in range(self.num_eval_class):
            self.mean_size_arr_eval[i,:] = self.type_mean_size_eval[self.class2type_eval[i]]
    def size2class(self, size, type_name):
        ''' Convert 3D box size (l,w,h) to size class and size residual '''
    
        size_class = self.type2class[type_name]
        size_residual = size - self.type_mean_size[type_name]    
        
        return size_class, size_residual
    def size2class_eval(self, size, type_name):
        ''' Convert 3D box size (l,w,h) to size class and size residual '''

        size_class = self.type2class_eval[type_name]
        size_residual = size - self.type_mean_size_eval[type_name]
        
        return size_class, size_residual
    
    def class2size(self, pred_cls, residual):
        ''' Inverse function to size2class '''
        mean_size = self.type_mean_size[self.class2type[pred_cls]]

        return mean_size + residual
    
    def class2size_eval(self, pred_cls, residual):
        ''' Inverse function to size2class '''
        mean_size = self.type_mean_size_eval[self.class2type_eval[pred_cls]]
        return mean_size + residual
    
    
    def angle2class(self, angle):
        ''' Convert continuous angle to discrete class
            [optinal] also small regression number from  
            class center angle to current angle.
           
            angle is from 0-2pi (or -pi~pi), class center at 0, 1*(2pi/N), 2*(2pi/N) ...  (N-1)*(2pi/N)
            return is class of int32 of 0,1,...,N-1 and a number such that
                class*(2pi/N) + number = angle
        '''
        num_class = self.num_heading_bin
        angle = angle%(2*np.pi)
        assert(angle>=0 and angle<=2*np.pi)
        angle_per_class = 2*np.pi/float(num_class)
        shifted_angle = (angle+angle_per_class/2)%(2*np.pi)
        class_id = int(shifted_angle/angle_per_class)
        residual_angle = shifted_angle - (class_id*angle_per_class+angle_per_class/2)
        return class_id, residual_angle
    
    def class2angle(self, pred_cls, residual, to_label_format=True):
        ''' Inverse function to angle2class '''
        num_class = self.num_heading_bin
        angle_per_class = 2*np.pi/float(num_class)
        angle_center = pred_cls * angle_per_class
        angle = angle_center + residual
        if to_label_format and angle>np.pi:
            angle = angle - 2*np.pi
        return angle

    def param2obb(self, center, heading_class, heading_residual, size_class, size_residual):
        heading_angle = self.class2angle(heading_class, heading_residual)
        box_size = self.class2size(int(size_class), size_residual)
        obb = np.zeros((7,))
        obb[0:3] = center
        obb[3:6] = box_size
        obb[6] = heading_angle*-1
        return obb

    def param2obb_eval(self, center, heading_class, heading_residual, size_class, size_residual):
        heading_angle = self.class2angle(heading_class, heading_residual)
        box_size = self.class2size_eval(int(size_class), size_residual)
        obb = np.zeros((7,))
        obb[0:3] = center
        obb[3:6] = box_size
        obb[6] = heading_angle*-1
        return obb
    


