## ImOV3D
ImOV3D: Learning Open Vocabulary Point Clouds 3D Object Detection from Only 2D Images


![teaser](./img/t.png)

## Environment Setup

To set up the project environment, follow this step:

**Create a virtual environment:**
```bash
conda env create -f environment.yml
```

After creating the virtual environment, activate it with:
```bash
conda activate ImOV3D
```

**PointNet++ Backbone Installation**
```bash
cd pointnet2
python setup.py install
cd ..
```

## Dataset Preparation

This section outlines the steps required for preparing the datasets for different stages of the project.

### Pretrain Stage

For detailed guidance on setting up the dataset for the pretraining stage, see the [dataset instructions](./Data_Maker/Dataset_Preparation/Pretrain).

### Adaptation

- **SCANNET**: Follow the adaptation instructions for SCANNET provided in the [Data Maker README](./Data_Maker/Dataset_Preparation/Adpatation).

- **SUNRGBD**: As the SUNRGBD code is not open-sourced by [OV-3DET](https://github.com/lyhdet/OV-3DET/blob/main), you are encouraged to follow our replication method. For more information, see [SUNRGBD instructions](./Data_Maker/Dataset_Preparation/Adpatation).


## Training and Evaluation

**Pretrain**

Pretrain ImOV3D on the LVIS dataset:
```bash
bash ./scripts/train_lvis.sh
```

**Adapation**

For the SUNRGBD dataset:
```bash
bash ./scripts/train_sunrgbd.sh
```

For the ScanNet dataset:

```bash
bash ./scripts/train_scannet.sh
```

**Evaluation**

To measure the effectiveness of your model, proceed to the evaluation phase.

```bash
bash ./scripts/eval.sh
```