import metaworld.policies as policies

env_names = [
    "assembly-v2",
    "basketball-v2",
    "button-press-topdown-v2",
    "button-press-topdown-wall-v2",
    "button-press-v2",
    "button-press-wall-v2",
    "coffee-button-v2",
    "coffee-pull-v2",
    "coffee-push-v2",
    "dial-turn-v2",
    "disassemble-v2",
    "door-open-v2",
    "door-unlock-v2",
    "drawer-close-v2",
    "drawer-open-v2",
    "faucet-open-v2",
    "faucet-close-v2",
    "hammer-v2",
    "handle-press-v2",
    "handle-press-side-v2",
    "handle-pull-v2",
    "handle-pull-side-v2",
    "peg-insert-side-v2",
    "peg-unplug-side-v2",
    "pick-out-of-hole-v2",
    "pick-place-v2",
    "pick-place-wall-v2",
    "plate-slide-v2",
    "plate-slide-side-v2",
    "plate-slide-back-v2",
    "plate-slide-back-side-v2",
    "push-back-v2",
    "push-v2",
    "push-wall-v2",
    "reach-v2",
    "reach-wall-v2",
    "shelf-place-v2",
    "soccer-v2",
    "stick-push-v2",
    "stick-pull-v2",
    "sweep-into-v2",
    "sweep-v2",
    "window-open-v2",
    "window-close-v2",
    "bin-picking-v2",
    "box-close-v2",
    "door-lock-v2",
    "hand-insert-v2",
]

POLICY = {
    "assembly-v2": policies.SawyerAssemblyV2Policy,
    "basketball-v2": policies.SawyerBasketballV2Policy,
    "button-press-topdown-v2": policies.SawyerButtonPressTopdownV2Policy,
    "button-press-topdown-wall-v2": policies.SawyerButtonPressTopdownWallV2Policy,
    "button-press-v2": policies.SawyerButtonPressV2Policy,
    "button-press-wall-v2": policies.SawyerButtonPressWallV2Policy,
    "coffee-button-v2": policies.SawyerCoffeeButtonV2Policy,
    "coffee-pull-v2": policies.SawyerCoffeePullV2Policy,
    "coffee-push-v2": policies.SawyerCoffeePushV2Policy,
    "dial-turn-v2": policies.SawyerDialTurnV2Policy,
    "disassemble-v2": policies.SawyerDisassembleV2Policy,
    "door-open-v2": policies.SawyerDoorOpenV2Policy,
    "door-unlock-v2": policies.SawyerDoorUnlockV2Policy,
    "drawer-close-v2": policies.SawyerDrawerCloseV2Policy,
    "drawer-open-v2": policies.SawyerDrawerOpenV2Policy,
    "faucet-open-v2": policies.SawyerFaucetOpenV2Policy,
    "faucet-close-v2": policies.SawyerFaucetCloseV2Policy,
    "hammer-v2": policies.SawyerHammerV2Policy,
    "handle-press-v2": policies.SawyerHandlePressV2Policy,
    "handle-press-side-v2": policies.SawyerHandlePressSideV2Policy,
    "handle-pull-v2": policies.SawyerHandlePullV2Policy,
    "handle-pull-side-v2": policies.SawyerHandlePullSideV2Policy,
    "peg-insert-side-v2": policies.SawyerPegInsertionSideV2Policy,
    "peg-unplug-side-v2": policies.SawyerPegUnplugSideV2Policy,
    "pick-out-of-hole-v2": policies.SawyerPickOutOfHoleV2Policy,
    "pick-place-v2": policies.SawyerPickPlaceV2Policy,
    "pick-place-wall-v2": policies.SawyerPickPlaceWallV2Policy,
    "plate-slide-v2": policies.SawyerPlateSlideV2Policy,
    "plate-slide-side-v2": policies.SawyerPlateSlideSideV2Policy,
    "plate-slide-back-v2": policies.SawyerPlateSlideBackV2Policy,
    "plate-slide-back-side-v2": policies.SawyerPlateSlideBackSideV2Policy,
    "push-back-v2": policies.SawyerPushBackV2Policy,
    "push-v2": policies.SawyerPushV2Policy,
    "push-wall-v2": policies.SawyerPushWallV2Policy,
    "reach-v2": policies.SawyerReachV2Policy,
    "reach-wall-v2": policies.SawyerReachWallV2Policy,
    "shelf-place-v2": policies.SawyerShelfPlaceV2Policy,
    "soccer-v2": policies.SawyerSoccerV2Policy,
    "stick-push-v2": policies.SawyerStickPushV2Policy,
    "stick-pull-v2": policies.SawyerStickPullV2Policy,
    "sweep-into-v2": policies.SawyerSweepIntoV2Policy,
    "sweep-v2": policies.SawyerSweepV2Policy,
    "window-open-v2": policies.SawyerWindowOpenV2Policy,
    "window-close-v2": policies.SawyerWindowCloseV2Policy,
    "bin-picking-v2": policies.SawyerBinPickingV2Policy,
    "box-close-v2": policies.SawyerBoxCloseV2Policy,
    "door-lock-v2": policies.SawyerDoorLockV2Policy,
    "hand-insert-v2": policies.SawyerHandInsertV2Policy,
}

CAMERA = {
    "assembly-v2": "corner",
    "basketball-v2": "corner",
    "button-press-topdown-v2": "corner",
    "button-press-topdown-wall-v2": "corner",
    "button-press-v2": "corner",
    "button-press-wall-v2": "corner",
    "coffee-button-v2": "corner",
    "coffee-pull-v2": "corner",
    "coffee-push-v2": "corner",
    "dial-turn-v2": "corner",
    "disassemble-v2": "corner",
    "door-open-v2": "corner3",
    "door-unlock-v2": "corner",
    "drawer-close-v2": "corner",
    "drawer-open-v2": "corner",
    "faucet-open-v2": "corner",
    "faucet-close-v2": "corner",
    "hammer-v2": "corner3",
    "handle-press-v2": "corner3",
    "handle-press-side-v2": "corner3",
    "handle-pull-v2": "corner3",
    "handle-pull-side-v2": "corner3",
    "peg-insert-side-v2": "corner3",
    "peg-unplug-side-v2": "corner3",
    "pick-out-of-hole-v2": "corner",
    "pick-place-v2": "corner",
    "pick-place-wall-v2": "corner",
    "plate-slide-v2": "corner3",
    "plate-slide-side-v2": "corner3",
    "plate-slide-back-v2": "corner3",
    "plate-slide-back-side-v2": "corner3",
    "push-back-v2": "corner",
    "push-v2": "corner",
    "push-wall-v2": "corner",
    "reach-v2": "corner",
    "reach-wall-v2": "corner",
    "shelf-place-v2": "corner3",
    "soccer-v2": "corner3",
    "stick-push-v2": "corner3",
    "stick-pull-v2": "corner3",
    "sweep-into-v2": "corner",
    "sweep-v2": "corner",
    "window-open-v2": "corner3",
    "window-close-v2": "corner3",
    "bin-picking-v2": "corner",
    "box-close-v2": "corner",
    "door-lock-v2": "corner",
    "hand-insert-v2": "corner",
}

NUM_STEPS = {
    "assembly-v2": 125,
    "basketball-v2": 175,
    "button-press-topdown-v2": 125,
    "button-press-topdown-wall-v2": 125,
    "button-press-v2": 125,
    "button-press-wall-v2": 125,
    "coffee-button-v2": 125,
    "coffee-pull-v2": 125,
    "coffee-push-v2": 125,
    "dial-turn-v2": 125,
    "disassemble-v2": 175,
    "door-open-v2": 125,
    "door-unlock-v2": 125,
    "drawer-close-v2": 125,
    "drawer-open-v2": 125,
    "faucet-open-v2": 125,
    "faucet-close-v2": 125,
    "hammer-v2": 125,
    "handle-press-v2": 175,
    "handle-press-side-v2": 175,
    "handle-pull-v2": 175,
    "handle-pull-side-v2": 175,
    "peg-insert-side-v2": 175,
    "peg-unplug-side-v2": 175,
    "pick-out-of-hole-v2": 125,
    "pick-place-v2": 125,
    "pick-place-wall-v2": 125,
    "plate-slide-v2": 125,
    "plate-slide-side-v2": 125,
    "plate-slide-back-v2": 125,
    "plate-slide-back-side-v2": 125,
    "push-back-v2": 125,
    "push-v2": 125,
    "push-wall-v2": 125,
    "reach-v2": 125,
    "reach-wall-v2": 125,
    "shelf-place-v2": 175,
    "soccer-v2": 125,
    "stick-push-v2": 175,
    "stick-pull-v2": 175,
    "sweep-into-v2": 125,
    "sweep-v2": 125,
    "window-open-v2": 125,
    "window-close-v2": 125,
    "bin-picking-v2": 175,
    "box-close-v2": 125,
    "door-lock-v2": 125,
    "hand-insert-v2": 125,
}
