import java.text.DecimalFormat;
import java.util.Random;

interface Debuggable {
    static DecimalFormat DF6 = new DecimalFormat("#0.000000");
    static DecimalFormat DF8 = new DecimalFormat("#0.00000000");
    static DecimalFormat DF = new DecimalFormat("#0.0000");
    static DecimalFormat DF0 = new DecimalFormat("#0.00");
    static DecimalFormat DF1 = new DecimalFormat("#0.0"); 

    static boolean Debug = false; 

    //variables used to optimize a bit space + time
    static boolean SAVE_MEMORY = true;

    static double EPS = 1E-4;
    static double EPS2 = 1E-5;
    static double EPS3 = 1E-10;

    public static int NUMBER_STRATIFIED_CV = 10;

    // hyperparameters to optimize display and our tweaks to Sarkar's embedding
    
    public static double TOO_BIG_RATIO = 100.0;
    //used to trade arcs for lines in Poincare representation (numerical imprecisions)

    public static double INITIAL_FAN_ANGLE = 2.0 * Math.PI; 
    //used to widen the representation of trees. Typically <= Math.PI to avoid flooding display
    public static double GRANDCHILD_FAN_RATIO = 0.75; 

}
