#!/bin/bash
clear
export OMP_NUM_THREADS=8

SPARSITY=${SPARSITY:-0.50}
ITERATIONS=${ITERATIONS:-100}
ALPHA=${ALPHA:-0.01}
EVAL_FREQUENCY=${EVAL_FREQUENCY:-1}

#MODEL=deit_tiny_patch16_224
#MODEL=deit_small_patch16_224
MODEL=deit_base_patch16_224

SEED=42
DATA_DIR= # initialize with imagenet path

CUDA_VISIBLE_DEVICES=0 python iht.py \
    --seed ${SEED} \
    --data_dir ${DATA_DIR} \
    --model ${MODEL} \
    --module_regex '.*blocks.*(qkv|proj|fc\d)$' \
    --blocks blocks \
    --pre_modules patch_embed pos_drop norm_pre \
    --pretrained \
    --batch_size 128 \
    --num_workers 8 \
    --iterations ${ITERATIONS} \
    --eval_frequency ${EVAL_FREQUENCY} \
    --sparsity ${SPARSITY} \
    --pruning_method FastOBC \
    --sequential \
    --alpha ${ALPHA} \
    --rel_damp 0.01 \
    --output_dir "./iht_results/FastOBC/${MODEL}_iterations=${ITERATIONS}-sp=${SPARSITY}-alpha=${ALPHA}-sequential=True_seed=${SEED}"
#    --eval_only 1