import numpy as np

BOND_TYPES = frozenset(((6, 6, 1), (6, 6, 2), (6, 6, 4), (6, 7, 1), (6, 7, 2), (6, 7, 4), (6, 8, 1), (6, 8, 2),))

DISTANCE_BINS = np.arange(1.1, 1.7, 0.005)[:-1]

# bins: np.linspace(0, 2, 100)
PAIR_EMPIRICAL_BINS = {
    'CC_2A': np.linspace(0, 2, 100),
    'All_12A': np.linspace(0, 12, 100)
}

PAIR_EMPIRICAL_DISTRIBUTIONS = {
    'CC_2A': [
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        1.2706704551470977e-05, 0.0, 8.471136367647318e-06, 2.1177840919118296e-06, 0.0, 0.0, 1.4824488643382807e-05,
        0.0, 0.0, 1.2706704551470977e-05, 0.0, 1.3412632582108253e-05, 1.2706704551470977e-05, 1.0588920459559148e-05,
        1.0588920459559148e-05, 0.0, 2.5413409102941955e-05, 1.6942272735294636e-05, 2.9648977286765614e-05, 0.0,
        2.5413409102941955e-05, 3.247268940931472e-05, 2.9648977286765614e-05, 0.0, 9.882992428921872e-06,
        1.7648200765931912e-05, 2.4001553041667403e-05, 1.9765984857843744e-05, 2.5413409102941955e-05,
        3.247268940931472e-05, 1.3412632582108253e-05, 1.9060056827206468e-05, 3.1766761378677445e-05,
        8.682914776838502e-05, 4.447346593014842e-05, 3.5296401531863825e-05, 4.235568183823659e-05,
        7.976986746201224e-05, 0.00039955526534069853, 0.0005012089017524664, 0.000385436704727953,
        0.00014259746218872986, 0.000252722234968145, 0.0007694615533946314, 0.0014845666484301925, 0.006605368582672996,
        0.017155463000547093, 0.03588585143744595, 0.20497608668796216, 0.1873568289712864, 0.07002523692709528,
        0.03320685456117749, 0.03408079346310643, 0.047667790268782095, 0.08698656971921713, 0.14746624781603515,
        0.0795778550376789, 0.02627040573213561, 0.009160828053579937, 0.0038458959109118826, 0.001889063409985352,
        0.0008633499814693892, 0.0005343875191924183, 0.00041155604186153224, 0.00016095159098529905, 0.0001115366288406897,
        0.00014330339021936713, 4.870903411397208e-05, 5.506238638970757e-05, 4.941496214460936e-05, 0.00011788998111642519,
        0.00010730106065686603, 4.1649753807599315e-05, 8.471136367647318e-05, 8.329950761519863e-05, 7.624022730882587e-05,
        0.00010094770838113055, 7.694615533946314e-05, 0.00010024178035049327, 0.0],
    'All_12A': [
        0.0, 0.0, 0.0, 0.0, 1.4003593117063207e-06, 1.5711348375241647e-06, 3.073959464721192e-06, 7.37750271533086e-06,
        9.051102868345732e-06, 2.0049046731014885e-05, 0.0006157823909939819, 0.007742928185475883, 0.046378978215873924,
        0.027380918225847217, 0.0025238914960619163, 0.001575062674617975, 0.00029766174150050207, 0.00014956520551126778,
        0.0024883018764814777, 0.010767191972184082, 0.04244502735823923, 0.04748201733713138, 0.0171510543680964,
        0.015575171970954498, 0.01590879903819224, 0.009914885477932386, 0.008630346127835727, 0.008025083509232126,
        0.008084820788163206, 0.011021408419916525, 0.02070660081562391, 0.026574482037830194, 0.019841691087566858,
        0.01068190667459065, 0.011881536433250678, 0.01610836731766297, 0.017440245643516337, 0.016190100484319393,
        0.01682070619095436, 0.017140466285495693, 0.01850585076951452, 0.018904577467194022, 0.01802180461913642,
        0.01596173945119577, 0.013238108900137303, 0.01230782630079718, 0.012661912276027898, 0.01354806647949669,
        0.014145507579017835, 0.014400099732907078, 0.014392278213824621, 0.013572009208216352, 0.013133696743652274,
        0.01420230751890485, 0.015089520530633714, 0.013851227192928526, 0.012871795397258029, 0.012166970647102622,
        0.011928772943691894, 0.012000088803273426, 0.0118103571940898, 0.011388917351476525, 0.010831813431153555,
        0.010327957319780588, 0.010036375186999201, 0.009988079868297915, 0.009522170078761672, 0.008992253622148902,
        0.008981426453812051, 0.008846582098626281, 0.008829982717516787, 0.008670580841718411, 0.008475555191234434,
        0.008327526965455526, 0.007780191405209336, 0.007333032768407894, 0.006920780649083619, 0.0064723924284962875,
        0.006219644650285878, 0.006012835488520469, 0.0058275098879029446, 0.005676885874131606, 0.005472774965674119,
        0.00524509703465377, 0.005027870565813472, 0.00475872833712455, 0.00456243894774952, 0.004420592796005219,
        0.004263206071411494, 0.00417761337787159, 0.004040548940850189, 0.003850065919352966, 0.003732435737169635,
        0.0034654452801060175, 0.003269668217308441, 0.003062210108544924, 0.002894713472822783, 0.0027808403522074443,
        0.002671270774842716, 0.0025399443954887938, 0.0]
}

EMPIRICAL_DISTRIBUTIONS = {(6, 6, 4): [0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       7.767219537353336e-07,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       1.3204273213500671e-05,
                                       1.5534439074706671e-06,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       6.990497583618002e-05,
                                       0.0,
                                       2.330165861206001e-06,
                                       1.6311161028442005e-05,
                                       7.767219537353336e-06,
                                       7.767219537353336e-07,
                                       2.330165861206001e-06,
                                       3.3399044010619344e-05,
                                       5.437053676147335e-06,
                                       6.291447825256201e-05,
                                       2.019477079711867e-05,
                                       9.864368812438736e-05,
                                       8.932302467956336e-05,
                                       3.0292156195678008e-05,
                                       0.00015689783465453738,
                                       0.0001739857176367147,
                                       0.0001856365469427447,
                                       0.00017010210786803803,
                                       0.00021825886899962872,
                                       0.00034175765964354675,
                                       0.0005204037090026734,
                                       0.0008054606660235409,
                                       0.0012652800626348584,
                                       0.0020971492750854006,
                                       0.0032754364789019017,
                                       0.0042144933209679195,
                                       0.005419189071211422,
                                       0.005455695003036983,
                                       0.005968331492502303,
                                       0.007759452317815982,
                                       0.011427133383354228,
                                       0.015250158839639538,
                                       0.025803480025041514,
                                       0.05286214272731933,
                                       0.08022450371350766,
                                       0.11321188508864728,
                                       0.1385982654245329,
                                       0.11330664516700299,
                                       0.08452210628352526,
                                       0.06408111462707249,
                                       0.05025624057253729,
                                       0.038495116749076866,
                                       0.028252484345169023,
                                       0.021902005651428934,
                                       0.017230023099710903,
                                       0.01445945589073697,
                                       0.011228292563197982,
                                       0.009549796421175927,
                                       0.00819907694363018,
                                       0.008005673177150082,
                                       0.007726829995759098,
                                       0.00764838107843183,
                                       0.00701069235441512,
                                       0.005936485892399155,
                                       0.005301904056197387,
                                       0.0036404957971575085,
                                       0.003311942410727462,
                                       0.0028785315605431463,
                                       0.0021080233824376953,
                                       0.0013165437115813903,
                                       0.0010936245108593497,
                                       0.0011891613111687956,
                                       0.0009841067153826676,
                                       0.0010998382864892324,
                                       0.0007301186365112135,
                                       0.00048312105522337745,
                                       0.0004885581088995248,
                                       0.0003821472012377841,
                                       0.00036505931825560675,
                                       0.00013514961994994803,
                                       0.00011262468329162337,
                                       6.446792216003268e-05,
                                       0.00014214011753356604,
                                       6.524464411376802e-05,
                                       4.660331722412002e-06,
                                       2.174821470458934e-05,
                                       3.0292156195678008e-05,
                                       7.767219537353336e-06,
                                       5.1263648946532017e-05,
                                       0.0001180617369677707,
                                       1.4757717120971337e-05,
                                       8.54394149108867e-06,
                                       4.194298550170801e-05,
                                       9.320663444824003e-06,
                                       2.7961990334472007e-05,
                                       1.6311161028442005e-05,
                                       4.660331722412002e-06,
                                       0.0,
                                       3.1068878149413343e-06,
                                       1.6311161028442005e-05,
                                       7.767219537353336e-07,
                                       0.0,
                                       0.0,
                                       2.330165861206001e-06,
                                       1.2427551259765337e-05,
                                       1.553443907470667e-05,
                                       2.873871228820734e-05],
                           (6, 6, 1): [0.001071247580317124,
                                       7.692980828130154e-06,
                                       7.596818567778527e-05,
                                       1.8270829466809114e-05,
                                       0.0,
                                       0.0,
                                       9.616226035162693e-07,
                                       1.9232452070325386e-06,
                                       1.153947124219523e-05,
                                       1.0577848638678962e-05,
                                       1.538596165626031e-05,
                                       1.3462716449227769e-05,
                                       1.8270829466809114e-05,
                                       5.769735621097615e-06,
                                       2.7887055501971806e-05,
                                       2.1155697277357923e-05,
                                       8.654603431646423e-06,
                                       3.8464904140650765e-05,
                                       2.211731988087419e-05,
                                       0.00016924557821886338,
                                       1.4424339052744039e-05,
                                       2.8848678105488075e-06,
                                       7.596818567778527e-05,
                                       4.808113017581346e-06,
                                       6.25054692285575e-05,
                                       2.1155697277357923e-05,
                                       2.6925432898455537e-05,
                                       2.596381029493927e-05,
                                       2.0194074673841655e-05,
                                       7.596818567778527e-05,
                                       2.9810300709004346e-05,
                                       3.654165893361823e-05,
                                       9.231576993756184e-05,
                                       5.7697356210976155e-05,
                                       3.077192331252062e-05,
                                       6.346709183207377e-05,
                                       0.00015385961656260306,
                                       0.000150013126148538,
                                       0.0002625229707599415,
                                       0.00017886180425402608,
                                       0.00015193637135557054,
                                       0.00026059972555290896,
                                       0.00034522251466234064,
                                       0.00022694293442983955,
                                       0.00037310957016431246,
                                       0.00048561941477571596,
                                       0.000789492157486857,
                                       0.001350118135336842,
                                       0.0016203340869249136,
                                       0.0016126411060967834,
                                       0.0010654778446960262,
                                       0.0015934086540264581,
                                       0.001981904185847031,
                                       0.0021376870476166663,
                                       0.002061718861938881,
                                       0.002843518038597608,
                                       0.00399265704979955,
                                       0.00502351648076899,
                                       0.008055512549655787,
                                       0.011270216913210675,
                                       0.010800945082694736,
                                       0.00916041692109598,
                                       0.007912230781731863,
                                       0.006744820941063112,
                                       0.006078416476826338,
                                       0.005575487855187329,
                                       0.00502351648076899,
                                       0.004833115205272769,
                                       0.004812921130598927,
                                       0.005151412287036654,
                                       0.005177376097331593,
                                       0.005755311282044871,
                                       0.006727511734199819,
                                       0.008135327225747637,
                                       0.010173005522598613,
                                       0.012521287920385342,
                                       0.01546289146454161,
                                       0.01764096666150596,
                                       0.020363320252060516,
                                       0.026442698351490372,
                                       0.030854622856423014,
                                       0.037125363853952605,
                                       0.0472974077539477,
                                       0.05926864754512173,
                                       0.06474701151735392,
                                       0.07638168339729727,
                                       0.08895105244785842,
                                       0.08674028208237451,
                                       0.06180252310538711,
                                       0.0465761908013105,
                                       0.03692726959762825,
                                       0.027601453588727475,
                                       0.02067969408861737,
                                       0.01447049693771282,
                                       0.011772183912246168,
                                       0.008649795318628842,
                                       0.006636157586865774,
                                       0.005179299342538626,
                                       0.003885916940809244,
                                       0.003125273461427875,
                                       0.0026329226884275452,
                                       0.0020040215057279052,
                                       0.0016914941595851175,
                                       0.0013924295298915579,
                                       0.0012202990838621457,
                                       0.0012020282543953366,
                                       0.0007404494047075273,
                                       0.0006404406539418353,
                                       0.000464463717498358,
                                       0.00047696481134406953,
                                       0.0004875426599827485,
                                       0.0003769560605783775,
                                       0.0002490602543107137,
                                       0.00019520938851380265,
                                       0.00026156134815642524,
                                       0.00025002187691423,
                                       0.00032310519478146647,
                                       0.00022405806661929072,
                                       0.00024521376389664867,
                                       0.001589562163612393],
                           (6, 8, 1): [0.0013389964360926616,
                                       4.303013121658837e-05,
                                       5.5686052162643774e-05,
                                       0.0,
                                       0.0,
                                       7.593552567633242e-05,
                                       7.593552567633242e-06,
                                       3.5436578648955125e-05,
                                       2.5311841892110807e-05,
                                       9.365381500080998e-05,
                                       4.809249959501053e-05,
                                       2.7843026081321887e-05,
                                       0.0,
                                       5.062368378422161e-06,
                                       3.796776283816621e-05,
                                       0.0003265227604082294,
                                       0.00040752065446298394,
                                       0.0005138303904098494,
                                       0.0009593188077109996,
                                       0.0008251660456828122,
                                       0.0011061274906852422,
                                       0.0008656649927101896,
                                       0.0012655920946055403,
                                       0.001792078405961445,
                                       0.0027463348452940223,
                                       0.003644905232463956,
                                       0.003862587072736109,
                                       0.004057488255305362,
                                       0.003991677466385874,
                                       0.006052061396403694,
                                       0.01229902397537664,
                                       0.01504282763648145,
                                       0.010952433986716345,
                                       0.008145350720881257,
                                       0.004991495221124251,
                                       0.002713429450834278,
                                       0.002321095901506561,
                                       0.0018629515632593552,
                                       0.002146444192450996,
                                       0.0013314028835250283,
                                       0.0017541106431232787,
                                       0.0020300097197472867,
                                       0.0021565689292078406,
                                       0.0022173173497489064,
                                       0.002073039850963875,
                                       0.002364126032723149,
                                       0.00578628705653653,
                                       0.005824254819374697,
                                       0.006692450996274097,
                                       0.0076644257249311514,
                                       0.00883383282034667,
                                       0.011780131216588368,
                                       0.019674894702737727,
                                       0.024544893082779847,
                                       0.023952595982504456,
                                       0.025521930179815324,
                                       0.021679592580592905,
                                       0.0221352057346509,
                                       0.019821703385711972,
                                       0.017649947351368864,
                                       0.022527539283978618,
                                       0.024274056374534263,
                                       0.02899977725579135,
                                       0.037512149684108216,
                                       0.049107504454884175,
                                       0.06541845537016037,
                                       0.08849526162319779,
                                       0.09141371699335818,
                                       0.07008089664668718,
                                       0.04611058237485825,
                                       0.03544417220152276,
                                       0.02806323910578325,
                                       0.019075004049894703,
                                       0.01480489632269561,
                                       0.010132330309411955,
                                       0.00817572493115179,
                                       0.0061128098169447595,
                                       0.004571318645715212,
                                       0.0038423375992224203,
                                       0.0026374939251579458,
                                       0.0022704722177223392,
                                       0.0017212052486635348,
                                       0.0011871253847399968,
                                       0.0013744330147416168,
                                       0.0007264498623035801,
                                       0.0007694799935201685,
                                       0.0004859873643285275,
                                       0.0003012109185161186,
                                       0.0005771099951401264,
                                       0.0003113356552729629,
                                       0.000220213024461364,
                                       0.00034677223392191804,
                                       0.0005138303904098494,
                                       6.834197310869917e-05,
                                       9.112263081159889e-05,
                                       0.00012402802527134295,
                                       7.84667098655435e-05,
                                       6.0748420541065935e-05,
                                       0.00018983881419083103,
                                       0.00015946460392029808,
                                       9.112263081159889e-05,
                                       5.821723635185485e-05,
                                       0.0001037785517576543,
                                       0.00017212052486635348,
                                       8.352907824396566e-05,
                                       1.5187105135266484e-05,
                                       9.871618337923214e-05,
                                       0.0,
                                       1.5187105135266484e-05,
                                       8.099789405475457e-05,
                                       5.315486797343269e-05,
                                       2.5311841892110803e-06,
                                       3.5436578648955125e-05,
                                       1.5187105135266484e-05,
                                       9.365381500080998e-05,
                                       0.0,
                                       7.087315729791025e-05,
                                       5.062368378422161e-06,
                                       4.0498947027377285e-05,
                                       0.0004125830228414061],
                           (6, 7, 1): [8.889382743485749e-05,
                                       6.667037057614312e-06,
                                       0.0,
                                       2.8890493916328684e-05,
                                       8.444913606311462e-05,
                                       0.0,
                                       8.889382743485749e-06,
                                       2.222345685871437e-06,
                                       8.889382743485749e-06,
                                       6.667037057614312e-06,
                                       6.667037057614312e-06,
                                       0.0,
                                       7.555975331962887e-05,
                                       8.889382743485749e-06,
                                       0.0,
                                       2.222345685871437e-06,
                                       0.0,
                                       4.000222234568587e-05,
                                       0.0,
                                       4.444691371742874e-06,
                                       2.666814823045725e-05,
                                       1.1111728429357187e-05,
                                       2.444580254458581e-05,
                                       1.7778765486971497e-05,
                                       8.000444469137174e-05,
                                       7.333740763375743e-05,
                                       0.00016445358075448636,
                                       0.0002089004944719151,
                                       0.00010889493860770042,
                                       0.0002733485193621868,
                                       0.00010222790155008611,
                                       0.0003266848158231013,
                                       0.0004955830879493305,
                                       0.0005822545696983166,
                                       0.00046224790266125894,
                                       0.00112895160842269,
                                       0.000884493582976832,
                                       0.0013889660536696483,
                                       0.0014867492638479915,
                                       0.0026757042057892104,
                                       0.003171287293738541,
                                       0.0031890660592255125,
                                       0.004306905939218846,
                                       0.006311461747874882,
                                       0.009551641757875437,
                                       0.012651813989666092,
                                       0.025003611311739542,
                                       0.037350963942441244,
                                       0.03498416578698817,
                                       0.033357408744930275,
                                       0.033315184176898716,
                                       0.03367298183232402,
                                       0.027928218234346353,
                                       0.02456580921162287,
                                       0.021750097227623756,
                                       0.020705594755264182,
                                       0.017972109561642313,
                                       0.017103172398466582,
                                       0.016874270792821822,
                                       0.014758597699872216,
                                       0.015003055725318072,
                                       0.015223067948219345,
                                       0.014785265848102672,
                                       0.014374131896216457,
                                       0.01404078004333574,
                                       0.012914050780598922,
                                       0.013394077448747153,
                                       0.01119395521973443,
                                       0.016054225234735264,
                                       0.017532085115839768,
                                       0.023921328962720152,
                                       0.031501750097227624,
                                       0.040128896049780545,
                                       0.04661592310683927,
                                       0.05331185065836991,
                                       0.05405855880882271,
                                       0.04271792877382077,
                                       0.03697538752152897,
                                       0.03229290516139786,
                                       0.023741318962164564,
                                       0.015074170787265959,
                                       0.0111806211456192,
                                       0.007951552864048002,
                                       0.005586977054280793,
                                       0.0047424856936496475,
                                       0.0038002111228401577,
                                       0.0027268181565642535,
                                       0.002200122229012723,
                                       0.0011845102505694761,
                                       0.0010022779043280183,
                                       0.0008756042002333463,
                                       0.000782265681426746,
                                       0.00047335963109061615,
                                       0.0002822379021056725,
                                       0.00033557419856658705,
                                       0.0001666759264403578,
                                       0.000604478026557031,
                                       0.00016223123506861492,
                                       0.00016000888938274348,
                                       0.0001666759264403578,
                                       0.0001844546919273293,
                                       4.4446913717428746e-05,
                                       0.00018667703761320072,
                                       8.667148174898605e-05,
                                       6.889271626201456e-05,
                                       7.111506194788599e-05,
                                       6.667037057614312e-06,
                                       4.000222234568587e-05,
                                       8.889382743485749e-05,
                                       2.666814823045725e-05,
                                       6.889271626201456e-05,
                                       4.666925940330018e-05,
                                       6.889271626201456e-05,
                                       6.667037057614312e-06,
                                       2.222345685871437e-06,
                                       0.0,
                                       0.00011556197566531473,
                                       6.667037057614312e-06,
                                       0.0,
                                       0.0002200122229012723],
                           (6, 8, 2): [0.0006703433986410311,
                                       0.0,
                                       6.094030896736647e-06,
                                       7.312837076083976e-05,
                                       4.875224717389317e-05,
                                       0.00020110301959230933,
                                       0.000499710533532405,
                                       0.00023766720497272922,
                                       0.00012797464883146958,
                                       0.0003900179773911454,
                                       0.0006094030896736647,
                                       0.00042658216277156527,
                                       0.0006459672750540845,
                                       0.0012309942411408027,
                                       0.0008836344800268138,
                                       0.0015722599713580549,
                                       0.0033151528078247355,
                                       0.0036320424144550413,
                                       0.007910052103964168,
                                       0.009640756878637375,
                                       0.008769310460404035,
                                       0.013687193394070507,
                                       0.022742923306621164,
                                       0.03992199640452177,
                                       0.07448733965081203,
                                       0.1201621012218532,
                                       0.13356287516377707,
                                       0.12336146744263994,
                                       0.06831408635241781,
                                       0.05281087175111978,
                                       0.05871598769005759,
                                       0.0595325878302203,
                                       0.04237789085590664,
                                       0.028684603430939395,
                                       0.01979341235260063,
                                       0.012297754349614552,
                                       0.006880160882415674,
                                       0.007617538620920808,
                                       0.005496815868856455,
                                       0.004399890307443859,
                                       0.003692982723422408,
                                       0.004040342484536397,
                                       0.0023644839879338186,
                                       0.0025960571620098115,
                                       0.003235930406167159,
                                       0.0026265273164934946,
                                       0.0026874676254608613,
                                       0.003376093116792102,
                                       0.003528443889210518,
                                       0.00401596636094945,
                                       0.0037661110941832475,
                                       0.0036747006307321977,
                                       0.0037356409396995644,
                                       0.0032542124988573693,
                                       0.00301654529388464,
                                       0.002516834760352235,
                                       0.0010603613760321764,
                                       0.0009628568816843901,
                                       0.0016575764039123678,
                                       0.0009445747889941802,
                                       0.001224900210244066,
                                       0.0011761479630701729,
                                       0.00047533440994545844,
                                       0.0005301806880160882,
                                       0.0005058045644291417,
                                       0.00035954782290746216,
                                       0.00034735976111398883,
                                       0.0005728389042932448,
                                       0.000310795575733569,
                                       0.00045095828635851183,
                                       0.00021938511228251928,
                                       0.00017672689600536275,
                                       0.00023766720497272922,
                                       7.92224016575764e-05,
                                       0.00014016271062494286,
                                       1.828209269020994e-05,
                                       0.00012797464883146958,
                                       1.2188061793473293e-05,
                                       0.0,
                                       0.0,
                                       0.0003229836375270423,
                                       6.094030896736647e-06,
                                       4.875224717389317e-05,
                                       0.0,
                                       0.0,
                                       0.0,
                                       6.094030896736647e-06,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       1.828209269020994e-05,
                                       0.0,
                                       0.0,
                                       6.0940308967366465e-05,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       6.094030896736647e-06,
                                       3.656418538041988e-05,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       3.656418538041988e-05,
                                       0.0,
                                       0.0],
                           (6, 6, 2): [0.0033803902336497706,
                                       0.0,
                                       1.7514975303884822e-05,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       3.5029950607769645e-05,
                                       1.7514975303884822e-05,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.00021017970364661787,
                                       3.5029950607769645e-05,
                                       0.00010508985182330893,
                                       0.0003152695554699268,
                                       0.00028023960486215716,
                                       0.0,
                                       0.0,
                                       1.7514975303884822e-05,
                                       0.0,
                                       0.00021017970364661787,
                                       0.0003327845307738116,
                                       0.00028023960486215716,
                                       7.005990121553929e-05,
                                       0.0005779941850281991,
                                       7.005990121553929e-05,
                                       0.0006655690615476232,
                                       0.0008757487651942411,
                                       0.0023995516166322207,
                                       0.0020142221599467546,
                                       0.004413773776578975,
                                       0.005044312887518829,
                                       0.005096857813430483,
                                       0.013889375415980664,
                                       0.015360633341506988,
                                       0.023855396363891126,
                                       0.02797141556030406,
                                       0.03371632745997828,
                                       0.04208848565523523,
                                       0.038077556310645605,
                                       0.035152555434896836,
                                       0.03601078922478719,
                                       0.025449259116544647,
                                       0.027480996251795287,
                                       0.020755245735103515,
                                       0.03524013031141626,
                                       0.036080849126002734,
                                       0.051704207097067995,
                                       0.07787158020107192,
                                       0.053350614775633166,
                                       0.04660734928363751,
                                       0.038182646162468914,
                                       0.03185974007776649,
                                       0.021630994500297755,
                                       0.024135635968753285,
                                       0.020037131747644234,
                                       0.0156934178722808,
                                       0.011945213157249448,
                                       0.008880092479069604,
                                       0.009107787158020107,
                                       0.009895961046694924,
                                       0.006217816232879112,
                                       0.010368865379899814,
                                       0.010491470207027008,
                                       0.007443864504151049,
                                       0.008757487651942411,
                                       0.006498055837741269,
                                       0.005867516726801416,
                                       0.008179493466914212,
                                       0.006778295442603426,
                                       0.007969313763267594,
                                       0.005867516726801416,
                                       0.008442218096472484,
                                       0.0063754510106140755,
                                       0.009755841244263845,
                                       0.006410480961221845,
                                       0.005814971800889761,
                                       0.0028899709251409954,
                                       0.002732336147406032,
                                       0.0038883245174624304,
                                       0.0018916173328195607,
                                       0.0032753003818264616,
                                       0.0012085332959680527,
                                       0.0005429642344204295,
                                       0.0006480540862437384,
                                       0.0002452096542543875,
                                       0.00014011980243107858,
                                       0.0006655690615476232,
                                       5.254492591165447e-05,
                                       0.0007181139874592777,
                                       0.00021017970364661787,
                                       0.00017514975303884822,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0001576347777349634,
                                       0.0002627246295582723,
                                       1.7514975303884822e-05,
                                       0.00017514975303884822,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.00028023960486215716,
                                       0.0,
                                       0.0,
                                       3.5029950607769645e-05,
                                       0.0,
                                       5.254492591165447e-05],
                           (6, 7, 4): [5.262299309060101e-06,
                                       0.0,
                                       5.262299309060101e-06,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       2.3680346890770452e-05,
                                       0.0,
                                       0.0,
                                       2.6311496545300504e-06,
                                       0.0,
                                       0.0,
                                       7.89344896359015e-06,
                                       7.89344896359015e-06,
                                       7.630333998137146e-05,
                                       0.00012892633307197247,
                                       3.15737958543606e-05,
                                       1.0524598618120201e-05,
                                       2.6311496545300504e-06,
                                       2.3680346890770452e-05,
                                       3.420494550889066e-05,
                                       5.262299309060101e-06,
                                       0.00016576242823539318,
                                       0.00023417231925317448,
                                       0.00019996737374428382,
                                       7.630333998137146e-05,
                                       0.0002683772647620651,
                                       0.000576221774342081,
                                       0.0007446153522320042,
                                       0.0008445990391041462,
                                       0.0017602391188806037,
                                       0.0023811904373496956,
                                       0.00366256031910583,
                                       0.005817471886165941,
                                       0.006785734959033,
                                       0.010148344217522405,
                                       0.014481847698533397,
                                       0.018570654261673095,
                                       0.02296467418473828,
                                       0.03483115912666881,
                                       0.040622319516289446,
                                       0.06195041861591004,
                                       0.07977382637569659,
                                       0.08157879503870422,
                                       0.07896080113244681,
                                       0.076569086096479,
                                       0.0652919786771632,
                                       0.05273876367540033,
                                       0.044855839310428296,
                                       0.04361393667349012,
                                       0.03972772863374923,
                                       0.033378764517368216,
                                       0.033312985776004965,
                                       0.025956291341938945,
                                       0.022064821002889003,
                                       0.017983907888712895,
                                       0.01407138835242671,
                                       0.01200067357431156,
                                       0.009535286348016902,
                                       0.007748735732590998,
                                       0.005612242213112598,
                                       0.004422962569265014,
                                       0.0034126011019254754,
                                       0.0025890512600575694,
                                       0.0023759281380406356,
                                       0.0019786245402065978,
                                       0.0023259362946045645,
                                       0.0016813046292447021,
                                       0.002057559029842499,
                                       0.001460288058264178,
                                       0.0009893122701032989,
                                       0.0006393693660508023,
                                       0.0007209350053412338,
                                       0.0006893612094868731,
                                       0.000570959475033021,
                                       0.00015523782961727298,
                                       0.0005367545295241302,
                                       0.00015786897927180303,
                                       0.00011840173445385226,
                                       0.0001262951834174424,
                                       7.367219032684141e-05,
                                       7.89344896359015e-06,
                                       5.788529239966111e-05,
                                       8.682793859949167e-05,
                                       5.525414274513106e-05,
                                       7.89344896359015e-06,
                                       0.00016576242823539318,
                                       1.57868979271803e-05,
                                       5.262299309060101e-06,
                                       0.0,
                                       2.1049197236240403e-05,
                                       0.0,
                                       1.0524598618120201e-05,
                                       0.0,
                                       5.2622993090601004e-05,
                                       2.6311496545300502e-05,
                                       4.7360693781540905e-05,
                                       3.15737958543606e-05,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       1.57868979271803e-05,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       2.6311496545300504e-06,
                                       3.15737958543606e-05,
                                       3.420494550889066e-05,
                                       1.3155748272650251e-05,
                                       0.0],
                           (6, 7, 2): [0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.00017670520523047406,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0007825516231635281,
                                       0.0,
                                       0.0,
                                       5.0487201494421164e-05,
                                       0.0,
                                       0.0,
                                       0.0008330388246579492,
                                       2.5243600747210582e-05,
                                       0.0,
                                       0.0,
                                       0.0012874236381077396,
                                       0.00010097440298884233,
                                       2.5243600747210582e-05,
                                       5.0487201494421164e-05,
                                       0.001388398041096582,
                                       0.001994244459029636,
                                       0.002953501287423638,
                                       0.006714797798758015,
                                       0.011006209925783814,
                                       0.0068662594032412785,
                                       0.009138183470490231,
                                       0.006462361791285909,
                                       0.0038370273135760083,
                                       0.008330388246579492,
                                       0.014237390821426768,
                                       0.017569546120058566,
                                       0.0181249053364972,
                                       0.019740495784318676,
                                       0.021507547836623415,
                                       0.026303831978593428,
                                       0.038925632352198716,
                                       0.046650174180845154,
                                       0.0632099762710153,
                                       0.07573080224163174,
                                       0.07186853132730853,
                                       0.0560660372595547,
                                       0.053617407987075275,
                                       0.0493764830615439,
                                       0.06808199121522694,
                                       0.050411470692179536,
                                       0.04538799414348463,
                                       0.03130206492654112,
                                       0.027641742818195588,
                                       0.02216388145605089,
                                       0.011965466754177817,
                                       0.015019942444590297,
                                       0.00820417024284344,
                                       0.011940223153430605,
                                       0.011662543545211288,
                                       0.005351643358408644,
                                       0.006639066996516383,
                                       0.004089463321048114,
                                       0.0031806936941485334,
                                       0.0030292320896652698,
                                       0.0013126672388549504,
                                       0.002827283283687585,
                                       0.0034583733023678498,
                                       0.005730297369616802,
                                       0.008380875448073912,
                                       0.0035341041046094814,
                                       0.0034583733023678498,
                                       0.001994244459029636,
                                       0.0011864492351188975,
                                       0.002473872873226637,
                                       0.0009340132276467915,
                                       0.0014388852425910033,
                                       0.00020194880597768466,
                                       0.0005806028171858433,
                                       0.0009340132276467915,
                                       0.0001262180037360529,
                                       0.0001514616044832635,
                                       0.0,
                                       0.00010097440298884233,
                                       5.0487201494421164e-05,
                                       0.0,
                                       0.0,
                                       0.0,
                                       2.5243600747210582e-05,
                                       0.0,
                                       0.0,
                                       2.5243600747210582e-05,
                                       5.0487201494421164e-05,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0,
                                       0.0]}

assert set(BOND_TYPES) == set(EMPIRICAL_DISTRIBUTIONS.keys())

for v in EMPIRICAL_DISTRIBUTIONS.values():
    assert len(DISTANCE_BINS) + 1 == len(v)
