(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    362516,       9589]
NotebookOptionsPosition[    352382,       9413]
NotebookOutlinePosition[    352806,       9430]
CellTagsIndexPosition[    352763,       9427]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LogisticSigmoid", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Erf", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sqrt", "[", "Pi", "]"}], "/", "4"}], "*", "x"}], "]"}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908820004980282*^9, 3.908820029888886*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"ee0d0d4f-dbef-4922-a176-178940d9ffaa"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwtlGs0lHkAhwcVEeFgs2sUYomSS4jq59goFjGlsd0YpTqVe4V0U9NS2Wp3
aWWz2+5QKcelso5i/q7rktwvFRkG4zKvjOsyMu+25+yH5zzfnw+PQVAYK1ie
wWB4feY/b4DOKE3TRFHuvI82l4+weaPEeSlNPhTzfBKS+Mh7bmUyNUOTSzlS
v4VkPqxNvYJEYpr4siIiRjL5sNfgvq/vpInBNb3pD9V8OPdP1N3LpYkHQzvE
dAUBK+HNU5sAmkzZL+5yvUsQ3cgNOcaXkb+D5HrY/qVoa1MZLeMskqg9Zpp0
ahmYpWFa9nqfiM/VQafGjnIUnKxcuvKDlBh63jq/fk0lApOsJO+uzJN7Sw6F
DN2rwtxPcYkEc8RBvuqAklo1eGo9uql9s2S7v5hSL6zBfQ+ryNbrM2Tl5Hp2
emgdrpzixJi5T5OpwKrg3/XqEafwJDpybJIkH3ETPl/SAM7lxrUdjyeIDX+s
4nFvI1JKBlPvn5AQyb75w7SwCS8FpiuyDT+ScttWhxvTzTBSd3bZ85uYCNlp
f2gttuDZusQTwv5hEnV5V9z3xm0QVOWvsbMTEacLStJ633YMWqRYk7/6ScUt
yyBuRAc0LmbZbZDrI9P66WKH/E5Y2I1bZE51k1CHnmxV4Vtc3T7WVBTTSXKD
m/8MtX4P7T05d777ooXsNUt/0hjfhWezVStr1tYRyqkx3JPfjcyuwR9GuHwS
FDC9zXVVDw766r3oOpxBztcueyQ6IECRclx7+RkeLOZ3ZbZ59WKTUE4/3p8g
7MdVU1HSXhhJXs07ltci/5CtWllaH9x57954+7fgiAPHTXWHEK5emgozBZ0Q
UAcZlh+FuB3QeXljYTducnO5tQn9qPZmqvpo9sHmZlEzx3wAYwbaF1vS+mGj
3mrdVzqAM6fNObd1REhh6+xW9xlEZ7c662jNME6ZbjfxHhpEYOyWIUVPMVz0
CsKcw0WoMLe/UbH0I1ixKowBWgST5cXDGTslYA4mZu+IHwKz+KTr0sQJ6C5r
t7++MASGVD4rUjiJqL2VLMG5YfzjW3KoyngazVpHluVSw+iyDfjKmDsDy52b
uuOCRhDOVtcw7J7FxobIqYSmEegmD/gvYc5hdmtJra31KHL2P3g0FTMPh93P
bvHvjoK99dLOmhIpOq3OrM4cH/3cKcTQ8dMCDF+8fL3NRYw55W8UivwWoVMv
qBm4Kwar2cmOmSpD06Zf8vb1iaHspFJWnC7Dat+Is+lCMcoy3n97gCeD7Krm
sKBfjI0xsZxfc2TQOtvTcFgkhtrqwiTdKhnMHFWyj4nFqD1l3a89KQPbenNe
wIwYzkpmd9Q8afAED7ZoLKcwFzH3ZY4vjYnXkmR3ZQq5XdWZXmwa+ufy0uJV
KOjnHn2VFERjYXlBjkSVwie/DJFyLA0jIy9pnSaFQt7qrYoPaZgfTTYP16MQ
qjpe/fApDdVEBw6PScEkms9yy6ehdcHYtUOfQrLHwePXimmwb6ivcjKgEDmR
9rNCK43AyCdihgmFdftP6PPe0vDYp5Vi9TWFvsrNWS49NBTzbcc4phR8Ut/y
40doNGQ3ZpWto6Ak/9jdYJzG6XfBahPmFMjJ6LbSaRpM7ojBmvUUzra7BQRK
aThGHx/w3kDh/3+h95LE74IlhX8BELmB6g==
       "]]},
     Annotation[#, "Charting`Private`Tag$10558#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwtlHk41HkAhydqRY2jUsqVo4OmWUfp6dpPd9EgE5EODW27j2rbbMIzrQib
7dGmxLqSYixbKVRyzTciKj2Va2SEwbjmh3GuGcdv2+fZPz7P+8f7PO+fHxPv
c9zvVRgMhuPX/Uc2FvfRNE3aQksS9nQW4pzCLFKhpElzqv3r8/2FeJJnvXJk
jCazG56vvzteCJvVjt5dsq9+mWoLQ70IG3TCm6pFNDmwRsWzdW0RtnUMvU14
TJN0XQuWemARuFffP7D1oskL36Y4Hc1iBHwIP/uDcIakuuz/hrG9BHV18/pK
edNE3sa7wFESGL48t2iDwRQ5KaoeTjpUimeny+dofVESdpEox6q4DCeirOWf
ryhIk2DjrpNu5Zi4xY8kmCBxv0VMuHdXIE2zZWm8ZJxExUsWlD6pRLKDtV/t
72NEqH1Jnnf1Da6c4QVa2I8SvdgB553cd+Cr/h3g1z9MbOoK9Rd7vAcv5IN5
Q+YQaQngPnJ2+oDYEml8sq+cPPeyLm0UfERh6+r5D00HCMdMv9jt1SeYaW/b
4ZoiI73LGzIk9TXItYz0be/oITHt5utEanVorchZbmfXRfTUkzlaW+ohZcXa
kOcdpCeC9+0ArwE6wVl27FkS4llzS6HIEIFlN8gSjDSTsVgmM1nciLBd/R8L
AkWE+qWVLWc3Qdc1O/rwkhrC2szlW4WIkTteoVVl/pZ8Mah2yS5phkAsvd4b
LiT5UbpxK/RacMzF4KnYJ504lMkDpEdbUaDBry/zT0O8lGlR79iG9e2zjEI9
CEb8ZXoRyjaYyYsUm8re4KnR/dz5SRLYp31+7+RRA+G+oETp3nbsdlygOvZM
BN6kS8HkYDtueIlCrPKbMRAoUAxc60ClkyHzwAIJ7i9y0o+26kS/iW5wTWIH
5lewfK5XdcL/whrejcVd+HVv0rVyTylEzdrcU1U9kHxelqAYk+JE0JZuNY4M
tRllGtvDuvBqzYZrr+YMIDfT9OF2vW6sVC/uSd8nx1yr4Hdb73bDsPj07jmR
Q6i7uPMy37gHDKVKll/7MK4wOBbVgh7841JyvGLFKAzCblqEGPVCvM5Lf0X4
GMSRTsd1k3vxs7u2jmnzOO48CXsxqdOHpbc7PWYbToBztVd7Ib8P2UdS/xoJ
VMAh2meVoLsP7lsv76sqUUInVN1TvleGnONnTTdNTWKLdICfcE+GCY2dqgVu
0zCPYBslTcvA/bTZzjB+BlXMytKbThQ0Ns8rLb4zg9sLNbPkzhRK05v2H02b
QWTKM1tnFwpWgUG8pOwZVJvvsp3nSkHTOD9qacUM6lOtm4MPU3hzxqZDd3gG
Z5OVYteTFLbNtYjW5NAQemq/LQqiMHF+Ylm2C43pXB+WFp/CY3GlwNGdxp8F
C229L1EwenyqKMqbxn6DB2vVLlOYckvv0giiEZd3r5ETTiE/zXirWgaN/PQl
zMo/KPzEHKzMeEAjZYdlwaJoCisDhNw9OTQy8kw0vG9SuO1w7MeIYhoHpySJ
kzEU/IYSY1RraXzDTAm0TKBgecTXKK2RRvRkNcc/kYKkfGPWjpavve9WvSZJ
FA7ENwpDe2kcuhSaeTCFwlyVTHuTQRo9PjE6d+5SIKcD6l6O0ngdNGrclUrh
Yv0erxNKGuvKH9Wy71P4/79Q7lzFCkij8C+G/Iqg
       "]]},
     Annotation[#, "Charting`Private`Tag$10558#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-2, 2}, {0., 0.8949542879731713}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.9088200303559017`*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"f61f8237-90c1-4cc6-9309-a04b8be9dcc1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ss3", "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"m1", "[", "0", "]"}], "\[Equal]", 
           RowBox[{"1", "/", 
            RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"m2", "[", "0", "]"}], "\[Equal]", 
           RowBox[{
            RowBox[{"-", "1"}], "/", 
            RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
            RowBox[{"(", 
             RowBox[{"mu1", "-", 
              RowBox[{"mu1", "*", 
               RowBox[{"Phi", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                    RowBox[{"sigma", "^", "2"}], "*", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"sigma", "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"2", "Pi"}], "]"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
             ")"}]}], "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"mu1", "\[Rule]", 
              RowBox[{"1", "/", 
               RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
             RowBox[{"mu2", "\[Rule]", 
              RowBox[{"1", "/", 
               RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
             RowBox[{"sigma", "\[Rule]", "sigman"}]}], "}"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
            RowBox[{"(", 
             RowBox[{"mu2", "-", 
              RowBox[{"mu2", "*", 
               RowBox[{"Phi", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                    RowBox[{"sigma", "^", "2"}], "*", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
              RowBox[{
               RowBox[{"sigma", "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"2", "Pi"}], "]"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
             ")"}]}], "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"mu1", "\[Rule]", 
              RowBox[{"1", "/", 
               RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
             RowBox[{"mu2", "\[Rule]", 
              RowBox[{"1", "/", 
               RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
             RowBox[{"sigma", "\[Rule]", "sigman"}]}], "}"}]}]}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{"m1", ",", "m2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"m1", "[", "t", "]"}], "*", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], "+", 
            RowBox[{
             RowBox[{"m2", "[", "t", "]"}], "*", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ")"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
            RowBox[{
             RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], "/.", 
         "ss3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "40"}], "}"}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.9", ",", "1"}], "}"}]}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"sigma", ",", "0", ",", "1"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.908981773483801*^9, 3.908981775066637*^9}, {
  3.908984651982691*^9, 3.9089847026751204`*^9}, {3.9089871274566107`*^9, 
  3.908987209237129*^9}, {3.908987675989715*^9, 3.9089876878715763`*^9}, {
  3.908987726597447*^9, 3.908987767516747*^9}, {3.9089879336619873`*^9, 
  3.9089879850562887`*^9}, {3.9089880724446287`*^9, 3.908988098679831*^9}, {
  3.9089882937878637`*^9, 3.908988296659693*^9}, {3.908988344262107*^9, 
  3.908988379900194*^9}, {3.908988411593657*^9, 3.908988483522111*^9}, {
  3.9089889467179956`*^9, 3.908988974275634*^9}, {3.908989702880863*^9, 
  3.9089897331061907`*^9}, {3.908993881738962*^9, 3.908993882166689*^9}, {
  3.909074926816045*^9, 3.909074927278627*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"71921a79-1888-46e8-949c-f60ae63bca67"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`sigma$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`sigma$$], 0, 1}}, Typeset`size$$ = {
    648., {206., 215.74624653845024`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`sigma$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`ss3 = 
        NDSolve[{$CellContext`m1[0] == 
           1/Sqrt[2], $CellContext`m2[0] == (-1)/Sqrt[2], 
           ReplaceAll[
           Derivative[
             1][$CellContext`m1][$CellContext`t] == $CellContext`mu1 - \
$CellContext`mu1 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)]] - ($CellContext`sigma$$/Sqrt[
              2 Pi]) (($CellContext`m1[$CellContext`t] $CellContext`sigma$$ 
               Sqrt[Pi/8])/Sqrt[
              1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)]) 
             Exp[((-1)/
                2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)))], {$CellContext`mu1 -> 1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma$$ -> $CellContext`sigman}], 
           ReplaceAll[
           Derivative[
             
             1][$CellContext`m2][$CellContext`t] == $CellContext`mu2 - \
$CellContext`mu2 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)]] - ($CellContext`sigma$$/Sqrt[
              2 Pi]) (($CellContext`m2[$CellContext`t] $CellContext`sigma$$ 
               Sqrt[Pi/8])/Sqrt[
              1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)]) 
             Exp[((-1)/
                2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)))], {$CellContext`mu1 -> 1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma$$ -> $CellContext`sigman}]}, \
{$CellContext`m1, $CellContext`m2}, {$CellContext`t, 0, 40}]; Plot[
         Evaluate[
          
          ReplaceAll[($CellContext`m1[$CellContext`t] (1/Sqrt[
              2]) + $CellContext`m2[$CellContext`t] (1/Sqrt[2]))/
           Sqrt[$CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2], $CellContext`ss3]], {$CellContext`t, 0, 
          40}, PlotRange -> {0.9, 1}]), 
      "Specifications" :> {{$CellContext`sigma$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{727., {275.873046875, 286.126953125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.908987987895452*^9, {3.9089880836334467`*^9, 3.908988099298211*^9}, 
   3.9089882973262043`*^9, {3.9089883804421*^9, 3.908988421912436*^9}, {
   3.908988466382813*^9, 3.908988486485732*^9}, {3.908988947129961*^9, 
   3.908988976928914*^9}, {3.908989714702509*^9, 3.90898973578975*^9}, {
   3.908993882527296*^9, 3.908993883801446*^9}, 3.9090749416222277`*^9, {
   3.909353197820382*^9, 3.909353200503858*^9}, {3.909353272419847*^9, 
   3.909353273752227*^9}, 3.925251425807419*^9, {3.9253143174390306`*^9, 
   3.925314338115241*^9}},
 CellLabel->"Out[7]=",ExpressionUUID->"f1bf108a-e4cd-4ca0-91b8-6dba170968c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ss3", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"m2", "[", "0", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu1", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                   RowBox[{"sigma", "^", "2"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{"sigma", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                  RowBox[{"sigma", "^", "2"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
            ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigma"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu2", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                   RowBox[{"sigma", "^", "2"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{"sigma", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                  RowBox[{"sigma", "^", "2"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
            ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigma"}]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", "m2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}], "/.", "ss3"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"sigma", ",", "0.00001", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908991267611682*^9, 3.9089913064446583`*^9}, {
   3.908993471170313*^9, 3.908993490804371*^9}, 3.908993646419668*^9, {
   3.908993873964781*^9, 3.908993874438426*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"93c78295-38a3-4684-9fb4-0fa10809e8d6"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`sigma$$ = 0.00001, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`sigma$$], 0.00001, 1}}, Typeset`size$$ = {
    648., {195., 203.26226060350166`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`sigma$$ = 0.00001}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`ss3 = 
        NDSolve[{$CellContext`m1[0] == 
           1/Sqrt[2], $CellContext`m2[0] == (-1)/Sqrt[2], 
           ReplaceAll[
           Derivative[
             1][$CellContext`m1][$CellContext`t] == $CellContext`mu1 - \
$CellContext`mu1 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)]] - ($CellContext`sigma$$/Sqrt[
              2 Pi]) (($CellContext`m1[$CellContext`t] $CellContext`sigma$$ 
               Sqrt[Pi/8])/Sqrt[
              1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)]) 
             Exp[((-1)/
                2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)))], {$CellContext`mu1 -> 1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma$$ -> $CellContext`sigma$$}], 
           ReplaceAll[
           Derivative[
             1][$CellContext`m2][$CellContext`t] == $CellContext`mu2 - \
$CellContext`mu2 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)]] - ($CellContext`sigma$$/Sqrt[
              2 Pi]) (($CellContext`m2[$CellContext`t] $CellContext`sigma$$ 
               Sqrt[Pi/8])/Sqrt[
              1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)]) 
             Exp[((-1)/
                2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)))], {$CellContext`mu1 -> 1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma$$ -> $CellContext`sigma$$}]}, \
{$CellContext`m1, $CellContext`m2}, {$CellContext`t, 0, 40}]; Plot[
         Evaluate[
          ReplaceAll[
           
           Sqrt[$CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2], $CellContext`ss3]], {$CellContext`t, 0, 
          40}]), "Specifications" :> {{$CellContext`sigma$$, 0.00001, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{727., {264.373046875, 274.626953125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.925314341856208*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"a6133906-01b1-451b-af65-86194778ae78"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"outsl", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t0", ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], "*", 
                RowBox[{"1", "/", 
                 RowBox[{"Sqrt", "[", "2", "]"}]}]}], "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], "*", 
                RowBox[{"1", "/", 
                 RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], "/.", 
            "ss3"}], "]"}], "/.", 
          RowBox[{"t", "\[Rule]", "t0"}]}], ")"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t0", ",", "0.1", ",", "40", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.909353185319439*^9, 3.9093532243678493`*^9}},
 CellLabel->
  "In[389]:=",ExpressionUUID->"631621a6-bcfd-49a6-bde5-1635eedf8728"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<outslsig1.csv\>\"", ",", "outsl", ",", "\"\<CSV\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.909353232153912*^9, 3.90935323857055*^9}, {
   3.9093532978532143`*^9, 3.909353298032373*^9}, 3.9252514511337147`*^9},
 CellLabel->
  "In[390]:=",ExpressionUUID->"ee2b45d3-a94d-4375-a201-6660752bd875"],

Cell[BoxData["\<\"outslsig1.csv\"\>"], "Output",
 CellChangeTimes->{
  3.909353243980338*^9, 3.909353300240068*^9, 3.9093534156011143`*^9, {
   3.925251452208015*^9, 3.925251463712871*^9}},
 CellLabel->
  "Out[390]=",ExpressionUUID->"666f659a-8ceb-4a35-87a2-c5f9a5795b4a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ss3", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"m2", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu1", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma1", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
            ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{
             RowBox[{"sigma1", "^", "2"}], "\[Rule]", 
             RowBox[{"1", "+", "eps"}]}], ",", 
            RowBox[{
             RowBox[{"sigma2", "^", "2"}], "\[Rule]", 
             RowBox[{"1", "-", "eps"}]}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu2", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma2", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
            ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", "1"}], ",", 
            RowBox[{"mu2", "\[Rule]", "0"}], ",", 
            RowBox[{
             RowBox[{"sigma1", "^", "2"}], "\[Rule]", 
             RowBox[{"1", "+", "eps"}]}], ",", 
            RowBox[{
             RowBox[{"sigma2", "^", "2"}], "\[Rule]", 
             RowBox[{"1", "-", "eps"}]}]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", "m2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"m1", "[", "t", "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
           RowBox[{
            RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], "/.", 
        "ss3"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"eps", ",", 
     RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9179582256983232`*^9, 3.917958404897208*^9}, {
  3.917958436036106*^9, 3.917958458514958*^9}, {3.9179585001951*^9, 
  3.917958531672605*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"d73a22a4-c710-4591-81ed-1a2284b4bf6f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`eps$$ = -0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`eps$$], -0.5, 0.5}}, Typeset`size$$ = {
    648., {189., 197.27060781955373`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`eps$$ = -0.5}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`ss3 = 
        NDSolve[{$CellContext`m1[0] == 0, $CellContext`m2[0] == 1, 
           ReplaceAll[
           Derivative[
             1][$CellContext`m1][$CellContext`t] == $CellContext`mu1 - \
$CellContext`mu1 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 $CellContext`sigma1^2 + \
$CellContext`m2[$CellContext`t]^2 $CellContext`sigma2^2) (Pi/
                  8)]] - ($CellContext`sigma1^2/Sqrt[
              2 Pi]) (($CellContext`m1[$CellContext`t] Sqrt[Pi/8])/Sqrt[
              1 + ($CellContext`m1[$CellContext`t]^2 $CellContext`sigma1^2 + \
$CellContext`m2[$CellContext`t]^2 $CellContext`sigma2^2) (Pi/8)]) 
             Exp[((-1)/
                2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                1 + ($CellContext`m1[$CellContext`t]^2 $CellContext`sigma1^2 + \
$CellContext`m2[$CellContext`t]^2 $CellContext`sigma2^2) (Pi/
                  8)))], {$CellContext`mu1 -> 1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma1^2 -> 
             1 + $CellContext`eps$$, $CellContext`sigma2^2 -> 
             1 - $CellContext`eps$$}], 
           ReplaceAll[
           Derivative[
             1][$CellContext`m2][$CellContext`t] == $CellContext`mu2 - \
$CellContext`mu2 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 $CellContext`sigma1^2 + \
$CellContext`m2[$CellContext`t]^2 $CellContext`sigma2^2) (Pi/
                  8)]] - ($CellContext`sigma2^2/Sqrt[
              2 Pi]) (($CellContext`m2[$CellContext`t] Sqrt[Pi/8])/Sqrt[
              1 + ($CellContext`m1[$CellContext`t]^2 $CellContext`sigma1^2 + \
$CellContext`m2[$CellContext`t]^2 $CellContext`sigma2^2) (Pi/8)]) 
             Exp[((-1)/
                2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                1 + ($CellContext`m1[$CellContext`t]^2 $CellContext`sigma1^2 + \
$CellContext`m2[$CellContext`t]^2 $CellContext`sigma2^2) (Pi/
                  8)))], {$CellContext`mu1 -> 1, $CellContext`mu2 -> 
             0, $CellContext`sigma1^2 -> 
             1 + $CellContext`eps$$, $CellContext`sigma2^2 -> 
             1 - $CellContext`eps$$}]}, {$CellContext`m1, $CellContext`m2}, \
{$CellContext`t, 0, 40}]; Plot[
         Evaluate[
          
          ReplaceAll[$CellContext`m1[$CellContext`t]/
           Sqrt[$CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2], $CellContext`ss3]], {$CellContext`t, 0, 
          40}]), "Specifications" :> {{$CellContext`eps$$, -0.5, 0.5}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{727., {258.373046875, 268.626953125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.9179584058008223`*^9, {3.917958437553138*^9, 3.9179584590543013`*^9}, {
   3.917958505100464*^9, 3.917958532884197*^9}, 3.925314380408276*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"30b5dbe2-9333-4043-ba1e-c70e6721e8b3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"outslan", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t0", ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"m1", "[", "t", "]"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], "/.", 
            "ss3"}], "]"}], "/.", 
          RowBox[{"t", "\[Rule]", "t0"}]}], ")"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t0", ",", "0.1", ",", "40", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.917958570270697*^9, 3.917958583855547*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"cba60348-fdd9-47c4-b19f-57229f414d45"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.908988341569086*^9, 
  3.908988342058652*^9}},ExpressionUUID->"4221d003-9d8c-48e2-be82-\
ad79c0c8ebf0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Phi", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "+", 
   RowBox[{
    RowBox[{"1", "/", "2"}], "*", 
    RowBox[{"Erf", "[", 
     RowBox[{"x", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.908984749447809*^9, 3.908984767907639*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"6371e1f6-c4c1-4065-8c30-00d596f5230c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Phi", "[", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908984769694916*^9, 3.908984801057583*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"96257887-4b82-4536-8f97-17489b075f90"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Hk4lukXB3BF9bbZpiZEGMsoklFkGvoaFKHFkqX0JkuWkq3sjWUQoVTv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       "]]},
     Annotation[#, "Charting`Private`Tag$10010#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.15865525393145719`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {0.15865525393145719`, 0.23975005885168443`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.908984796327738*^9, 3.9089848014567738`*^9}, 
   3.917720785051124*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"3c0eeb5f-7ff3-4c89-b14f-56188c489f47"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.917720786483066*^9, 
  3.917720787385187*^9}},ExpressionUUID->"9898cac3-0368-49b1-ab12-\
ba9340e57aaf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"Phi", "[", 
         RowBox[{"x1", "*", "w1", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"Pi", "/", "8"}], "]"}]}], "]"}]}], ")"}], "*", "x1", "*", 
      
      RowBox[{"PDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"mu1", ",", "sigma"}], "]"}], ",", "x1"}], "]"}], "*", 
      RowBox[{"PDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"mu2", ",", "sigma"}], "]"}], ",", "x2"}], "]"}]}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"mu1", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
      RowBox[{"mu2", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
      RowBox[{"w1", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"sigma", "\[Rule]", "0.1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908985364310997*^9, 3.9089855888391733`*^9}, {
  3.9089856609741488`*^9, 3.908985661166195*^9}, {3.908985721954255*^9, 
  3.908985761365666*^9}, {3.908985810844784*^9, 3.908985810970066*^9}, {
  3.908985846550618*^9, 3.908985846643573*^9}, {3.9089860983677263`*^9, 
  3.9089860985896177`*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"12050e9a-0a4c-4726-aac5-7e19c10251b2"],

Cell[BoxData["0.2808137084968718`"], "Output",
 CellChangeTimes->{{3.908985578781497*^9, 3.9089855893595657`*^9}, 
   3.908985661587562*^9, {3.908985723463484*^9, 3.908985761882884*^9}, {
   3.9089858114393272`*^9, 3.9089858471183863`*^9}, 3.908986099215683*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"ae232289-5c31-4505-835d-4a080463ee93"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"mu1", "-", 
        RowBox[{
         RowBox[{"Phi", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sigma", "*", "u"}], "+", "mu1"}], ")"}], "*", "w1", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"Pi", "/", "8"}], "]"}]}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sigma", "*", "u"}], "+", "mu1"}], ")"}]}]}], ")"}], "*", 
      RowBox[{"PDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "1"}], "]"}], ",", "u"}], "]"}]}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"mu1", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
      RowBox[{"mu2", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
      RowBox[{"w1", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"sigma", "\[Rule]", "0.1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908986114826247*^9, 3.908986149361401*^9}, {
  3.908986191198224*^9, 3.908986217835328*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"3f119534-5144-43de-a95f-fa395c181247"],

Cell[BoxData["0.280813794999365`"], "Output",
 CellChangeTimes->{{3.908986120304529*^9, 3.9089861500143137`*^9}, {
  3.908986212027027*^9, 3.908986218207479*^9}},
 CellLabel->"Out[48]=",ExpressionUUID->"0443c1cd-37f4-4411-a16d-6c625cfeeb5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"mu1", "-", 
    RowBox[{"mu1", "*", 
     RowBox[{"Phi", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"mu1", "*", "w1", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"w1", "^", "2"}], "*", 
          RowBox[{"sigma", "^", "2"}], "*", 
          RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"sigma", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "Pi"}], "]"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"w1", " ", "sigma", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"w1", "^", "2"}], 
         RowBox[{"sigma", "^", "2"}], " ", 
         RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"w1", "^", "2"}], 
          RowBox[{"mu1", "^", "2"}], 
          RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"w1", "^", "2"}], 
           RowBox[{"sigma", "^", "2"}], 
           RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"mu1", "\[Rule]", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
    RowBox[{"mu2", "\[Rule]", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
    RowBox[{"w1", "\[Rule]", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
    RowBox[{"sigma", "\[Rule]", "0.1"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.9089856042369947`*^9, 3.9089856569573727`*^9}, {
  3.908986055959999*^9, 3.9089860570838127`*^9}, {3.908986244586664*^9, 
  3.908986287044136*^9}, {3.9089867157275343`*^9, 3.908986811246567*^9}, {
  3.908986898571175*^9, 3.908986929290653*^9}, {3.9089870809764347`*^9, 
  3.9089870836578827`*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"b998a538-fcca-4789-af2d-b0500ea19237"],

Cell[BoxData["0.28081379499952414`"], "Output",
 CellChangeTimes->{3.908986929811015*^9, 3.90898708407224*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"28eac698-03d5-4c9a-9492-58dbf4a10ee3"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9089870510219603`*^9, 
  3.908987053594318*^9}},ExpressionUUID->"e18113b7-a2d9-41b7-8d2e-\
021caa5ebc9e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", "*", 
           RowBox[{"m1", "[", "t", "]"}]}], "+", 
          RowBox[{"mu2", "*", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"mu1", "*", 
          RowBox[{"(", 
           RowBox[{"mu1", "-", 
            RowBox[{"mu1", "*", 
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                   RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], "*", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
            RowBox[{
             RowBox[{
              RowBox[{"sigma1", "^", "2"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"2", "Pi"}], "]"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}], "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                   "2"}], 
                  RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
           ")"}]}], " ", "+", 
         RowBox[{"mu2", "*", 
          RowBox[{"(", 
           RowBox[{"mu2", "-", 
            RowBox[{"mu2", "*", 
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                   RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
            RowBox[{
             RowBox[{
              RowBox[{"sigma2", "^", "2"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"2", "Pi"}], "]"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], "  ", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}], "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                   "2"}], 
                  RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
           ")"}]}]}], ")"}]}], " ", "-", " ", 
      RowBox[{
       RowBox[{"2", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}]}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "t", "]"}], "*", 
          RowBox[{"(", 
           RowBox[{"(", 
            RowBox[{"mu1", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma1", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], "  ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
            ")"}]}], "+", 
         RowBox[{
          RowBox[{"m2", "[", "t", "]"}], "*", 
          RowBox[{"(", 
           RowBox[{"(", 
            RowBox[{"mu2", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma2", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], "  ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
            " ", ")"}]}]}], ")"}]}]}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"mu1", "\[Rule]", "1"}], ",", 
      RowBox[{"mu2", "\[Rule]", "0"}], ",", " ", 
      RowBox[{
       RowBox[{"sigma2", "^", "2"}], "\[Rule]", 
       RowBox[{"1", "+", "eps"}]}], ",", " ", 
      RowBox[{
       RowBox[{"sigma1", "^", "2"}], "\[Rule]", 
       RowBox[{"1", "-", "eps"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"eps", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908989231609228*^9, 3.908989242385806*^9}, 
   3.908990827162785*^9, {3.908990895689139*^9, 3.908990916201208*^9}, {
   3.9089910625657387`*^9, 3.9089910626704884`*^9}, {3.9089914810949497`*^9, 
   3.908991510738553*^9}, {3.9089916337029676`*^9, 3.908991695831061*^9}, {
   3.9090016395788097`*^9, 3.90900163983412*^9}, {3.909001754010434*^9, 
   3.909001754481103*^9}, {3.909001788007213*^9, 3.909001874390481*^9}, {
   3.909001926148031*^9, 3.909001955836246*^9}, 3.909001999104705*^9, {
   3.909002336561494*^9, 3.909002337179016*^9}, {3.915812264327251*^9, 
   3.9158122867535563`*^9}, {3.91581232391362*^9, 3.915812490632495*^9}, {
   3.9158125237175617`*^9, 3.915812527993338*^9}, {3.9158126120671253`*^9, 
   3.915812646388693*^9}, {3.915813047851377*^9, 3.9158130518263283`*^9}, {
   3.915813114215598*^9, 3.915813125065954*^9}, {3.9164928512412453`*^9, 
   3.916492853755486*^9}, {3.916492922905805*^9, 3.916492922975816*^9}, {
   3.917720813028288*^9, 3.917720887009265*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"0fc48092-cfa9-4786-ab77-dabf2cf79c66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"m2", "[", "t", "]"}], "2"], "-", 
     RowBox[{
      RowBox[{"Erf", "[", 
       FractionBox[
        RowBox[{
         SqrtBox[
          FractionBox["\[Pi]", "2"]], " ", 
         RowBox[{"m1", "[", "t", "]"}]}], 
        SqrtBox[
         RowBox[{"8", "+", 
          RowBox[{"\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
          RowBox[{"\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m2", "[", "t", "]"}], "2"]}]}]]], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}]}], 
    RowBox[{
     RowBox[{"m1", "[", "t", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
     SuperscriptBox[
      RowBox[{"m2", "[", "t", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"256", "+", 
       RowBox[{"56", " ", "\[Pi]", " ", 
        SuperscriptBox[
         RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox[
         RowBox[{"m1", "[", "t", "]"}], "4"]}], "+", 
       RowBox[{"72", " ", "\[Pi]", " ", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox[
         RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}], " ", "eps"}], 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"8", "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}], 
      RowBox[{"5", "/", "2"}]]}]], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
        "\[Pi]", " ", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4096"}], "-", 
          RowBox[{"832", " ", "\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[Pi]", "3"], " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "6"]}], "-", 
          RowBox[{"1728", " ", "\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m2", "[", "t", "]"}], "2"]}], "-", 
          RowBox[{"248", " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"m2", "[", "t", "]"}], "2"]}], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox["\[Pi]", "3"], " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "4"], " ", 
           SuperscriptBox[
            RowBox[{"m2", "[", "t", "]"}], "2"]}], "-", 
          RowBox[{"240", " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox[
            RowBox[{"m2", "[", "t", "]"}], "4"]}], "-", 
          RowBox[{"18", " ", 
           SuperscriptBox["\[Pi]", "3"], " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"m2", "[", "t", "]"}], "4"]}], "-", 
          RowBox[{"11", " ", 
           SuperscriptBox["\[Pi]", "3"], " ", 
           SuperscriptBox[
            RowBox[{"m2", "[", "t", "]"}], "6"]}]}], ")"}]}], ")"}], " ", 
      SuperscriptBox["eps", "2"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}], 
         RowBox[{"9", "/", "2"}]]}], ")"}]}], ")"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "eps", "]"}], "3"],
    SeriesData[$CellContext`eps, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`eps, 
   0, {$CellContext`m1[$CellContext`t]^(-1) \
($CellContext`m1[$CellContext`t]^2 + $CellContext`m2[$CellContext`t]^2)^(-1) \
($CellContext`m2[$CellContext`t]^2 - 
     Erf[(Rational[1, 2] Pi)^
        Rational[1, 2] $CellContext`m1[$CellContext`t] (8 + 
         Pi $CellContext`m1[$CellContext`t]^2 + 
         Pi $CellContext`m2[$CellContext`t]^2)^
        Rational[-1, 2]] $CellContext`m2[$CellContext`t]^2), 
    2^Rational[-1, 2] 
    E^(Rational[-1, 2] Pi $CellContext`m1[$CellContext`t]^2/(8 + 
      Pi $CellContext`m1[$CellContext`t]^2 + 
      Pi $CellContext`m2[$CellContext`t]^2)) \
$CellContext`m2[$CellContext`t]^2 ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2)^(-1) (8 + 
      Pi $CellContext`m1[$CellContext`t]^2 + 
      Pi $CellContext`m2[$CellContext`t]^2)^Rational[-5, 2] (256 + 
     56 Pi $CellContext`m1[$CellContext`t]^2 + 
     3 Pi^2 $CellContext`m1[$CellContext`t]^4 + 
     72 Pi $CellContext`m2[$CellContext`t]^2 + 
     8 Pi^2 $CellContext`m1[$CellContext`t]^2 \
$CellContext`m2[$CellContext`t]^2 + 5 Pi^2 $CellContext`m2[$CellContext`t]^4),
     Rational[-1, 4] 2^Rational[-1, 2] 
    E^(Rational[-1, 2] Pi $CellContext`m1[$CellContext`t]^2/(8 + 
      Pi $CellContext`m1[$CellContext`t]^2 + 
      Pi $CellContext`m2[$CellContext`t]^2)) 
    Pi $CellContext`m2[$CellContext`t]^2 ($CellContext`m1[$CellContext`t]^2 - \
$CellContext`m2[$CellContext`t]^2) ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2)^(-1) (8 + 
      Pi $CellContext`m1[$CellContext`t]^2 + 
      Pi $CellContext`m2[$CellContext`t]^2)^Rational[-9, 2] (-4096 - 832 
     Pi $CellContext`m1[$CellContext`t]^2 - 24 
     Pi^2 $CellContext`m1[$CellContext`t]^4 + 
     2 Pi^3 $CellContext`m1[$CellContext`t]^6 - 1728 
     Pi $CellContext`m2[$CellContext`t]^2 - 248 
     Pi^2 $CellContext`m1[$CellContext`t]^2 $CellContext`m2[$CellContext`t]^2 - 
     5 Pi^3 $CellContext`m1[$CellContext`t]^4 \
$CellContext`m2[$CellContext`t]^2 - 240 
     Pi^2 $CellContext`m2[$CellContext`t]^4 - 18 
     Pi^3 $CellContext`m1[$CellContext`t]^2 $CellContext`m2[$CellContext`t]^4 - 
     11 Pi^3 $CellContext`m2[$CellContext`t]^6)}, 0, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.9090018431469593`*^9, 3.909001875938921*^9}, 
   3.909001927327636*^9, 3.9090019999648457`*^9, 3.909002338163516*^9, 
   3.915812494318151*^9, 3.915812528858474*^9, {3.91581262890107*^9, 
   3.91581264709169*^9}, 3.9158130526640043`*^9, {3.915813101459207*^9, 
   3.9158131262842617`*^9}, 3.916492869446822*^9, {3.916492902507666*^9, 
   3.9164929239350567`*^9}, {3.917720800604653*^9, 3.917720843083683*^9}, 
   3.9177208880414457`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"eb8b9f47-0617-4b59-83cf-83eef052c6b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Erf", "[", "x", "]"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908989360954973*^9, 3.908989395312612*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"8be431d3-6f06-4c72-a8e0-dd9a12d547e2"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwtlHk41HkAh50p5So6SIqyitqhNW0lH9vKRrTD1qIDg44lHSpHs1uSnpSs
crST0tocabUoM+PM19GElnUzrmEcwwwzP6VaiW3t8+wfn+f9532e97/PGt9T
bkeUFBQUXOb2HzdhqfTTJ4p8pOk25LNkOPXBJPrDNEVKfvozM+uCDHn5lqaT
7ygSk35vQ0q4DFZmLr7iMYrYvnGlXw2VYYtOVFddB0VGEx8dcj0rg93g61d3
cylSrBTb2Rkgg9u1+uzN3hSJ39a8NdtThtCGqKBjZXIiiDzZ4EyXobV1obSC
KSM8UeIfkqFxGJaf0t2ycpxE7eEWTsaPgxv4QlWrV0o2yhfqdtqMw+em5URn
pIQI9SslPYIxTMWzoglGCU0w5mR/fgxpmsIVbJGY2Me/lx5TGsN9J8vgluvD
hB8z43z3hhSRJ5hh6x2HSEZC/tnbulKwlH8PDZYNEBMdtkddrATMiIa17Vki
oi2cHClYIEHS82H2/YB+Ms/A68zlyFEU95ktemIsJE0BeQ/vSEZgom23c9+D
bmJ9bjaZsX8EzzZEBwwMCohcf9awOUeMPv7T1XR6O8k3jJ4eVRVj2CLJivBa
yJPmQrtBv2HoXHxM36TYRN6tfdnLyx2CBZ2yyJisIzbn2rXalYdwxV7WWBRW
TTQ3u/uvdBiE3r6cW57LKknnNdYlafQAnr3na9WsLSbTQbPmh9tFyOgejpVE
5RAja/a0+RIRDruu5HT7JZLplJJ6lUP9KFJntVWeT8DumLrBA4w+WA8orrrs
kYudM5/31r7qhclEyYdtlUXQ10/iqzF74JjWWb/XoxK+y7/XpPd0YZfLYuV3
3GpEikOV9Pw6EefdEUErqEO/Ia38+nwBqvcaajAWN8H+rsTo9i/tkK3Ru9ic
3AKajt/PcQ5tOH/OnBm3tB1T4Z9dUFVpRUePttvRGgHi7/iGPstthk+4zYia
czcWdajM/MNqQpX5lhtVqkLc8ba9It7aCNMFpaPpu/vxNuRXD1XLv2BYGrhL
NVoEM94DVo9WHRSmlR4HDwyAlsRuZXTV4m/X5178dUNgN+kVfztYje4vvA3W
RQ1DO1LRqrKXj9Pu2jrGPWKEZcp9+bNVWJE45KFiOIrGOPkDunslcg6mPpoM
k+B46KMj/lnlcN9xaXfNcylSfwursvYuw1OvIONtM2PIOyFq8swuwZT618pF
+2VQ0DCNMZgohFvTdrohW44ah9Gy+Hge1LcvrChNkWN1QDf3WDQPFeldew6l
yZFqE7nM7iIPtLBw5r0cOfr3tS7/+AMPmkYFN1fw5ZjwFqokf8VD7QmrQb03
cjQu81rEes2F3fz1tzSdKWhbrzN4+R0XU2em9HNcKUzpaDHVnLjI7a7OcHGn
kPflFQVnOy5W5R4tuelLwYfb5thnwcXM/nSxejiFrE2Z7zfO46IgzWiHWuac
3+VqE1jEwUkNqjozmwKDYysQ5XJgGlrm5vB0rpdY++JgJgeJToePXy2lQKsI
ifVM4CD4dXKCcguFiBBG/Y9BHGw4GLAqTUDhdDpDqOHPgejF1sc7hXP9Jf7b
Hx7ggMEWlF2WUOj3YHW0fsPBfKUsxzUUhdRZT72zthyQwNDW8rcUFCIUU3St
OQhpc/D2maZQWCUMKjLn4P//glmY1zWmMQf/AsS1gvU=
       "]]},
     Annotation[#, "Charting`Private`Tag$119589#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1, 1}, {0., 0.9213503880032755}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.908989395767199*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"a4553f4a-20b0-4a3a-b3e9-84768c6fc8bd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Phi", "'"}], "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9158130730155687`*^9, 3.915813081158866*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"8d9f90ad-67c5-455f-99ce-8a46e0f863d2"],

Cell[BoxData[
 GraphicsBox[{{}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-10, 10}, {0., 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.9158130817220993`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"067d0275-7c83-4e80-9c17-005670bcdee4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"16", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "2"]}], "-", 
     RowBox[{"16", " ", "mu1", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox["mu1", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "4"]}], "+", 
     RowBox[{
      SuperscriptBox["mu1", "3"], " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "4"]}], "-", 
     RowBox[{
      SuperscriptBox["mu2", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "4"]}], "+", 
     RowBox[{"mu1", " ", "mu2", " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "3"], " ", 
      RowBox[{"m2", "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["mu1", "2"], " ", "mu2", " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "3"], " ", 
      RowBox[{"m2", "[", "t", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["mu1", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["mu1", "3"], " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox["mu2", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
     RowBox[{"mu1", " ", "mu2", " ", "\[Pi]", " ", 
      RowBox[{"m1", "[", "t", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "3"]}], "+", 
     RowBox[{
      SuperscriptBox["mu1", "2"], " ", "mu2", " ", "\[Pi]", " ", 
      RowBox[{"m1", "[", "t", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "3"]}], "-", 
     RowBox[{
      SuperscriptBox["mu1", "2"], " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}], "  ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"mu1", "\[Rule]", 
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", "2.", "]"}]}]}], ",", 
     RowBox[{"mu2", "\[Rule]", 
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", "2.", "]"}]}]}]}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.9089933198929253`*^9, 3.908993332725087*^9}, {
  3.9090012208221397`*^9, 3.909001226098325*^9}, {3.909002036024901*^9, 
  3.909002137859005*^9}},
 CellLabel->
  "In[229]:=",ExpressionUUID->"a454feb5-82f2-4233-b1bb-4b997cbe5a2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2.0308719190502007`"}], " ", 
   SuperscriptBox[
    RowBox[{"m1", "[", "t", "]"}], "4"]}], "+", 
  RowBox[{"2.681517061334487`", " ", 
   SuperscriptBox[
    RowBox[{"m1", "[", "t", "]"}], "3"], " ", 
   RowBox[{"m2", "[", "t", "]"}]}], "+", 
  RowBox[{"2.681517061334487`", " ", 
   RowBox[{"m1", "[", "t", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"m2", "[", "t", "]"}], "3"]}], "-", 
  RowBox[{"1.5707963267948961`", " ", 
   SuperscriptBox[
    RowBox[{"m2", "[", "t", "]"}], "4"]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"4.686291501015241`", "\[VeryThinSpace]", "-", 
     RowBox[{"3.6016682458450964`", " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.9090020390131483`*^9, 3.9090021382534723`*^9}},
 CellLabel->
  "Out[229]=",ExpressionUUID->"060c5c94-a184-4952-a746-5a4c81747180"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.908993580899208*^9, 3.908993611774095*^9}, 
   3.908993659961287*^9},ExpressionUUID->"b4ef0b75-48ee-45d1-8776-\
7f131e5dcda1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Phi", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Phi", "[", 
        RowBox[{"-", "x"}], "]"}]}], "+", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908997267079775*^9, 3.908997293056121*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"7ac44fe9-6d19-4efc-9719-3f1aa3205f5e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1Ps31HkAxnGXdCHXjaLcYqzUidEYXdQzUW2EI6F2S4Z2a1eitRWtTkvZ
stJSqx2iTYzKZknUdJFPQqSLOyOSMUaE+Q6hMTHftefsD895n9c/8FiGRPh+
p6aiouI1s/+6EkYfaJomFgNxr+u28RAxaZUwqaDJEzuGq2MgD7eLmTYfx2nC
7ZRkXw3nwdHWK6RvkCbd5n6cjAs8OOvHv3nZRpPDz+xjjIQ8cMQjtemFNLl9
694xywNp8D376taqIJpkOXQN/HM+HVF18YcOlClJSqe6TfV0BpqbtT6UB0+T
w28To90ms2D6JGKB85Ip0i1bYMpy4uPuwUoN3bcKovJ6tgqr/Qa4SUxZ+6lJ
Ihd7qz0Nyof8YkwCgZzkP3dafZd3Gzk6XcZpogmSWV+RcupcMTI9mJFNv40T
z9Q6I62GezgVFhy9zH2MeL5+dD9i9UPEqP8dFTk8SobiopwYPmUIjq2zbr05
Quz8zwWpupXj0mNJWmaojFz2D7a2OF2Bh+9s5+cvlRK/5iNNbnbPYKXHcfX7
a5A4TDC9k1prcMcuIbRH3E9KTvy5P270Bd5VFVmw2X2kUVtgomDVQbLikiO5
JyY/x1sEmLEboH8yj71SVURCylaqRmg1YQWbWpH7sZME9maXqLY04/Sm4foH
0W3EQxhQk9DWCkO/gpSvFzYSrr0hM79biDsTVbo11rXEpzKT4dT4BrkdkvMD
8WVkUZq+8MpEJwK3Lynp2Mcny9LUTCo/d+GBZkzL06M5qL9239v+RDecelTN
4nYRxNcezbVLFsFK9mhy7dPnSE/ncTed74F7Tvsr712NmL/Hh7M4U4zNXgbq
43fbcHJ6fIp/tRfJQW2xDoJOtAoY0vRECaq9TbV9DESIGhaNsWP7MGxpeLLx
shgmjF6uYPd7HD2yPDjZqA9c1R3JDbb9aOvU891f04/wRnme6+d+cI+7vJ/j
OQhZ8Jlv+cUDqFjunFihIYWyX1U+K/wDbOaV9vO3yjDfxazZSncQpqUHN2sk
jGAoo541mjUIFYVaXmTPKD6NrEq9whzCp+2P91YxxuCqCFvvkj+EDlbQYkb8
OFpyEzfMsx7G4Z16+ks7JyDVubRQmTQM49TeXbNM5TA4K7Fm9g6jYHfWjY/R
kyhgVSS/cJZi5/pfttY8VuCnon1MjxNSFO09tHTt1GdkX9inay+QQq7ppv7A
fxrCL6xYOVIpfBvWsU3TlCjNq53FWkxBc51WeekVJXoF+XuHZlzOf7NtT44S
nn5lLvwlFByijwdnFCghcQw5Y2BGQcdckGRcpYTFl1sDBiwoPA9zFBuOKmFd
9JVprA0FztxlKTqeNGxKSwZ3MCnIf5SbFGyncTFlHNMzLuyozvXaScOHIzK/
7kjBrHD/o6QQGklZuacnVlGY8uf3aR6nsbYmQHSBTUGQY75+znUahQ9bbIvX
UQjXpqqv36KxZTZ3h78LBZuoMt8tRTSyvtmo/WnGqR6B3/9aSiMyctR+zQYK
kSOX/1BvomH7Lsz5PoeC3e5QsxwhjWwPHXHARgqiyjV5rl003BcJzcdn7JMm
LIsboJH7+0svBzcKc9VuultSNBJloXg1Y3IwqvnJGI0eG+OKHzZRONayJYir
oKEY0mvX2Ezh//+CQHYu7tqM/wWARYGf
       "]]},
     Annotation[#, "Charting`Private`Tag$216906#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1Hs01HkABfBBepDnRlHjkcdKnRiN0UNdUW0UZxJqt4eh3dqVaG1Fq9NS
tqy01GqNaBOjslkSNT3kmxDp4c2IZLwiZn5DaEzMb2fP2T/uuefzx/33WgaH
+36nzmAwvFX5r5fD+ANN08RiMPZ17ZZUhE9axU8qaPLE3sbdaU8qbhexbD+O
04TX0Zd1NSwVTnbewf1DNOky93NLv5AKF4O4Ny9baRLzzCHaWJQKt56RmrQC
1f7WvWOWB/jwPfvq1opAmmQ6dg7+cz4NkbVxhw6UKklMh4Zt1XQ6mpq0P5QF
TZPDbxOiPCYzwXwSPs9l0RTpks1jsp0FuHuwQlPvrYIwXs9ksNtugJfIkrWd
miSMXh/1p4F5kF+MjieQk9vPnVfeTb2NbN1OE754gmTWlSefOleEDC9WRONv
44SbUmusXX8Pp0KDopZ4jhHu60f3w1c+RLTG35ERklEii410tuGWIiim1rrl
5gix8z8XqOZRhkuP+/gZITLC9w+ytjhdjofv7ObmLZYSv6YjjR72z2Cl7+bu
99cQcZxg+SS2VOOOfXxId88AKT7x5/7Y0Rd4V1loweH0kzodoamCXYu+ZZec
yL0e8nOcRYAZpx4GJ3M5y9XEJLh0uVq4diOWcahlOR87yO7erGK15iac3iCp
exDVSrxEAdXxrS0w8stP/np+A+E5GLHyukS4M1GpV21dQ7gVGTbODW+Q0953
fjCulCzgG4iuTHRgz7ZFxe37BMSOr25a8bkTD7Sim58ezUbdtfs+Die64Nyt
Zha7kyCu5miOfZIYVrJHk6ufPkdaWipvw/lueGa3vfLZ2YC5u7luCzN6sNHb
UGP8bitOTo9PCa72IimwNcZR2IEWoY00LaEPVT5MHa6hGJES8Rgnph8SS6OT
DZd7YGrTyxPueo+jR5YGJRn3g6e2PanebgCtHfq++6sHENYgz3X/PADecdf3
s7YOQRZ05ltB0SDKl7oklGtKoRxQk88I+wDbOSUDgs0yzHU1a7LSGwKz5OBG
zfgRDKfXsUczh8BQqOdGdI/i08iKlCusYXza9nhvpc0Y3BWha13zhtHODlxo
EzeO5pyEdXOsJTi8Q99gcccEpLqX5isTJTBJ6d05gymH4dk+a1avBPm7Mm98
jJpEPrs86YWLFDvW/rK5+rECPxXuY3mdkKJw76HFq6c+I+vCPj0HoRRyLQ+N
B/7TEH1hxc6WSuFbv4bD5CtRklszg72QgtYa7bKSK0r0CvP2DqtcJnizZXe2
Elv9Sl0Fiyg4Rh0PSs9Xos8p+IyhGQVdc2GiSaUSFl9uDhi0oPA81KnHaFQJ
68KvmDG2FNxmL0nW3UrDtqR4aDuLgvxHuWn+NhoXk8cxrXJBe1WO9w4aXDex
+XUnCmYF+x8lBtNIzMw5PbGCwpS/oF/rOI3V1QHiCxwKwmzztbOu0yh42GxX
tIZCmA5Vdf0WjU0zedv9XSnYRpb6biqkkfnNep1PKqd47fn+1xIaERGjDqvW
UYgYufyHRiMNu3ehLvfdKNjvCjHLFtHI8tLtCVhPQVyxKte9k4bnApH5uMpc
vqg0dpBGzu8vvR09KMxWv+lpSdFIkIXglcrkYGTTkzEa3bYm5T9soHCseVMg
T0FDMazfprmRwv//BaHsXOw1lf8FCd+AxA==
       "]]},
     Annotation[#, "Charting`Private`Tag$216906#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-2, 2}, {0., 0.9772498636443946}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.908997280191951*^9, 3.90899729336027*^9}},
 CellLabel->
  "Out[115]=",ExpressionUUID->"f7cd7568-190e-4cb9-9351-ead1e9b48153"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"mu1", "-", 
    RowBox[{"mu1", "*", 
     RowBox[{"Phi", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", "*", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", "*", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
            RowBox[{
             RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
          RowBox[{"sigma", "^", "2"}], "*", 
          RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"sigma", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "Pi"}], "]"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
           RowBox[{
            RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
         RowBox[{"sigma", "^", "2"}], " ", 
         RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", "2"}], 
          RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
           RowBox[{"sigma", "^", "2"}], 
           RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], " ", 
  "\[Equal]", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"mu1", ",", "sigma"}], "]"}], ",", "x1"}], "]"}], "*", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"mu2", ",", "sigma"}], "]"}], ",", "x2"}], "]"}], "*", 
     RowBox[{"Phi", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"Pi", "/", "8"}], "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "t", "]"}], "*", "mu1"}], "+", 
         RowBox[{
          RowBox[{"m2", "[", "t", "]"}], "*", "mu2"}]}], ")"}]}], "]"}], "*", 
     "x1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", 
      RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x2", ",", 
      RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.908999040008127*^9, 
  3.908999173939208*^9}},ExpressionUUID->"1deb85d0-ae0c-4a70-b400-\
5cf8d851d781"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", "1"}], "]"}], ",", "x1"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"Phi", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Pi", "/", "8"}], "]"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m1", "[", "t", "]"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sigma", "*", "x1"}], "+", "mu1"}], ")"}]}], ")"}]}], 
       "]"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sigma", "*", "x1"}], "+", "mu1"}], ")"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"m1", "[", "t", "]"}], "\[Rule]", "0.42"}], ",", 
      RowBox[{
       RowBox[{"m2", "[", "t", "]"}], "\[Rule]", "0.0"}], ",", 
      RowBox[{"mu1", "\[Rule]", 
       RowBox[{"-", "3.42"}]}], ",", 
      RowBox[{"mu2", "\[Rule]", "1.22"}], ",", 
      RowBox[{"sigma", "\[Rule]", "0.2"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.908999181699835*^9, 3.90899922164701*^9}, {
  3.908999260453567*^9, 3.908999264789647*^9}, {3.90899935680313*^9, 
  3.908999362575502*^9}, {3.908999398378113*^9, 3.9089993985534163`*^9}, {
  3.90899946456004*^9, 3.908999469517735*^9}, {3.908999537171023*^9, 
  3.908999537385684*^9}, {3.908999575487977*^9, 3.908999634645257*^9}, {
  3.9089996809368477`*^9, 3.9089996948535547`*^9}, {3.9089997945246773`*^9, 
  3.9089998371220493`*^9}, {3.908999975572506*^9, 3.9089999804549217`*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"b0524f75-ac64-4208-bd88-f4c463577ebf"],

Cell[BoxData[
 RowBox[{"-", "0.6276999095796176`"}]], "Output",
 CellChangeTimes->{
  3.908999224112599*^9, 3.9089992657091618`*^9, {3.908999357773425*^9, 
   3.9089993636243687`*^9}, 3.9089994012100573`*^9, 3.9089994701596937`*^9, 
   3.9089995378913927`*^9, {3.908999590240634*^9, 3.908999635526781*^9}, {
   3.9089996821822844`*^9, 3.908999695547757*^9}, {3.9089997953057823`*^9, 
   3.908999837587261*^9}, 3.909000025146555*^9},
 CellLabel->
  "Out[148]=",ExpressionUUID->"269f2386-04dd-4dbc-af3a-a0bab18edc09"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Phi", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sigma", "*", "u"}], "+", "mu1"}], ")"}], "*", "w1", "*", 
          
          RowBox[{"Sqrt", "[", 
           RowBox[{"Pi", "/", "8"}], "]"}]}], "]"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"sigma", "*", "u"}], "+", "mu1"}], ")"}]}], ")"}], "*", 
      RowBox[{"PDF", "[", 
       RowBox[{
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "1"}], "]"}], ",", "u"}], "]"}]}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w1", "\[Rule]", "0.42"}], ",", 
      RowBox[{
       RowBox[{"m2", "[", "t", "]"}], "\[Rule]", "0.0"}], ",", 
      RowBox[{"mu1", "\[Rule]", 
       RowBox[{"-", "3.42"}]}], ",", 
      RowBox[{"mu2", "\[Rule]", "0"}], ",", 
      RowBox[{"sigma", "\[Rule]", "0.1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "80"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.909000029993476*^9, 3.909000040976716*^9}, {
  3.909000079673868*^9, 3.90900008269238*^9}, {3.909000114427269*^9, 
  3.909000159784053*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"7f1b45e3-2344-40cf-97bb-691519533a76"],

Cell[BoxData[
 RowBox[{"-", "0.62895052540330021632761493907442813553`10."}]], "Output",
 CellChangeTimes->{{3.909000037955112*^9, 3.909000041346408*^9}, {
  3.909000080755169*^9, 3.909000083089554*^9}, {3.909000116416534*^9, 
  3.9090001604321823`*^9}},
 CellLabel->
  "Out[160]=",ExpressionUUID->"a1e48e2a-0729-4c4c-aaac-01a3342bfe31"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"mu1", ",", "sigma"}], "]"}], ",", "x1"}], "]"}], "*", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"mu2", ",", "sigma"}], "]"}], ",", "x2"}], "]"}], "*", 
     RowBox[{"Phi", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"Pi", "/", "8"}], "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "t", "]"}], "*", "x1"}], "+", 
         RowBox[{
          RowBox[{"m2", "[", "t", "]"}], "*", "x2"}]}], ")"}]}], "]"}], "*", 
     "x1"}], "/.", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"m1", "[", "t", "]"}], ",", 
        RowBox[{"m2", "[", "t", "]"}], ",", "mu1", ",", "mu2", ",", "sigma"}],
        "}"}], "\[Rule]", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "80"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9090003903048773`*^9, 3.909000415746604*^9}, {
  3.909000465981193*^9, 3.9090004679743443`*^9}, {3.909000576677862*^9, 
  3.909000590099578*^9}, {3.909000622764359*^9, 3.9090006250635157`*^9}, {
  3.909000701119442*^9, 3.9090007128159113`*^9}, {3.909000818789859*^9, 
  3.9090008452207413`*^9}, {3.909001121102656*^9, 3.9090011259487753`*^9}},
 CellLabel->
  "In[212]:=",ExpressionUUID->"d9f52799-9410-4b4f-8aa9-6dfcba0c0010"],

Cell[BoxData["0.00435555105237513642108494683039719161`10."], "Output",
 CellChangeTimes->{{3.909000400900342*^9, 3.909000416151349*^9}, {
   3.909000587730281*^9, 3.9090006254110823`*^9}, {3.909000696229702*^9, 
   3.90900070293449*^9}, 3.909000734289379*^9, {3.909000823526445*^9, 
   3.909000845810521*^9}, {3.909001126794594*^9, 3.909001133254457*^9}},
 CellLabel->
  "Out[212]=",ExpressionUUID->"d1df9530-8044-4249-b2cc-993d096cc0a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"mu1", "*", 
     RowBox[{"Phi", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", "*", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", "*", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
            RowBox[{
             RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
          RowBox[{"sigma", "^", "2"}], "*", 
          RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"sigma", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "Pi"}], "]"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
           RowBox[{
            RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
         RowBox[{"sigma", "^", "2"}], " ", 
         RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", "2"}], 
          RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
           RowBox[{"sigma", "^", "2"}], 
           RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], "/.", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"m1", "[", "t", "]"}], ",", 
      RowBox[{"m2", "[", "t", "]"}], ",", "mu1", ",", "mu2", ",", "sigma"}], 
     "}"}], "\[Rule]", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.909000437785713*^9, {3.909000470715373*^9, 3.909000480319847*^9}, {
   3.909000566656267*^9, 3.909000570263604*^9}, {3.909000828232238*^9, 
   3.909000836648197*^9}, 3.909001005948832*^9, 3.909001115934219*^9},
 CellLabel->
  "In[211]:=",ExpressionUUID->"f6a7fe64-45e3-4dd0-ac1f-8a587da271e2"],

Cell[BoxData["0.00438016616225032`"], "Output",
 CellChangeTimes->{{3.909000430523581*^9, 3.9090004382232656`*^9}, 
   3.9090004820095997`*^9, {3.909000567556694*^9, 3.909000570840798*^9}, {
   3.909000826427436*^9, 3.90900084774893*^9}, 3.909001006419092*^9, {
   3.909001116557745*^9, 3.909001132096414*^9}},
 CellLabel->
  "Out[211]=",ExpressionUUID->"2276ba18-0707-4ad5-a3a9-e6072e4cb854"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m1", "[", "t", "]"}], ",", 
     RowBox[{"m2", "[", "t", "]"}], ",", "mu1", ",", "mu2", ",", "sigma"}], 
    "}"}], "\[Rule]", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.909000953594715*^9, 3.909001024215591*^9}, {
  3.909001087284931*^9, 3.909001092662857*^9}},
 CellLabel->
  "In[207]:=",ExpressionUUID->"e2efd2e7-e7e5-437b-97b8-b0e3b1e285a0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"m1", "[", "t", "]"}], "\[Rule]", 
    RowBox[{"-", "1.5906950868656011`"}]}], ",", 
   RowBox[{
    RowBox[{"m2", "[", "t", "]"}], "\[Rule]", 
    RowBox[{"-", "1.1199555733810396`"}]}], ",", 
   RowBox[{"mu1", "\[Rule]", 
    RowBox[{"-", "2.0744421898886847`"}]}], ",", 
   RowBox[{"mu2", "\[Rule]", "2.830124151901739`"}], ",", 
   RowBox[{"sigma", "\[Rule]", 
    RowBox[{"-", "1.4053371027856247`"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.909000977464942*^9, 3.9090010248618507`*^9}, {
  3.9090010930968513`*^9, 3.909001108665944*^9}},
 CellLabel->
  "Out[207]=",ExpressionUUID->"260b0670-b345-4621-a8e7-793e810d194f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", "5"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.909001016391765*^9, 3.9090010201840143`*^9}, {
  3.909001105245873*^9, 3.909001106657686*^9}},
 CellLabel->
  "In[210]:=",ExpressionUUID->"7e57e9a3-43d3-4b7b-a7c4-08a1047b4ed5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.604057283564946`"}], ",", 
   RowBox[{"-", "0.5288987387126092`"}], ",", "1.6671380304083652`", ",", 
   "0.5221932152803976`", ",", "0.19334501990299557`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9090010206534233`*^9, {3.909001107075404*^9, 3.90900113048029*^9}},
 CellLabel->
  "Out[210]=",ExpressionUUID->"94b055a8-2c05-4a00-9a7b-90a3e089638f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Anisotropic", "Subsection",
 CellChangeTimes->{{3.917958765321759*^9, 
  3.917958767880863*^9}},ExpressionUUID->"4d9212af-6c49-4dab-9065-\
0fe27ae9ad69"],

Cell[BoxData[
 RowBox[{
  RowBox[{"snrslan", "[", "eps_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"sslan", " ", "=", " ", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "0", "]"}], "\[Equal]", "0.0"}], ",", 
         RowBox[{
          RowBox[{"m2", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu1", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma1", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
            ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", "1"}], ",", 
            RowBox[{"mu2", "\[Rule]", "0"}], ",", 
            RowBox[{
             RowBox[{"sigma1", "^", "2"}], "\[Rule]", 
             RowBox[{"1", "+", "eps"}]}], ",", 
            RowBox[{
             RowBox[{"sigma2", "^", "2"}], "\[Rule]", 
             RowBox[{"1", "-", "eps"}]}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu2", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma2", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
            ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", "1"}], ",", 
            RowBox[{"mu2", "\[Rule]", "0"}], ",", 
            RowBox[{
             RowBox[{"sigma1", "^", "2"}], "\[Rule]", 
             RowBox[{"1", "+", "eps"}]}], ",", 
            RowBox[{
             RowBox[{"sigma2", "^", "2"}], "\[Rule]", 
             RowBox[{"1", "-", "eps"}]}]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", "m2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t0", ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"m1", "[", "t", "]"}], ")"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], "/.", 
             "sslan"}], "]"}], "/.", 
           RowBox[{"t", "\[Rule]", "t0"}]}], ")"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t0", ",", "0.1", ",", "40", ",", "0.005"}], "}"}]}], "]"}]}], 
   ")"}]}]], "Input",
 CellChangeTimes->{{3.917958715004196*^9, 3.917958744088745*^9}, {
   3.917958777394957*^9, 3.9179587777733917`*^9}, {3.917958817349889*^9, 
   3.917958826950333*^9}, {3.917958969438876*^9, 3.917958969965785*^9}, 
   3.91795900061226*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"80494aa0-e784-4e4f-bae1-9fc8f2ecd1bd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"longtabslan", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eps", ",", 
      RowBox[{"snrslan", "[", "eps", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"eps", ",", 
      RowBox[{"-", "0.5"}], ",", "0.5", ",", "0.01"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.917958757896976*^9, 3.91795879157927*^9}, {
  3.917959021856556*^9, 3.917959022166617*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"f7cca346-1a89-42ab-aeb7-5136f2bdc56d"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.5`"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0.1`", ",", "0.05068856119052861`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.10500000000000001`", ",", "0.05325594473551895`"}],
                 "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.11`", ",", "0.055826131991318716`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.115`", ",", "0.05839907495112045`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.12000000000000001`", ",", "0.06097472527113132`"}],
                 "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.125`", ",", "0.06355303486547079`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.13`", ",", "0.06613395492431538`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.135`", ",", "0.06871743609677831`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.14`", ",", "0.07130342864604781`"}], "}"}], ",", 
               TemplateBox[{"7963"},
                "OutputSizeLimit`Skeleton"], ",", 
               RowBox[{"{", 
                RowBox[{"39.96`", ",", "0.9999999604986654`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.965`", ",", "0.9999999605523027`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.97`", ",", "0.9999999606058648`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.975`", ",", "0.9999999606593521`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.980000000000004`", ",", "0.9999999607127649`"}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.985`", ",", "0.9999999607661033`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.99`", ",", "0.9999999608193672`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.995000000000005`", ",", "0.9999999608725565`"}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"40.`", ",", "0.9999999609256717`"}], "}"}]}], 
              "}"}]}], "}"}], ",", 
           TemplateBox[{"99"},
            "OutputSizeLimit`Skeleton"], ",", 
           RowBox[{"{", 
            RowBox[{"0.5`", ",", 
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"]}], "}"}]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{97.06640625, {4., 12.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{86.19140625, {1., 12.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 35, 33922758232107892877, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{97.0546875, {1., 12.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 35, 33922758232107892877, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{72.796875, {1., 12.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 35, 33922758232107892877, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{131.1328125, {1., 12.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[33922758232107892877 === $SessionID, 
   Out[35], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.917959015383132*^9, 3.917959056728657*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"e050fcbc-b423-4e39-85cf-b82f6055aed6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"learntimesslan", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"el", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"el", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ">", "0.8"}], "&"}], ",", "1"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"el", ",", "longtabslan"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.917958994069257*^9, 3.9179589964268312`*^9}, {
  3.917959080298778*^9, 3.9179591036677637`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"1388f3c5-d1ca-44fe-8850-5303a2dd89cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1.955`", ",", "0.800231303466797`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.49`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1.965`", ",", "0.8005337964905496`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.48`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1.975`", ",", "0.8008127607177635`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.47`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1.9800000000000002`", ",", "0.8001204686700616`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.46`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1.9900000000000002`", ",", "0.8003612078388496`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.45`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", "0.8005787968889116`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.44`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.0100000000000002`", ",", "0.8007733927829833`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.43`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.015`", ",", "0.800025256135563`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.42`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.025`", ",", "0.8001821617149647`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.41000000000000003`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.035`", ",", "0.8003164043479187`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.045`", ",", "0.8004280994528571`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.39`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.055`", ",", "0.8005173741627736`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.38`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.065`", ",", "0.8005843491974113`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.37`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.075`", ",", "0.8006291389361291`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.36`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.085`", ",", "0.8006518514923737`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.35`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.095`", ",", "0.8006525887916621`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.33999999999999997`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.105`", ",", "0.8006314466555662`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.32999999999999996`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.115`", ",", "0.8005885148472516`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.32`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.125`", ",", "0.800523876714866`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.31`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.1350000000000002`", ",", "0.8004376094175685`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.145`", ",", "0.8003297842261938`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.29000000000000004`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.1550000000000002`", ",", "0.8002004665751972`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.28`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.165`", ",", "0.8000497161160356`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.27`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.18`", ",", "0.8006847424810157`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.26`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.19`", ",", "0.8004850686946823`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.25`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.2`", ",", "0.8002641924710501`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.24`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.21`", ",", "0.8000221494561177`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.22999999999999998`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.225`", ",", "0.8005384160041279`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.21999999999999997`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.2350000000000003`", ",", "0.8002482910462494`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.21000000000000002`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.25`", ",", "0.800701756301811`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.2600000000000002`", ",", "0.8003639844083613`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.19`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.27`", ",", "0.8000052902132758`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.18`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.285`", ",", "0.8003704658450688`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.16999999999999998`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.3000000000000003`", ",", "0.8007008939409237`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.15999999999999998`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.31`", ",", "0.8002688084177718`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.14999999999999997`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.325`", ",", "0.8005388276216704`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.14`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.335`", ",", "0.8000599695860694`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.13`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.35`", ",", "0.8002702369267174`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.12`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.365`", ",", "0.8004469661788199`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.10999999999999999`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.3800000000000003`", ",", "0.8005903986529186`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.09999999999999998`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.39`", ",", "0.800013669977753`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.08999999999999997`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.4050000000000002`", ",", "0.8000985683941212`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.08000000000000002`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.42`", ",", "0.8001507517417888`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.07`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.435`", ",", "0.8001704158599792`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.06`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.45`", ",", "0.8001577398849482`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.04999999999999999`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.4650000000000003`", ",", "0.8001128959452448`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.03999999999999998`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.48`", ",", "0.8000360497805433`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.02999999999999997`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.5`", ",", "0.8005659436546639`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.020000000000000018`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.515`", ",", "0.8004191112631922`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.010000000000000009`"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.5300000000000002`", ",", "0.8002408021252293`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.545`", ",", "0.8000311143256174`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.010000000000000009`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.565`", ",", "0.800401379606447`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.020000000000000018`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.58`", ",", "0.8001232263261027`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.030000000000000027`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.6`", ",", "0.8004113127321305`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.040000000000000036`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.615`", ",", "0.8000654231051527`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.050000000000000044`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.6350000000000002`", ",", "0.8002724969956385`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06000000000000005`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.6550000000000002`", ",", "0.8004356865367488`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07000000000000006`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.6750000000000003`", ",", "0.8005553856224579`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07999999999999996`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.69`", ",", "0.8000702498528033`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.08999999999999997`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.71`", ",", "0.8001110939975435`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.09999999999999998`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.73`", ",", "0.8001092958450754`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.10999999999999999`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.75`", ",", "0.800065139011097`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.12`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.7750000000000004`", ",", "0.8005132824891892`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.13`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.795`", ",", "0.8003787164485111`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.14`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.815`", ",", "0.8002026490793853`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.15000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.8400000000000003`", ",", "0.8004989473701398`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.16000000000000003`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.8600000000000003`", ",", "0.80023432241618`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.17000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.8850000000000002`", ",", "0.8004289106182857`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.18000000000000005`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.9050000000000002`", ",", "0.8000768257414684`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.19000000000000006`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.93`", ",", "0.8001712722261056`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.20000000000000007`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.955`", ",", "0.8002126097024381`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.20999999999999996`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.98`", ",", "0.800201276185143`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.21999999999999997`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.0050000000000003`", ",", "0.8001376833948787`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.22999999999999998`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.0300000000000002`", ",", "0.8000222171215366`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.24`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.06`", ",", "0.800307518390626`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.25`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.085`", ",", "0.8000830562725413`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.26`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.115`", ",", "0.8002464558707091`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.27`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.145`", ",", "0.800346122451751`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.28`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1750000000000003`", ",", "0.8003827111066337`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.29000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.205`", ",", "0.8003568351627118`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.30000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2350000000000003`", ",", "0.800269037398938`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.31000000000000005`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.265`", ",", "0.8001197666854494`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.32000000000000006`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3000000000000003`", ",", "0.800306975884688`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.33000000000000007`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.33`", ",", "0.8000298431570076`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.33999999999999997`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.365`", ",", "0.8000770034686275`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.35`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.4000000000000004`", ",", "0.8000517007118089`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.36`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.44`", ",", "0.8003248739085602`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.37`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.475`", ",", "0.8001501965025678`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.38`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.515`", ",", "0.8002618643439411`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.39`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.555`", ",", "0.8002906584816966`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.595`", ",", "0.8002375056973042`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.41000000000000003`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.6350000000000002`", ",", "0.8001031912027418`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.42000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.68`", ",", "0.8002183051534094`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.43000000000000005`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.725`", ",", "0.8002407538809646`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.44000000000000006`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.77`", ",", "0.8001716527483552`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.45000000000000007`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.815`", ",", "0.8000119416638436`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.45999999999999996`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.865`", ",", "0.8000657079545521`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.47`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.915`", ",", "0.8000178690814568`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.48`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.97`", ",", "0.8001591939014189`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.49`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.025`", ",", "0.8001881607401286`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.08`", ",", "0.8001063469475909`"}], "}"}], "}"}]}], "}"}]}],
   "}"}]], "Output",
 CellChangeTimes->{{3.917958997475359*^9, 3.917959004907011*^9}, {
  3.917959083370405*^9, 3.9179591040971317`*^9}},
 CellLabel->"Out[38]=",ExpressionUUID->"6c3e6311-69cd-46e2-8168-5b98b5050baf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"el", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"el", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"el", ",", "learntimesslan"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.917959093936233*^9, 3.917959094163265*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"7fc0a213-47e0-4d83-91e6-b5f27bc250b6"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw9VTtMFFEUfTOz/w9QaGGzaoeWaovvdtpKLKlM0FLsDFpYiK0WFmqMIYHG
ZtWEREiMD2GNnwABF9x1hXWxxcIG23XnnnN5CZlh5s6555z72dPXbo5Pxs65
ycFfesXphcv708fql/p+4uHK4ejEr3BrrNSam+r7xdrMwZXFbnj2ND19Pwga
RHbDq/RS73vE7YX23NTgru/X19KzGwgsZxRwNxzX75ykaLWZn+Gk3jjRtPud
cF6Pk4sp3FiHfJwg748AXk7+jaZ3bfJzMq4E2wG4TjRNvUW+ThSu1Ap47uS6
nu9h9TAFcrKi152AMCcqt7YT/qRwB07uqOBt6okEcU3qiQS8mwE6I3mkgN8C
dEQCnK0AnpFA1xb5RzKfws1tkn8kyLNJ/pHA/w3yj0TDp9YDfI5E7RhdC7/V
x0hw/Uq+Mf37Qr4x/fpMvjH9+US/Y/rxMdxQn2JRuOlGgA+xnFO9q+QXU98H
8oupZ5n8YvJ/Tz9j8n0Xypo3kSeKs8R+SKSgz9/Sv0Tuat4F1j9hvjfkkxC/
Tj6G9zIs6fNEbmvcPOubyGt9/oL+ZOSevn/M/Pb/febPiE0I8h+996jX0fce
ujOyDHzOgb2f9+CdkVnw86hHlvF1j3xZ+Qt9Hv5nyX+B+bLmj4ffWfPPQ1/W
/PVgnTP//QWtW87qwznPWf2InxPErXr4l6P/DY++ykkD/UH+eamgf8g/L1fR
X9wLeXmO/qM/eemhP8k3b/3r0Q8F62/iFaz/PepdsPmg/oLND/0t2Hx59HfR
5o9+Fm0+yadIvU3qKwr2WNOjH0rUv83vS3IK+4Hfl2x/MH/J9gv9Ltv+ob9l
20/sj7LtL+ar2H6jfxXbfx77qmL7kf5XOe8dxlflAfYr8atyFvuXfgzJBvYz
+QzR7z3yHxLudw9ew/S/y/zDwt8Hr7xOjLAePcaPyH+Gr+Bp
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.5, 0.5}, {0, 4.08}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9179590950356627`*^9, 3.917959106168285*^9}},
 CellLabel->"Out[39]=",ExpressionUUID->"98ea145e-e79a-4420-bd67-d03289789dc9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<outslanlearntimes.csv\>\"", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"el", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"el", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"el", ",", "learntimesslan"}], "}"}]}], "]"}], ",", 
   "\"\<CSV\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.925251593405096*^9, 
  3.925251599073951*^9}},ExpressionUUID->"0ccbeb79-a2a7-478d-a3da-\
dae04087cfac"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Isotropic", "Subsection",
 CellChangeTimes->{{3.917958760078146*^9, 
  3.917958761800651*^9}},ExpressionUUID->"d6069626-a3d9-4574-b50f-\
c665d06adc1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"snrsl", "[", "sig_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"ssl", " ", "=", " ", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"m2", "[", "0", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu1", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                   RowBox[{"sigma", "^", "2"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{"sigma", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                  RowBox[{"sigma", "^", "2"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
            ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sig"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu2", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                   RowBox[{"sigma", "^", "2"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{"sigma", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                  RowBox[{"sigma", "^", "2"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
            ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sig"}]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", "m2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t0", ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], "*", 
                 RowBox[{"1", "/", 
                  RowBox[{"Sqrt", "[", "2", "]"}]}]}], "+", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], "*", 
                 RowBox[{"1", "/", 
                  RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ")"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], "/.", 
             "ssl"}], "]"}], "/.", 
           RowBox[{"t", "\[Rule]", "t0"}]}], ")"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t0", ",", "0.1", ",", "40", ",", "0.005"}], "}"}]}], "]"}]}], 
   ")"}]}]], "Input",
 CellChangeTimes->{{3.9094218888665447`*^9, 3.909421897943305*^9}, {
  3.909421992492016*^9, 3.909422035559548*^9}, {3.909422071203059*^9, 
  3.909422073617589*^9}},
 CellLabel->
  "In[391]:=",ExpressionUUID->"93c93273-b824-4228-bb23-69c5f30d7672"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"longtabsl", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sig", ",", 
      RowBox[{"snrsl", "[", "sig", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"sig", ",", "0.01", ",", "1.01", ",", "0.01"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.909422047613473*^9, 3.909422050057019*^9}},
 CellLabel->
  "In[392]:=",ExpressionUUID->"262319db-cc54-4799-9461-4546f4c38717"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          TemplateBox[{"1"},
           "OutputSizeLimit`Skeleton"], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{97.06640625, {4., 12.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{86.19140625, {1., 12.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 392, 33952755406031144400, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{97.0546875, {1., 12.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 392, 33952755406031144400, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{72.796875, {1., 12.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 392, 33952755406031144400, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{131.1328125, {1., 12.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[33952755406031144400 === $SessionID, 
   Out[392], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.909422067920803*^9, 3.909422132095623*^9, 
  3.925251548518014*^9},
 CellLabel->
  "Out[392]=",ExpressionUUID->"9f9eee46-c9a0-4a48-b215-6e9a4fa4bf26"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"learntimessl", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"el", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"el", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ">", "0.8"}], "&"}], ",", "1"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"el", ",", "longtabsl"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.909422139958762*^9, 3.9094221441661386`*^9}},
 CellLabel->
  "In[393]:=",ExpressionUUID->"0693e7cf-2b25-49e9-bfe9-8b7af439e5fb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.01`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.17`", ",", "0.8000418678851089`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.02`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.17`", ",", "0.8001012506538254`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.17`", ",", "0.8002001652922586`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.04`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.165`", ",", "0.8001203148310019`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.05`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.16`", ",", "0.8000790961671028`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.060000000000000005`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.154999999999999`", ",", "0.8000762900652179`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06999999999999999`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.1499999999999995`", ",", "0.8001116596196649`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.08`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.145`", ",", "0.8001849234154734`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.09`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.135`", ",", "0.800073802933598`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.09999999999999999`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.13`", ",", "0.8002211900515372`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.11`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.12`", ",", "0.8001814952142885`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.12`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.109999999999999`", ",", "0.8001762290632488`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.13`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.1`", ",", "0.8002049064848137`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.14`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.085`", ",", "0.8000385958273101`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.15000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.075`", ",", "0.8001322453859988`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.16`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.06`", ",", "0.8000264846829017`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.17`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.05`", ",", "0.8001828070881243`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.18000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.035`", ",", "0.8001351128828358`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.19`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.02`", ",", "0.8001144579455904`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"4.005`", ",", "0.8001201438302795`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.21000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.99`", ",", "0.8001514612731232`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.22`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.975`", ",", "0.8002076917332716`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.23`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.955`", ",", "0.8000418069058686`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.24000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.94`", ",", "0.8001434626819992`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.25`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.9200000000000004`", ",", "0.800016409509633`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.26`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.9050000000000002`", ",", "0.8001603810032771`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.27`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.8850000000000002`", ",", "0.8000689067792652`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.28`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.87`", ",", "0.8002521175535667`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.29000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.85`", ",", "0.8001929525951824`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.3`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.83`", ",", "0.8001471718138831`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.31`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.81`", ",", "0.8001139146332081`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.32`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.79`", ",", "0.8000923239056629`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.33`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.77`", ",", "0.8000815467547826`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.34`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.75`", ",", "0.8000807353406566`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.35000000000000003`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.73`", ",", "0.8000890475498247`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.36000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.71`", ",", "0.8001056476224944`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.37`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.69`", ",", "0.8001297066675347`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.38`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.6700000000000004`", ",", "0.8001604031434775`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.39`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.6500000000000004`", ",", "0.800196923278861`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.6300000000000003`", ",", "0.8002384613973634`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.41000000000000003`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.6100000000000003`", ",", "0.8002842201894951`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.42000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.585`", ",", "0.8000264022244653`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.43`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.565`", ",", "0.8000744581434155`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.44`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.5450000000000004`", ",", "0.8001243377847371`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.45`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.5250000000000004`", ",", "0.800175278009574`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.46`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.5050000000000003`", ",", "0.8002265244803317`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.47000000000000003`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.4850000000000003`", ",", "0.8002773316007162`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.48000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.4650000000000003`", ",", "0.8003269624103008`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.49`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.44`", ",", "0.8000390379471423`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.4200000000000004`", ",", "0.8000799179122726`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.51`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.4000000000000004`", ",", "0.8001173965766005`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.52`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3800000000000003`", ",", "0.8001507684411263`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.53`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3600000000000003`", ",", "0.8001793354643877`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.54`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3400000000000003`", ",", "0.8002024067363998`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.55`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3200000000000003`", ",", "0.8002192981241087`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.56`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3000000000000003`", ",", "0.8002293318903864`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5700000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2800000000000002`", ",", "0.8002318362884707`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5800000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2600000000000002`", ",", "0.800226145133644`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.59`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.24`", ",", "0.8002115973538183`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.6`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.22`", ",", "0.8001875365205887`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.61`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2`", ",", "0.800153310362185`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.62`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.18`", ",", "0.8001082702596507`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.63`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.16`", ",", "0.8000517707274641`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.64`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.145`", ",", "0.8003895175611603`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.65`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.125`", ",", "0.8003135133303597`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.66`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.105`", ",", "0.8002242158613903`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.67`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.085`", ",", "0.8001209889751876`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.68`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.065`", ",", "0.8000031969104803`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.6900000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.0500000000000003`", ",", "0.8003028595102277`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7000000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.0300000000000002`", ",", "0.800159813098974`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7100000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.0100000000000002`", ",", "0.8000003914314623`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.72`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.995`", ",", "0.8002728856098204`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.73`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.975`", ",", "0.8000848656843517`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.74`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.96`", ",", "0.8003383935567997`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.75`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.94`", ",", "0.8001196119451053`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.76`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.9250000000000003`", ",", "0.8003523401923905`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.77`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.9050000000000002`", ",", "0.8001006320603995`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.78`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.89`", ",", "0.800310738488918`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.79`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.87`", ",", "0.8000239297817511`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.855`", ",", "0.8002095963005184`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.81`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.8400000000000003`", ",", "0.8003849885294743`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8200000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.8200000000000003`", ",", "0.8000449013300697`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8300000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.805`", ",", "0.8001932043178871`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.8400000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.79`", ",", "0.8003300268072767`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.85`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.7750000000000004`", ",", "0.8004549917042969`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.86`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.7550000000000003`", ",", "0.8000390530043519`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.87`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.74`", ",", "0.8001334289014511`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.88`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.725`", ",", "0.8002147346657926`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.89`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.71`", ",", "0.8002825907384064`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.9`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.6950000000000003`", ",", "0.8003366165491357`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.91`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.68`", ",", "0.8003764301832827`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.92`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.665`", ",", "0.8004016480479531`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.93`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.6500000000000004`", ",", "0.8004118845380143`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9400000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.6350000000000002`", ",", "0.800406751701567`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9500000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.62`", ",", "0.8003858589047796`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.9600000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.605`", ",", "0.8003488124959195`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.97`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.5900000000000003`", ",", "0.8002952154683889`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.98`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.575`", ",", "0.8002246671224839`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.99`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.56`", ",", "0.8001367627255683`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.545`", ",", "0.8000310986635145`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1.01`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2.535`", ",", "0.8005316675156334`"}], "}"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9094221454202642`*^9, 3.925251548774329*^9},
 CellLabel->
  "Out[393]=",ExpressionUUID->"b6829473-3c48-4b55-b637-9f94a391ce34"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"el", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"el", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"el", ",", "learntimessl"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.909422154948083*^9, 3.9094221553497677`*^9}},
 CellLabel->
  "In[394]:=",ExpressionUUID->"faa590d9-3c9f-4ef2-bd21-35661263fd1f"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlDtMFFEUhjdmHjv7mJkCW42xwRpbPKfDgkYaG2xM0FJssZXGBgsbLGyk
0IbExERIjFHR+AgYEHEREXeX18IujwZrZ+751sKbsMNm7zn/+f/v7J67fmto
5FShUBjJ/vLnnZ7pgcbYXclfe6ZTtfcP/r2fOTPevjLz6L/Pp+TC8MTbkyep
PpzMz1OZGu0v1R6nOuvuT4uVpZq9Zv8+E3dtslv/XEwm1awoq3wh7nkvVbs3
K+OuMFWn0/tSrK47zytxcqOpmu5rueFOqh2n90Zc26upXuzLz5wszGdnsKv/
Tlx5f6pzJ72Zwntx1/pSLbvCD+bnfKpDTvCjzdvT9fvJ5vNTbY7ln3wW002Y
d9705hO97YQWyCchny/4S7TgzqJcy8uGE/wsyiU3X6KX89gHluS000/wtyR/
8rFPYr2fl018RS9W87GMXqzOTm2Z/GL8fxPzFetZN8iK8eyNyWNFbK5Yb7pc
v1uetSr51NiHqtqzhp8qea3ip6o256oYhyr5/RDrU1XzuSaWY4U81+hfUev7
k/4V8l2nf0XN9zr9K+T9i/4Vtdw26F8m/w2xZ1ldu+Hf9C/Do07/Mn7q9C/D
p07/Mv7q9C/Bq0H/En4bYpxK8GuI5VrCfxPeJXg24V1Sa9dkvyL4bopxishn
U0wngvemWA4ReW2JzRXBfwveEfltwTtiH7bhXSTPbXgU2Y9t8iqS7w5+iuzL
Dn6K5L2DnyLf9132NyT/XfY3ZJ920Qvh0UIvhEcLvRAeLfRCeLTEfITw2EMv
gMce/gJ47MErgMc+vAJ47JNnwH7u8/0J4NFmPwJ4tNmPAB5t+Pnw6ODXh0cH
vz48Ouj78DhA34fHAfo+PA7Q9+FxSN4+PA7x78HjEP8ePI7w78HjiH3y4HHE
74cHj2Oxex5+jtkvT/8Ct2jTXA==
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 2.4441666666666677`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1.01}, {2.4441666666666677`, 4.17}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.909422155947706*^9, 3.925251548843864*^9},
 CellLabel->
  "Out[394]=",ExpressionUUID->"9aa70592-39d6-44f4-a88a-ba30740e2a5b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<outsllearntimes.csv\>\"", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"el", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"el", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"el", ",", "learntimessl"}], "}"}]}], "]"}], ",", 
   "\"\<CSV\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.909422227783353*^9, 3.9094222390495996`*^9}, 
   3.92525149302383*^9},
 CellLabel->
  "In[395]:=",ExpressionUUID->"7805e56c-387f-46b9-b5c2-92d11b754dfe"],

Cell[BoxData["\<\"outsllearntimes.csv\"\>"], "Output",
 CellChangeTimes->{3.909422241561681*^9, 3.925251548898603*^9},
 CellLabel->
  "Out[395]=",ExpressionUUID->"8125b611-4e17-400a-a23c-d9e7775050b3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Covariance", "Subsection",
 CellChangeTimes->{{3.925228567102805*^9, 3.925228579108572*^9}, {
  3.9252286600460587`*^9, 3.925228660686789*^9}, {3.925228769858121*^9, 
  3.925228851600021*^9}, {3.925228887395034*^9, 3.925228900113146*^9}, {
  3.925228946354959*^9, 3.925228967612215*^9}, {3.925239199218479*^9, 
  3.9252392074686747`*^9}},ExpressionUUID->"e8304d1e-d7c2-4629-94e4-\
fa5fc2181a28"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9252319935136547`*^9, 
  3.925231995028461*^9}},ExpressionUUID->"619a2077-61ca-4f3e-a9ee-\
8b28c9bfea5c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"covterms1", "[", "t", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"C11", "[", "t", "]"}], 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu1", "-", 
          RowBox[{"mu1", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m1", "[", "t", "]"}], ",", 
        RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
     
     RowBox[{"2", 
      RowBox[{"C12", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu1", "-", 
          RowBox[{"mu1", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m1", "[", "t", "]"}], ",", 
        RowBox[{"m2", "[", "t", "]"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"C22", "[", "t", "]"}], 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu1", "-", 
          RowBox[{"mu1", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m2", "[", "t", "]"}], ",", 
        RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.9252396092420273`*^9, 3.925239662700232*^9}, {
  3.925239694900791*^9, 3.925239720822721*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"91fbf0f0-0b64-473b-8377-1b38fd21c279"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SqrtBox["2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"8", "+", 
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["sigma", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}], 
     RowBox[{"9", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", " ", 
           RowBox[{"m1", "[", "t", "]"}]}], "+", 
          RowBox[{"mu2", " ", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox["sigma", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}]}]]}]], 
   " ", "\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"C22", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu2", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox["sigma", "2"], " ", 
             SuperscriptBox[
              RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "4"], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}], "-", 
        RowBox[{"mu1", " ", "mu2", " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "64"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"16", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "4"]}]}], ")"}], " ", 
         RowBox[{"m2", "[", "t", "]"}]}], "-", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"64", " ", 
            SuperscriptBox["mu2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "-", 
           RowBox[{"8", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "4"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "4"], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["mu2", "2"], " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "4"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "-", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "4"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
        RowBox[{"mu1", " ", "mu2", " ", "\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"64", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "8"}], " ", 
               SuperscriptBox["mu1", "2"]}], "+", 
              RowBox[{"32", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "3"}], " ", 
                  SuperscriptBox["mu1", "2"]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]}], ")"}], 
         " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "3"]}], "-", 
        RowBox[{
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "4"], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}], "+", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["mu1", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}], "+", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["mu2", "2"]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "4"]}], "+", 
        RowBox[{"mu1", " ", "mu2", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"24", "+", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "5"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Pi]", "3"], " ", 
         SuperscriptBox["sigma", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu1", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "6"]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"C11", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"mu1", " ", "mu2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu1", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox["sigma", "2"], " ", 
             SuperscriptBox[
              RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}], "3"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "8"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "5"], " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "-", 
        RowBox[{"3", " ", "mu1", " ", "mu2", " ", "\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "-", 
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "-", 
        RowBox[{"mu1", " ", "mu2", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "6"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "4"], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"72", "+", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"9", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"m1", "[", "t", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox["sigma", "2"], " ", 
             SuperscriptBox[
              RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "4"], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "4"], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               SuperscriptBox["mu2", "2"]}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["sigma", "4"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"384", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
           RowBox[{"24", " ", "\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["sigma", "4"]}], "+", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["mu2", "4"]}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["sigma", "4"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C12", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["\[Pi]", "3"], " ", 
         SuperscriptBox["sigma", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu2", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "6"], " ", 
         RowBox[{"m2", "[", "t", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu1", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox["sigma", "2"], " ", 
             SuperscriptBox[
              RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "4"], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{"mu1", " ", "mu2", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "6"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "5"], " ", 
         RowBox[{"(", 
          RowBox[{"24", "+", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "4"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "4"], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"5", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "4"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}], "-", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"5", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{"mu1", " ", "mu2", " ", "\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"64", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["mu1", "2"]}], "-", 
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"8", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["mu1", "2"]}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["mu2", "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}]}], "-", 
        RowBox[{"mu1", " ", "mu2", " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "64"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"16", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}]}], "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "64"}], " ", 
            SuperscriptBox["mu1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox["mu1", "4"]}], "+", 
              SuperscriptBox["mu2", "4"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "4"], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "3"}], " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.925239646519335*^9, 3.925239663420545*^9}, 
   3.925239756291102*^9, 3.925314308489933*^9, 3.925314446758787*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"0b4a4bbf-aeea-468b-99e7-473a463e69a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"covterms2", "[", "t", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"C11", "[", "t", "]"}], 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu2", "-", 
          RowBox[{"mu2", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m1", "[", "t", "]"}], ",", 
        RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
     
     RowBox[{"2", 
      RowBox[{"C12", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu2", "-", 
          RowBox[{"mu2", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m1", "[", "t", "]"}], ",", 
        RowBox[{"m2", "[", "t", "]"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"C22", "[", "t", "]"}], 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu2", "-", 
          RowBox[{"mu2", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m2", "[", "t", "]"}], ",", 
        RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.925239809180113*^9, 3.925239856031341*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"821cfe07-f28d-4ebc-8ed5-38cb548b82c7"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SqrtBox["2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"8", "+", 
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["sigma", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}], 
     RowBox[{"9", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", " ", 
           RowBox[{"m1", "[", "t", "]"}]}], "+", 
          RowBox[{"mu2", " ", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox["sigma", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}]}]]}]], 
   " ", "\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"C22", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"mu1", " ", "mu2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu2", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox["sigma", "2"], " ", 
             SuperscriptBox[
              RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox["sigma", "2"], " ", 
             SuperscriptBox[
              RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "4"], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "4"], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 SuperscriptBox["sigma", "2"]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"m2", "[", "t", "]"}]}], "-", 
        RowBox[{"3", " ", "mu1", " ", "mu2", " ", "\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["mu1", "2"]}], "+", 
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["sigma", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"384", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
           RowBox[{"24", " ", "\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               SuperscriptBox["mu2", "2"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 SuperscriptBox["sigma", "2"]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["mu1", "4"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               SuperscriptBox["mu2", "2"]}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 SuperscriptBox["sigma", "2"]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "4"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "3"]}], "-", 
        RowBox[{"mu1", " ", "mu2", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "6"], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"72", "+", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"9", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "5"]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"C12", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu2", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox["sigma", "2"], " ", 
             SuperscriptBox[
              RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "4"], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}], "-", 
        RowBox[{"mu1", " ", "mu2", " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "64"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"16", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "4"]}]}], ")"}], " ", 
         RowBox[{"m2", "[", "t", "]"}]}], "-", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"64", " ", 
            SuperscriptBox["mu2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "-", 
           RowBox[{"8", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "4"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "4"], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["mu2", "2"], " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "4"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "-", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "4"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
        RowBox[{"mu1", " ", "mu2", " ", "\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"64", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "8"}], " ", 
               SuperscriptBox["mu1", "2"]}], "+", 
              RowBox[{"32", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "3"}], " ", 
                  SuperscriptBox["mu1", "2"]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]}], ")"}], 
         " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "3"]}], "-", 
        RowBox[{
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "4"], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}], "+", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["mu1", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}], "+", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["mu2", "2"]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "4"]}], "+", 
        RowBox[{"mu1", " ", "mu2", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"24", "+", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "5"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Pi]", "3"], " ", 
         SuperscriptBox["sigma", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu1", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "6"]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"C11", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["\[Pi]", "3"], " ", 
         SuperscriptBox["sigma", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu2", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "6"], " ", 
         RowBox[{"m2", "[", "t", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu1", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox["sigma", "2"], " ", 
             SuperscriptBox[
              RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "4"], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{"mu1", " ", "mu2", " ", 
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "6"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "5"], " ", 
         RowBox[{"(", 
          RowBox[{"24", "+", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["\[Pi]", "2"], " ", 
         SuperscriptBox["sigma", "4"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "4"], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"5", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "4"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "4"]}], "-", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"5", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{"mu1", " ", "mu2", " ", "\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"64", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["mu1", "2"]}], "-", 
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"8", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["mu1", "2"]}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["mu2", "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}]}], "-", 
        RowBox[{"mu1", " ", "mu2", " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "64"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"16", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}]}], "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "64"}], " ", 
            SuperscriptBox["mu1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["mu2", "2"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
           RowBox[{"8", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox["mu1", "4"]}], "+", 
              SuperscriptBox["mu2", "4"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["sigma", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "4"], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["mu2", "2"], " ", 
               SuperscriptBox["sigma", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["mu1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "3"}], " ", 
                  SuperscriptBox["mu2", "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.9252398830418787`*^9, 3.92531449630016*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"1747fe48-8d4b-4e77-b982-57c6d7104f9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"covap11", "[", "t", "]"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "*", 
      RowBox[{"C11", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu1", "-", 
          RowBox[{"mu1", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", 
     RowBox[{"2", "*", 
      RowBox[{"C12", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu1", "-", 
          RowBox[{"mu1", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.925239898325223*^9, 3.925240048339281*^9}, 
   3.925240134403145*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"1ab3add2-2dfb-4ee4-8c8f-4e43146c1d77"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"8", "+", 
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox["sigma", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}], 
    RowBox[{"5", "/", "2"}]]], 
  RowBox[{
   SqrtBox["2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", " ", 
           RowBox[{"m1", "[", "t", "]"}]}], "+", 
          RowBox[{"mu2", " ", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox["sigma", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}]}]]}]], 
   " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "64"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu1", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         RowBox[{"C11", "[", "t", "]"}]}], "+", 
        RowBox[{"mu1", " ", "mu2", " ", 
         RowBox[{"C12", "[", "t", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["sigma", "4"], " ", 
      RowBox[{"m2", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"C12", "[", "t", "]"}], " ", 
         RowBox[{"m1", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"C11", "[", "t", "]"}], " ", 
         RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu2", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"]}], "-", 
        RowBox[{"2", " ", "mu1", " ", "mu2", " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"m2", "[", "t", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu1", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
     RowBox[{"8", " ", "\[Pi]", " ", 
      SuperscriptBox["sigma", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["sigma", "2"], " ", 
              RowBox[{"C11", "[", "t", "]"}]}], "+", 
             RowBox[{"mu1", " ", "mu2", " ", 
              RowBox[{"C12", "[", "t", "]"}]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "mu1", " ", "mu2", " ", 
            RowBox[{"C11", "[", "t", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            RowBox[{"C12", "[", "t", "]"}]}]}], ")"}], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"m2", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            RowBox[{"C11", "[", "t", "]"}]}], "+", 
           RowBox[{"mu1", " ", "mu2", " ", 
            RowBox[{"C12", "[", "t", "]"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.925239968470606*^9, 3.9252399755204353`*^9}, {
   3.925240036075263*^9, 3.925240050629072*^9}, 3.9253144984165773`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"6d289b13-d80b-4800-a019-06aeb0ee27ce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"covap12", "[", "t", "]"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"C11", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu2", "-", 
          RowBox[{"mu2", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C12", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu1", "-", 
          RowBox[{"mu1", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C12", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu2", "-", 
          RowBox[{"mu2", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m2", "[", "t", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C22", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu1", "-", 
          RowBox[{"mu1", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.925240066375669*^9, 3.925240075492835*^9}, {
  3.925240148014144*^9, 3.925240271363977*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"7baab944-8e1a-4138-864b-277d1bad67c6"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SqrtBox["2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"8", "+", 
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["sigma", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}], 
     RowBox[{"5", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", " ", 
           RowBox[{"m1", "[", "t", "]"}]}], "+", 
          RowBox[{"mu2", " ", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox["sigma", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}]}]]}]], 
   " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"C22", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "64"}], " ", "mu1", " ", "mu2"}], "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", "mu1", " ", "mu2", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"m1", "[", "t", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"8", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu1", "2"], "+", 
                 SuperscriptBox["mu2", "2"], "+", 
                 SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu2", "2"], "+", 
                 SuperscriptBox["sigma", "2"]}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
            RowBox[{"m2", "[", "t", "]"}]}], "-", 
           RowBox[{"2", " ", "mu1", " ", "mu2", " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            RowBox[{"m1", "[", "t", "]"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "3"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"C12", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "64"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu1", "2"], "+", 
           SuperscriptBox["mu2", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["mu2", "2"]}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], "-", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "4"]}], "+", 
           RowBox[{"2", " ", "mu1", " ", "mu2", " ", 
            RowBox[{"m1", "[", "t", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
            RowBox[{"m2", "[", "t", "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"8", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["mu1", "2"]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}]}], "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu1", "2"], "+", 
                 SuperscriptBox["mu2", "2"], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["sigma", "2"]}]}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
           RowBox[{"2", " ", "mu1", " ", "mu2", " ", "\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"m1", "[", "t", "]"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "3"]}], "-", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "4"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"C11", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "64"}], " ", "mu1", " ", "mu2"}], "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["sigma", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "3"], " ", 
            RowBox[{"m2", "[", "t", "]"}]}], "-", 
           RowBox[{"8", " ", "mu1", " ", "mu2", " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], "-", 
           RowBox[{"2", " ", "mu1", " ", "mu2", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               SuperscriptBox[
                RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"m1", "[", "t", "]"}], " ", 
            RowBox[{"m2", "[", "t", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"8", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu1", "2"], "+", 
                 SuperscriptBox["mu2", "2"], "+", 
                 SuperscriptBox["sigma", "2"]}], ")"}]}], "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox["sigma", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["mu1", "2"], "+", 
                 SuperscriptBox["sigma", "2"]}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}]}], ")"}]}]}],
        ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.925240275533128*^9, 3.9252402757677526`*^9}, 
   3.9253145028671427`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"db88a79e-728e-4705-9c77-14a4fe82faef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"covap22", "[", "t", "]"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "*", 
      RowBox[{"C12", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu2", "-", 
          RowBox[{"mu2", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", 
     RowBox[{"2", "*", 
      RowBox[{"C22", "[", "t", "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mu2", "-", 
          RowBox[{"mu2", "*", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"mu1", "*", 
                  RowBox[{"m1", "[", "t", "]"}]}], "+", 
                 RowBox[{"mu2", "*", 
                  RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                RowBox[{"sigma", "^", "2"}], "*", 
                RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], " ", 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                 "2"}], 
                RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
        ",", 
        RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.925240286978043*^9, 3.925240353218011*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"919709e0-c43c-4186-bac5-7ae5e018243f"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"8", "+", 
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox["sigma", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}], 
    RowBox[{"5", "/", "2"}]]], 
  RowBox[{
   SqrtBox["2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", " ", 
           RowBox[{"m1", "[", "t", "]"}]}], "+", 
          RowBox[{"mu2", " ", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox["sigma", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]}], ")"}]}]]}]], 
   " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "64"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"mu1", " ", "mu2", " ", 
         RowBox[{"C12", "[", "t", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu2", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         RowBox[{"C22", "[", "t", "]"}]}]}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["sigma", "4"], " ", 
      RowBox[{"m1", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"C22", "[", "t", "]"}], " ", 
         RowBox[{"m1", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"C12", "[", "t", "]"}], " ", 
         RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu2", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"]}], "-", 
        RowBox[{"2", " ", "mu1", " ", "mu2", " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"m2", "[", "t", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["mu1", "2"], "+", 
           SuperscriptBox["sigma", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
     RowBox[{"8", " ", "\[Pi]", " ", 
      SuperscriptBox["sigma", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"mu1", " ", "mu2", " ", 
              RowBox[{"C12", "[", "t", "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["mu2", "2"], "+", 
                SuperscriptBox["sigma", "2"]}], ")"}], " ", 
              RowBox[{"C22", "[", "t", "]"}]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["mu1", "2"], "+", 
              SuperscriptBox["mu2", "2"], "+", 
              SuperscriptBox["sigma", "2"]}], ")"}], " ", 
            RowBox[{"C12", "[", "t", "]"}]}], "+", 
           RowBox[{"2", " ", "mu1", " ", "mu2", " ", 
            RowBox[{"C22", "[", "t", "]"}]}]}], ")"}], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"m2", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", " ", "mu2", " ", 
            RowBox[{"C12", "[", "t", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["sigma", "2"], " ", 
            RowBox[{"C22", "[", "t", "]"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.925240356129545*^9, 3.925314504943033*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"ad6363dd-3e74-43d3-95f9-211369d609d4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"solcovar2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"m2", "[", "0", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"C11", "[", "0", "]"}], "\[Equal]", "0.1"}], ",", 
         RowBox[{
          RowBox[{"C12", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"C22", "[", "0", "]"}], "\[Equal]", "0.1"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu1", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                   RowBox[{"sigma", "^", "2"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{"sigma", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                  RowBox[{"sigma", "^", "2"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "+", 
             RowBox[{"covterms1", "[", "t", "]"}], "-", 
             RowBox[{"0.1", 
              RowBox[{"m1", "[", "t", "]"}]}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu2", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                   RowBox[{"sigma", "^", "2"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{"sigma", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                  RowBox[{"sigma", "^", "2"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "+", 
             RowBox[{"covterms2", "[", "t", "]"}], "-", 
             RowBox[{"0.1", 
              RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C11", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"covap11", "[", "t", "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"C11", "[", "t", "]"}], "*", "0.1"}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C12", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"covap12", "[", "t", "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"C12", "[", "t", "]"}], "*", "0.1"}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C22", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"covap22", "[", "t", "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"C22", "[", "t", "]"}], "*", "0.1"}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", "m2", ",", "C11", ",", "C12", ",", "C22"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"sigval", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0.5", ",", "  ", "0.0"}], "}"}]}], "}"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBmIQPefRzT1n7N46XugL2geiPe4auJ0F0olvmSNBtNPF
jwkg+l3t8xQQrXF4XjaI/pwqkAeie3yuFoLoDqkjZSB6a8KqahBt0qxaB9a/
92cTiH51I7cDRMfM/jsBRLO9XDcNRBuYtyZcAtI+l76lg2hWCb88ED3F6RGY
Nit9KnIZ5K5jX8D0iw28Oz8A6XMPfoLp/fWzj4Bojt6zJ0B0i+Tq5yBahf0V
mG7L1NP8BKTzOG3BdNvzJ8YgetG8w+YgWmxGjC2I7vB84gyir+ix+YJoHxMu
MB0QHv4fRL+oyWf8DKSfPL3DAaLvsX8G06bV69RAdNjp+2Da4cYBfxD99Mgd
MB1r0hADopkPXgLTnx73pYDolztOgGlzHp58sHmRVSUgeoPdIcMvQPqS8WUw
HWe0WOYbkNbKcJIF0QCSWeo5
  "],
 CellLabel->
  "In[113]:=",ExpressionUUID->"72ed035b-aaa4-4918-8a6d-f6933b36d0e7"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.925250882233913*^9, 3.9252508835129337`*^9}, 
   3.925250954485708*^9},ExpressionUUID->"311ea27e-58a9-4ed0-9327-\
99268dbd7356"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.925316103217753*^9},ExpressionUUID->"ceda85e3-f064-43de-b3c2-\
b094588ae2ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"solcovar", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"m2", "[", "0", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"C11", "[", "0", "]"}], "\[Equal]", "0.1"}], ",", 
         RowBox[{
          RowBox[{"C12", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"C22", "[", "0", "]"}], "\[Equal]", "0.1"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu1", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                   RowBox[{"sigma", "^", "2"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{"sigma", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                  RowBox[{"sigma", "^", "2"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "+", 
             RowBox[{"covterms1", "[", "t", "]"}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"mu2", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                   RowBox[{"sigma", "^", "2"}], "*", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{"sigma", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                  RowBox[{"sigma", "^", "2"}], " ", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "mu2"}]}], ")"}], "^", 
                    "2"}], 
                   RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "+", 
             RowBox[{"covterms2", "[", "t", "]"}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C11", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"covap11", "[", "t", "]"}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C12", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"covap12", "[", "t", "]"}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C22", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{"covap22", "[", "t", "]"}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", "m2", ",", "C11", ",", "C12", ",", "C22"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "500"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"C11", "[", "t", "]"}], "+", 
          RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", "solcovar"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "500"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"sigval", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.925313353234516*^9, 3.925313425015678*^9}, {
  3.925313464189083*^9, 3.925313510564418*^9}, {3.9253163326937943`*^9, 
  3.925316340151885*^9}, {3.925318483552868*^9, 3.925318511290043*^9}, {
  3.9253200958311253`*^9, 3.925320096989305*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"2c9f5c4b-751b-4525-8d55-6cbb86b858db"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`sigval$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`sigval$$], 0, 1}}, Typeset`size$$ = {
    648., {182., 190.8457606239361}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`sigval$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`solcovar = 
        NDSolve[{$CellContext`m1[0] == 
           1/Sqrt[2], $CellContext`m2[0] == (-1)/Sqrt[2], $CellContext`C11[0] == 
           0.1, $CellContext`C12[0] == 0, $CellContext`C22[0] == 0.1, 
           ReplaceAll[
           Derivative[
             1][$CellContext`m1][$CellContext`t] == $CellContext`mu1 - \
$CellContext`mu1 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma^2 (Pi/
                  8)]] - ($CellContext`sigma/Sqrt[
              2 Pi]) (($CellContext`m1[$CellContext`t] $CellContext`sigma 
               Sqrt[Pi/8])/Sqrt[
              1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma^2 (Pi/8)]) 
             Exp[((-1)/
                2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma^2 (Pi/
                  8)))] + $CellContext`covterms1[$CellContext`t], \
{$CellContext`mu1 -> 1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma -> $CellContext`sigval$$}], 
           ReplaceAll[
           Derivative[
             1][$CellContext`m2][$CellContext`t] == $CellContext`mu2 - \
$CellContext`mu2 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma^2 (Pi/
                  8)]] - ($CellContext`sigma/Sqrt[
              2 Pi]) (($CellContext`m2[$CellContext`t] $CellContext`sigma 
               Sqrt[Pi/8])/Sqrt[
              1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma^2 (Pi/8)]) 
             Exp[((-1)/
                2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma^2 (Pi/
                  8)))] + $CellContext`covterms2[$CellContext`t], \
{$CellContext`mu1 -> 1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma -> $CellContext`sigval$$}], 
           ReplaceAll[
           Derivative[
             1][$CellContext`C11][$CellContext`t] == \
$CellContext`covap11[$CellContext`t], {$CellContext`mu1 -> 
             1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma -> $CellContext`sigval$$}], 
           ReplaceAll[
           Derivative[
             1][$CellContext`C12][$CellContext`t] == \
$CellContext`covap12[$CellContext`t], {$CellContext`mu1 -> 
             1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma -> $CellContext`sigval$$}], 
           ReplaceAll[
           Derivative[
             1][$CellContext`C22][$CellContext`t] == \
$CellContext`covap22[$CellContext`t], {$CellContext`mu1 -> 
             1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma -> $CellContext`sigval$$}]}, \
{$CellContext`m1, $CellContext`m2, $CellContext`C11, $CellContext`C12, \
$CellContext`C22}, {$CellContext`t, 0, 500}]; Plot[
         Evaluate[
          
          ReplaceAll[$CellContext`C11[$CellContext`t] + \
$CellContext`C22[$CellContext`t], $CellContext`solcovar]], {$CellContext`t, 0,
           500}]), "Specifications" :> {{$CellContext`sigval$$, 0, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{727., {251.373046875, 261.626953125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.925313426421507*^9, 3.925313428943*^9}, 
   3.925313472481203*^9, {3.9253135063476267`*^9, 3.9253135125734577`*^9}, {
   3.925313589909369*^9, 3.925313602063884*^9}, 3.925314505095881*^9, 
   3.925314575212173*^9, {3.925316334342783*^9, 3.925316340898655*^9}},
 CellLabel->"Out[55]=",ExpressionUUID->"584f82ab-20cf-41c6-9060-7295115e7356"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<outcovtraceslsig10.csv\>\"", ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tval", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Evaluate", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"C11", "[", "t", "]"}], "+", 
                RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", 
              RowBox[{"solcovar2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "/.", 
            RowBox[{"t", "\[Rule]", "tval"}]}], ")"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tval", ",", "0", ",", "40", ",", "0.1"}], "}"}]}], "]"}], 
     ",", "\"\<CSV\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<outcovtraceslsig05.csv\>\"", ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tval", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Evaluate", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"C11", "[", "t", "]"}], "+", 
                RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", 
              RowBox[{"solcovar2", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "/.", 
            RowBox[{"t", "\[Rule]", "tval"}]}], ")"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tval", ",", "0", ",", "40", ",", "0.1"}], "}"}]}], "]"}], 
     ",", "\"\<CSV\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<outcovtraceslsig00.csv\>\"", ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tval", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Evaluate", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"C11", "[", "t", "]"}], "+", 
                RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", 
              RowBox[{"solcovar2", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "/.", 
            RowBox[{"t", "\[Rule]", "tval"}]}], ")"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"tval", ",", "0", ",", "40", ",", "0.1"}], "}"}]}], "]"}], 
     ",", "\"\<CSV\>\""}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.925250958445649*^9, 3.9252510388620577`*^9}, {
   3.9252516267637653`*^9, 3.925251667092161*^9}, {3.925252003343246*^9, 
   3.925252021854206*^9}, {3.925252119755027*^9, 3.925252123398045*^9}, {
   3.9252521610967216`*^9, 3.925252172118885*^9}, {3.9252522665611677`*^9, 
   3.925252274222476*^9}, 3.925315982347457*^9, {3.9253201054159613`*^9, 
   3.925320126979664*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"34135b75-b82c-451c-8061-bf803c6eb35c"],

Cell[BoxData["\<\"outcovtraceslsig10.csv\"\>"], "Output",
 CellChangeTimes->{
  3.9252516676045322`*^9, 3.9252520235274277`*^9, 3.925252123847102*^9, 
   3.925252172844795*^9, {3.925252267434042*^9, 3.9252522747986803`*^9}, 
   3.9253201301088963`*^9, 3.9253240154858932`*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"4f331189-b8c8-4c6f-b942-54c84bb13a1d"],

Cell[BoxData["\<\"outcovtraceslsig05.csv\"\>"], "Output",
 CellChangeTimes->{
  3.9252516676045322`*^9, 3.9252520235274277`*^9, 3.925252123847102*^9, 
   3.925252172844795*^9, {3.925252267434042*^9, 3.9252522747986803`*^9}, 
   3.9253201301088963`*^9, 3.925324015514143*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"450851f5-16b8-40f0-a050-08dd5f3b6bed"],

Cell[BoxData["\<\"outcovtraceslsig00.csv\"\>"], "Output",
 CellChangeTimes->{
  3.9252516676045322`*^9, 3.9252520235274277`*^9, 3.925252123847102*^9, 
   3.925252172844795*^9, {3.925252267434042*^9, 3.9252522747986803`*^9}, 
   3.9253201301088963`*^9, 3.9253240155288763`*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"9d646d37-0738-4d6e-a829-eb8d1d73200a"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{2880, 1581},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1.8 Inherited,
FrontEndVersion->"12.2 for Linux x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e4bdc39b-6d66-4d74-a0f3-281c98396980"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 652, 19, 53, "Input",ExpressionUUID->"ee0d0d4f-dbef-4922-a176-178940d9ffaa"],
Cell[1235, 43, 5312, 108, 438, "Output",ExpressionUUID->"f61f8237-90c1-4cc6-9309-a04b8be9dcc1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6584, 156, 9808, 241, 429, "Input",ExpressionUUID->"71921a79-1888-46e8-949c-f60ae63bca67"],
Cell[16395, 399, 4863, 92, 594, "Output",ExpressionUUID->"f1bf108a-e4cd-4ca0-91b8-6dba170968c3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21295, 496, 8571, 217, 391, "Input",ExpressionUUID->"93c78295-38a3-4684-9fb4-0fa10809e8d6"],
Cell[29869, 715, 4223, 81, 571, "Output",ExpressionUUID->"a6133906-01b1-451b-af65-86194778ae78"]
}, Open  ]],
Cell[34107, 799, 1343, 37, 53, "Input",ExpressionUUID->"631621a6-bcfd-49a6-bde5-1635eedf8728"],
Cell[CellGroupData[{
Cell[35475, 840, 353, 7, 53, "Input",ExpressionUUID->"ee2b45d3-a94d-4375-a201-6660752bd875"],
Cell[35831, 849, 272, 5, 60, "Output",ExpressionUUID->"666f659a-8ceb-4a35-87a2-c5f9a5795b4a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36140, 859, 9444, 241, 429, "Input",ExpressionUUID->"d73a22a4-c710-4591-81ed-1a2284b4bf6f"],
Cell[45587, 1102, 4530, 84, 559, "Output",ExpressionUUID->"30b5dbe2-9333-4043-ba1e-c70e6721e8b3"]
}, Open  ]],
Cell[50132, 1189, 981, 27, 53, "Input",ExpressionUUID->"cba60348-fdd9-47c4-b19f-57229f414d45"],
Cell[51116, 1218, 152, 3, 53, "Input",ExpressionUUID->"4221d003-9d8c-48e2-be82-ad79c0c8ebf0"],
Cell[51271, 1223, 414, 11, 53, "Input",ExpressionUUID->"6371e1f6-c4c1-4065-8c30-00d596f5230c"],
Cell[CellGroupData[{
Cell[51710, 1238, 457, 12, 53, "Input",ExpressionUUID->"96257887-4b82-4536-8f97-17489b075f90"],
Cell[52170, 1252, 5011, 101, 422, "Output",ExpressionUUID->"3c0eeb5f-7ff3-4c89-b14f-56188c489f47"]
}, Open  ]],
Cell[57196, 1356, 152, 3, 53, "Input",ExpressionUUID->"9898cac3-0368-49b1-ab12-ba9340e57aaf"],
Cell[CellGroupData[{
Cell[57373, 1363, 1699, 44, 91, "Input",ExpressionUUID->"12050e9a-0a4c-4726-aac5-7e19c10251b2"],
Cell[59075, 1409, 341, 4, 60, "Output",ExpressionUUID->"ae232289-5c31-4505-835d-4a080463ee93"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59453, 1418, 1445, 40, 91, "Input",ExpressionUUID->"3f119534-5144-43de-a95f-fa395c181247"],
Cell[60901, 1460, 241, 3, 60, "Output",ExpressionUUID->"0443c1cd-37f4-4411-a16d-6c625cfeeb5e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61179, 1468, 2288, 65, 91, "Input",ExpressionUUID->"b998a538-fcca-4789-af2d-b0500ea19237"],
Cell[63470, 1535, 189, 2, 60, "Output",ExpressionUUID->"28eac698-03d5-4c9a-9492-58dbf4a10ee3"]
}, Open  ]],
Cell[63674, 1540, 154, 3, 53, "Input",ExpressionUUID->"e18113b7-a2d9-41b7-8d2e-021caa5ebc9e"],
Cell[CellGroupData[{
Cell[63853, 1547, 16026, 400, 579, "Input",ExpressionUUID->"0fc48092-cfa9-4786-ab77-dabf2cf79c66"],
Cell[79882, 1949, 9304, 239, 300, "Output",ExpressionUUID->"eb8b9f47-0617-4b59-83cf-83eef052c6b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89223, 2193, 468, 13, 53, "Input",ExpressionUUID->"8be431d3-6f06-4c72-a8e0-dd9a12d547e2"],
Cell[89694, 2208, 3434, 75, 436, "Output",ExpressionUUID->"a4553f4a-20b0-4a3a-b3e9-84768c6fc8bd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93165, 2288, 359, 9, 53, "Input",ExpressionUUID->"8d9f90ad-67c5-455f-99ce-8a46e0f863d2"],
Cell[93527, 2299, 1524, 42, 430, "Output",ExpressionUUID->"067d0275-7c83-4e80-9c17-005670bcdee4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95088, 2346, 2781, 76, 98, "Input",ExpressionUUID->"a454feb5-82f2-4233-b1bb-4b997cbe5a2b"],
Cell[97872, 2424, 989, 27, 64, "Output",ExpressionUUID->"060c5c94-a184-4952-a746-5a4c81747180"]
}, Open  ]],
Cell[98876, 2454, 175, 3, 53, "Input",ExpressionUUID->"b4ef0b75-48ee-45d1-8776-7f131e5dcda1"],
Cell[CellGroupData[{
Cell[99076, 2461, 498, 15, 53, "Input",ExpressionUUID->"7ac44fe9-6d19-4efc-9719-3f1aa3205f5e"],
Cell[99577, 2478, 5332, 109, 438, "Output",ExpressionUUID->"f7cd7568-190e-4cb9-9351-ead1e9b48153"]
}, Open  ]],
Cell[104924, 2590, 3506, 107, 129, "Input",ExpressionUUID->"1deb85d0-ae0c-4a70-b400-5cf8d851d781"],
Cell[CellGroupData[{
Cell[108455, 2701, 1775, 45, 91, "Input",ExpressionUUID->"b0524f75-ac64-4208-bd88-f4c463577ebf"],
Cell[110233, 2748, 515, 9, 60, "Output",ExpressionUUID->"269f2386-04dd-4dbc-af3a-a0bab18edc09"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110785, 2762, 1488, 41, 91, "Input",ExpressionUUID->"7f1b45e3-2344-40cf-97bb-691519533a76"],
Cell[112276, 2805, 337, 6, 60, "Output",ExpressionUUID->"a1e48e2a-0729-4c4c-aaac-01a3342bfe31"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112650, 2816, 1764, 45, 91, "Input",ExpressionUUID->"d9f52799-9410-4b4f-8aa9-6dfcba0c0010"],
Cell[114417, 2863, 439, 6, 60, "Output",ExpressionUUID->"d1df9530-8044-4249-b2cc-993d096cc0a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114893, 2874, 2963, 87, 129, "Input",ExpressionUUID->"f6a7fe64-45e3-4dd0-ac1f-8a587da271e2"],
Cell[117859, 2963, 393, 6, 60, "Output",ExpressionUUID->"2276ba18-0707-4ad5-a3a9-e6072e4cb854"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118289, 2974, 442, 11, 53, "Input",ExpressionUUID->"e2efd2e7-e7e5-437b-97b8-b0e3b1e285a0"],
Cell[118734, 2987, 694, 17, 60, "Output",ExpressionUUID->"260b0670-b345-4621-a8e7-793e810d194f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119465, 3009, 383, 10, 53, "Input",ExpressionUUID->"7e57e9a3-43d3-4b7b-a7c4-08a1047b4ed5"],
Cell[119851, 3021, 410, 9, 60, "Output",ExpressionUUID->"94b055a8-2c05-4a00-9a7b-90a3e089638f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120298, 3035, 159, 3, 97, "Subsection",ExpressionUUID->"4d9212af-6c49-4dab-9065-0fe27ae9ad69"],
Cell[120460, 3040, 9631, 244, 429, "Input",ExpressionUUID->"80494aa0-e784-4e4f-bae1-9fc8f2ecd1bd"],
Cell[CellGroupData[{
Cell[130116, 3288, 517, 13, 53, "Input",ExpressionUUID->"f7cca346-1a89-42ab-aeb7-5136f2bdc56d"],
Cell[130636, 3303, 11249, 280, 190, "Output",ExpressionUUID->"e050fcbc-b423-4e39-85cf-b82f6055aed6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[141922, 3588, 777, 21, 53, "Input",ExpressionUUID->"1388f3c5-d1ca-44fe-8850-5303a2dd89cd"],
Cell[142702, 3611, 19717, 661, 661, "Output",ExpressionUUID->"6c3e6311-69cd-46e2-8168-5b98b5050baf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162456, 4277, 543, 14, 53, "Input",ExpressionUUID->"7fc0a213-47e0-4d83-91e6-b5f27bc250b6"],
Cell[163002, 4293, 2298, 54, 450, "Output",ExpressionUUID->"98ea145e-e79a-4420-bd67-d03289789dc9"]
}, Open  ]],
Cell[165315, 4350, 604, 17, 53, "Input",ExpressionUUID->"0ccbeb79-a2a7-478d-a3da-dae04087cfac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165956, 4372, 157, 3, 97, "Subsection",ExpressionUUID->"d6069626-a3d9-4574-b50f-c665d06adc1d"],
Cell[166116, 4377, 9220, 235, 391, "Input",ExpressionUUID->"93c93273-b824-4228-bb23-69c5f30d7672"],
Cell[CellGroupData[{
Cell[175361, 4616, 449, 12, 53, "Input",ExpressionUUID->"262319db-cc54-4799-9461-4546f4c38717"],
Cell[175813, 4630, 8814, 229, 145, "Output",ExpressionUUID->"9f9eee46-c9a0-4a48-b215-6e9a4fa4bf26"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184664, 4864, 726, 21, 53, "Input",ExpressionUUID->"0693e7cf-2b25-49e9-bfe9-8b7af439e5fb"],
Cell[185393, 4887, 18371, 611, 624, "Output",ExpressionUUID->"b6829473-3c48-4b55-b637-9f94a391ce34"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203801, 5503, 547, 15, 53, "Input",ExpressionUUID->"faa590d9-3c9f-4ef2-bd21-35661263fd1f"],
Cell[204351, 5520, 2312, 55, 428, "Output",ExpressionUUID->"9aa70592-39d6-44f4-a88a-ba30740e2a5b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[206700, 5580, 650, 18, 53, "Input",ExpressionUUID->"7805e56c-387f-46b9-b5c2-92d11b754dfe"],
Cell[207353, 5600, 201, 3, 60, "Output",ExpressionUUID->"8125b611-4e17-400a-a23c-d9e7775050b3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[207603, 5609, 401, 6, 97, "Subsection",ExpressionUUID->"e8304d1e-d7c2-4629-94e4-fa5fc2181a28"],
Cell[208007, 5617, 154, 3, 53, "Input",ExpressionUUID->"619a2077-61ca-4f3e-a9ee-8b28c9bfea5c"],
Cell[CellGroupData[{
Cell[208186, 5624, 9586, 254, 391, "Input",ExpressionUUID->"91fbf0f0-0b64-473b-8377-1b38fd21c279"],
Cell[217775, 5880, 25220, 660, 656, "Output",ExpressionUUID->"0b4a4bbf-aeea-468b-99e7-473a463e69a6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243032, 6545, 9535, 253, 391, "Input",ExpressionUUID->"821cfe07-f28d-4ebc-8ed5-38cb548b82c7"],
Cell[252570, 6800, 25183, 660, 697, "Output",ExpressionUUID->"1747fe48-8d4b-4e77-b982-57c6d7104f9e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[277790, 7465, 6368, 169, 316, "Input",ExpressionUUID->"1ab3add2-2dfb-4ee4-8c8f-4e43146c1d77"],
Cell[284161, 7636, 4522, 131, 213, "Output",ExpressionUUID->"6d289b13-d80b-4800-a019-06aeb0ee27ce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[288720, 7772, 12397, 329, 504, "Input",ExpressionUUID->"7baab944-8e1a-4138-864b-277d1bad67c6"],
Cell[301120, 8103, 8508, 225, 287, "Output",ExpressionUUID->"db88a79e-728e-4705-9c77-14a4fe82faef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[309665, 8333, 6342, 168, 316, "Input",ExpressionUUID->"919709e0-c43c-4186-bac5-7ae5e018243f"],
Cell[316010, 8503, 4450, 130, 213, "Output",ExpressionUUID->"ad6363dd-3e74-43d3-95f9-211369d609d4"]
}, Open  ]],
Cell[320475, 8636, 11157, 279, 391, "Input",ExpressionUUID->"72ed035b-aaa4-4918-8a6d-f6933b36d0e7"],
Cell[331635, 8917, 177, 3, 53, "Input",ExpressionUUID->"311ea27e-58a9-4ed0-9327-99268dbd7356"],
Cell[331815, 8922, 147, 3, 91, "Input",ExpressionUUID->"ceda85e3-f064-43de-b3c2-b094588ae2ff"],
Cell[CellGroupData[{
Cell[331987, 8929, 10711, 268, 429, "Input",ExpressionUUID->"2c9f5c4b-751b-4525-8d55-6cbb86b858db"],
Cell[342701, 9199, 5482, 105, 545, "Output",ExpressionUUID->"584f82ab-20cf-41c6-9060-7295115e7356"]
}, Open  ]],
Cell[CellGroupData[{
Cell[348220, 9309, 3050, 76, 166, "Input",ExpressionUUID->"34135b75-b82c-451c-8061-bf803c6eb35c"],
Cell[351273, 9387, 359, 6, 84, "Output",ExpressionUUID->"4f331189-b8c8-4c6f-b942-54c84bb13a1d"],
Cell[351635, 9395, 357, 6, 84, "Output",ExpressionUUID->"450851f5-16b8-40f0-a050-08dd5f3b6bed"],
Cell[351995, 9403, 359, 6, 84, "Output",ExpressionUUID->"9d646d37-0738-4d6e-a829-eb8d1d73200a"]
}, Open  ]]
}, Open  ]]
}
]
*)

