import os
import json

# Define the folder path and the required filenames text file path
folder_path = "../imagenet_images"
required_files_path = "imagenet/imagenet-classes.txt"

# Read the list of required filenames from the text file
with open(required_files_path, "r") as file:
    required_files = file.readlines()
    required_files = [filename.strip() for filename in required_files]

print(len(required_files))
# Iterate through the folder and check for missing files
print(len(os.listdir(folder_path)))


missing_files = [x for x in required_files if x not in os.listdir(folder_path)]
print(missing_files)

# Print out the list of missing files
if len(missing_files) > 0:
    print("The following files are missing:")
    for filename in missing_files:
        print(filename)
else:
    print("All required files are present.")

with open("imagenet/imagenet_prompt.json") as f:
    prompt = json.load(f)
    print(len(prompt.keys()))

with open("imagenet/imagenet.json") as f:
    prompt = json.load(f)
    print(len(prompt.keys()))