import requests
# Function to query an API with a given text

import openai
import json
from tqdm import tqdm
import time
import os

# Function to read even lines from a file
def read_lines(filename):
    with open(filename, 'r') as f:
        lines = f.read().splitlines()
    return lines

load_query = 'cifar100/cifar100.json'
api_key = "<OPENAI_API_KEY>"  # Replace with your own API key
openai.api_key = api_key
# Example usage
if os.path.exists(load_query):
    with open(load_query) as f:
        Result = json.load(f)
else:
    Result = dict()
filename = 'cifar100/cifar100_classes.txt'
lines = read_lines(filename)

for c in tqdm(lines):
    print(c)
    if c in Result.keys():
        continue
    
    # Set the prompt text to generate a response for
    prompt_text = '''Q: this is a dear because
A:
{
    "Concepts": [
        "Animal",
        "Mammal",
        "Wild",
        "Herbivore"
    ],
    "Substance": [
        "four legs",
        "two ears",
        "two eyes",
        "a nose",
        "a tail",
        "fur",
        "antlers (in males)"
    ],
    "Attributes": {
        "Head": {
            "shape": "elongated",
            "Nose": [
                "moist",
                "black"
            ],
            "Ears": [
                "pointy",
                "sensitive"
            ],
            "Eyes": [
                "large",
                "brown"
            ]
        },
        "Body": {
            "description": [
                "covered in fur",
                "four-legged",
                "slender"
            ],
            "Tail": [
                "short",
                "furry"
            ],
            "Legs": [
                "long",
                "slender",
                "hooves"
            ],
            "Antlers (in males)": [
                "branched",
                "bony structures on the head",
                "used for defense and display"
            ]
        }
    },
    "Environment": [
        "forests",
        "meadows",
        "grasslands"
    ]
}

Q: this is a aquarium fish because    
A:
{
    "Concepts": [
        "Animal",
        "Fish",
        "Aquatic"
    ],
    "Substance": [
        "scales",
        "fins",
        "gills",
        "tail",
        "eyes"
    ],
    "Attributes": {
        "Head": {
            "shape": "streamlined",
            "Mouth": [
                "protruding",
                "small",
                "toothed"
            ],
            "Eyes": [
                "large",
                "round",
                "located on sides of head"
            ]
        },
        "Body": {
            "description": [
                "covered in small, overlapping scales",
                "streamlined",
                "two fins on either side",
                "dorsal fin on back",
                "caudal fin at tail end"
            ]
        }
    },
    "Environment": [
        "aquariums",
        "freshwater or saltwater bodies",
        "coral reefs"
    ]
}
'''
    prompt_text += '''Q: this is a {} because
A:
'''.format(c)
    print(prompt_text)
    

    prompt = [{"role": "user", "content": prompt_text}]

    completion = openai.ChatCompletion.create(
        model="gpt-3.5-turbo",
        messages=prompt
    )
    print("Sleeping for 20 second...")
    time.sleep(20)
    res = completion.choices[0].message["content"]
    print(res)
    Result[c] = json.loads(res)

    with open(load_query, "w") as f:
        json.dump(Result, f, indent=4)


