# FOOGD

## The provided model

Model `./results/cifar10_alpha0.5_fedavg_foogd_model.pt` is training on CIFAR10 dataset. Data is sampled by label in a 
Dirichlet distribution parameterized by alpha = 0.5, for 10 clients.

## How to evaluate the model

### Dataset
`args.dataset_path` indicates the location of the datasets. This piece of code will download CIFAR10 and SVHN dataset
to this location automatically. For other OOD datasets, you need to download and unzip these datasets to this 
location. 

- download LSUN_C from https://www.dropbox.com/s/fhtsw1m3qxlwj6h/LSUN.tar.gz
- download isun from https://www.dropbox.com/s/ssz7qxfqae0cca5/iSUN.tar.gz
- download LSUN-R from https://www.dropbox.com/s/moqh2wh8696c3yl/LSUN_resize.tar.gz
- download Texture from https://www.robots.ox.ac.uk/~vgg/data/dtd/

For CIFAR10-C dataset, you can download from https://zenodo.org/records/2535967/files/CIFAR-10-C.tar?download=1.

### Run `test.py`

After downloading datasets, run `test.py`:

```shell
python test.py --seed 42 --method 'foogd' --model_name 'cifar10_alpha0.5_fedavg_foogd_model.pt' --id_dataset 'cifar10' \
        --ood_dataset ood-dataset-name --dataset_path path-to-dataset --alpha 0.5 --num_client 10 --dataset_seed 21 \
        --device 'cuda:0' --score_method 'sm'
```

Note: replace ood-dataset-name and path-to-dataset according to actual situation.