function [cropped_pics, min_h, min_w] = crop_arrays(pics)
    min_w = 1200;
    min_h = 1200;
    x0 = 1500;
    y0 = 1500;
    for i = 1:length(pics)
        [h, w] = size(pics{i});
        if w < min_w
            min_w = w;
        end
        if h < min_h
            min_h = h;
        end
    end
    cropped_pics = cell(size(pics));
    for i = 1:length(pics)
        cropped_pics{i} = pics{i}(x0+1:x0+min_h, y0+1:y0+min_w);
    end
end