function pic = read_img(file_name)
    if ~isfile(file_name)
        fprintf("Cannot find file '%s'!\nSkipping...\n", file_name);
        pic = [];
        return;
    end
    fprintf("Reading '%s'", file_name);
    pic = imread(file_name);
    fprintf(" of size [%d, %d]\n", size(pic, 1), size(pic, 2));
    if ndims(pic) == 3
        pic = rgb2hsv(pic);
        pic = pic(:,:,3);
    end
end