## Notion

Please first configure your personal information on OpenAI.

**Note: The result about GPT-3.5 is based on text-davinci-003**

First, install all the required packages:

```bash
pip install -r requirements.txt
```

## step 1: get mindmap for each dataset

To prepare the claims/question and evidence/documents for **2WIKIMUTIHOPQA/FEVEROUS/HOTPOTQA/HOVER/MuSiQue/QANGAROO/SCIFACT/STRATEGY**, please run the following command:

```bash
python ./src/data_preprocess.py \
      --input_path 'source dataset path, for example: ./datasets/2WIKIMULTIHOPQA/dev.json' \
      --save_path 'save path of mindmap for each dataset, for eample: ./datasets/dataset_name/gpt35/dev_mind_map.json' \
      --max_retries 100 \
      --delay_between_retries 10 \
      --model_name ['gpt-3.5','gpt-4','llama2-70b']
```


The claims, the evidece and mindmap will be saved in the `datasets/[DATASET_NAME]/[MODEL_NAME]` folder.


## step 2: train the pruning model

To reason for each dataset, please run the following commands:

```bash
python ./src/execution_rl.py \
    --dataset_name ['FEVEROUS', 'HOVER','SCIFACT', 'HOTPOTQA','2WIKIMULTIHOPQA','MuSiQue','STRATEGYQA', 'QANGAROO'] \
    --mode ['train', 'inference'] \
    --data_path ./datasets/ \
    --save_path ./results \
    --model_name 'text-davinci-003 or gpt-4 or llama' \
    --executor  url \
    --api_key "Your OpenAI API Key" \
    --prompt_mode text \
    --paradigm qa \
    --folder gpt4 \
    --ppo_epochs 5 \
    --batch_size 4 \
    --num_episodes 1000 \
    --lr 2e-6 \


```



## step 3: start to reason

To reason for each dataset, please run the following commands:

```bash
python ./src/mindmap_execution.py \
    --dataset_name ['FEVEROUS', 'HOVER','SCIFACT', 'HOTPOTQA','2WIKIMULTIHOPQA','MuSiQue','STRATEGYQA', 'QANGAROO'] \
    --data_path ./datasets/ \
    --save_path ./results \
    --model_name 'text-davinci-003 or gpt-4 or llama' \
    --executor  url \
    --api_key "Your OpenAI API Key" \
    --mode full \
    --prompt_mode text \
    --cot 'Use cot or not' \
    --paradigm qa \
    --folder gpt4 \
```


