
HOVER_TEXT_FC = '''Given a evidence and a claim, please answer that the evidence supports or refutes the claim?  Note that when there is not enough information in the evidence to support or refute the claim, it should be judged as refutes. Please put the answer in <response></response> XML tags.\n
                    Here are the evidence and claim , in the <evidence></evidence> and <claim></claim>  XML tags, respectively. \n
                    <evidence> [[EVIDENCE]] </evidence> \n
                    <claim> [[CLAIM]] </claim>
                    '''


FEVEROUS_TEXT_FC = '''Given  a claim and a context, your task is to assess the validity of the provided claim based on the available context, and provide explanations.

Here are the claim and evidence , in the <claim></claim> and <evidence></evidence> XML tags, respectively.

<claim> [[CLAIM]] </claim>

<context> [[EVIDENCE]] </context>

<output> 

Provide a binary classification (Supports/Refutes) indicating the perceived validity of the claim based on your general understanding and  an explanation outlining the reasoning behind your claim verification judgment. 
Please put the answer in <classification></classification> and <explanation></explanation> XML tags, respectively.

</output>'''


SCIFACT_TEXT_FC = '''Given a evidence and a claim, please answer that the evidence supports or refutes the claim?  Note that when there is not enough information in the evidence to support or refute the claim, it should be judged as refutes. Please put the answer in <response></response> XML tags.\n
                    Here are the evidence and claim , in the <evidence></evidence> and <claim></claim>  XML tags, respectively. \n
                    <evidence> [[EVIDENCE]] </evidence> \n
                    <claim> [[CLAIM]] </claim>
                    '''




HOVER_MINDMAP_FC = '''Given a evidence and a claim, please answer that the evidence supports or refutes the claim?  Note that when there is not enough information in the evidence to support or refute the claim, it should be judged as refutes. Please put the answer in <response></response> XML tags.\n
                    Here are the evidence and claim , in the <evidence></evidence> and <claim></claim>  XML tags, respectively. \n
                    <evidence> [[GRAPH]] </evidence> \n
                    <claim> [[CLAIM]] </claim>
                    '''









FEVEROUS_MINDMAP_FC = '''Given a evidence and a claim, please answer that the evidence supports or refutes the claim?  Note that when there is not enough information in the evidence to support or refute the claim, it should be judged as refutes. Please put the answer in <response></response> XML tags.\n
    Here are the evidence and claim , in the <evidence></evidence> and <claim></claim>  XML tags, respectively. \n
                     <evidence> [[GRAPH]] </evidence> \n
                     <claim> [[CLAIM]] </claim>'''

FEVEROUS_TEXT_MINDMAP_FC = '''Given a evidence and a claim, please answer that the evidence supports or refutes the claim?  Note that when there is not enough information in the evidence to support or refute the claim, it should be judged as refutes. Please put the answer in <response></response> XML tags.\n
    Here are the evidence and claim, in the  <evidence></evidence> and <claim></claim> XML tags, respectively. \n
                    <evidence> 
                        <document> [[EVIDENCE]] </document>
                        <graph> [[GRAPH]] </graph>
                    </evidence>
                    <claim> [[CLAIM]] </claim>
                    '''
  

SCIFACT_MINDMAP_FC = '''Given a evidence and a claim, please answer that the evidence supports or refutes the claim?  Note that when there is not enough information in the evidence to support or refute the claim, it should be judged as refutes. Please put the answer in <response></response> XML tags.\n
                    Here are the evidence and claim , in the <evidence></evidence> and <claim></claim>  XML tags, respectively. \n
                    <evidence> [[GRAPH]] </evidence> \n
                    <claim> [[CLAIM]] </claim>
                    '''




HOVER_TEXT_MINDMAP_FC = '''Given a claim and corresponding evidence, judge step by step whether the evidence supports or refutes the claim, and give a clear and unique result: supports or refutes. Note that when there is not enough information in the evidence to support or refute the claim, it should be judged as refutes.
                    Here are the claim and evidence, in the <claim></claim> and <evidence></evidence> XML tags, respectively.
                    <claim> [[CLAIM]] </claim>
                    <evidence> 
                        <text> [[EVIDENCE]] </text>
                        <graph> [[GRAPH]] </graph>
                    </evidence>
                    Please put the judgement result in <response></response> XML tags.'''



SCIFACT_TEXT_MINDMAP_FC = '''Given a claim and corresponding evidence, judge step by step whether the evidence supports or refutes the claim, and give a clear and unique result: supports or refutes. Note that when there is not enough information in the evidence to support or refute the claim, it should be judged as refutes.
                    Here are the claim and evidence, in the <claim></claim> and <evidence></evidence> XML tags, respectively.
                    Notably, the evidence is available in plain text and structured format, in the <text></text> and <graph></graph> XML tags, respectively.
                    <claim> [[CLAIM]] </claim>
                    <evidence> 
                        <text> [[EVIDENCE]] </text>
                        <graph> [[GRAPH]] </graph>
                    </evidence>
                    Please put the judgement result in <response></response> XML tags.'''





FEVEROUS_TEXT_QA = '''<document> [[EVIDENCE]] </document>\n
                Based on the above information in the <document></document> xml tags, answer the following question. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''


FEVEROUS_MINDMAP_QA = '''<documents> [[GRAPH]] </documents>\n
                Based on the above information in the <documents></documents> xml tags, answer the following question. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''

FEVEROUS_TEXT_MINDMAP_QA = '''<document> [[EVIDENCE]] </document> and <graph>[[GRAPH]] <graph> \n
                Based on the above information in the <document></document>  and <graph></graph> xml tags, answer the following question. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''

FEVEROUS_COT_TEXT_QA = '''<document> [[EVIDENCE]] </document>\n
                Based on the above information in the <document></document> xml tags, answer the following question step-by-step. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''


##92.00
FEVEROUS_COT_MINDMAP_QA = '''<docouments> [[GRAPH]] </documents>\n
                Based on the above information in the <documents></documents> xml tags, answer the following question step by step. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''


FEVEROUS_COT_TEXT_MINDMAP_QA = '''<document> [[EVIDENCE]] </document> and <graph>[[GRAPH]] <graph> \n
                Based on the above information in the <document></document>  and <graph></graph> xml tags, answer the following question step-by-step. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''






SCIFACT_TEXT_QA = '''<documents> [[EVIDENCE]] </documents>
                Question: Is it true that [[CLAIM]]? True or false? 
                Based on the above information in the <documents></documents> xml tags, answer the given question. 
                The answer is:'''



SCIFACT_MINDMAP_QA = '''<graph> [[GRAPH]] </graph>
                Based on the above information in the <graph></graph> xml tags, answer the following question. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''


SCIFACT_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] <graph>
                Qeustion: Is it true that [[CLAIM]]? True or false?
                Based on the above information in the <documents></documents> and <graph></graph> xml tags, answer the given question. 
                The answer is:'''


SCIFACT_COT_TEXT_QA = '''<documents> [[EVIDENCE]] </documents>
                Question: Is it true that [[CLAIM]]? True or false? 
                Based on the above information in the <documents></documents> xml tags, answer the given question step by step. 
                The answer is:'''



SCIFACT_COT_MINDMAP_QA = '''<documents> [[GRAPH]] </documents>
                Question: Is it true that [[CLAIM]]? True or false? 
                Based on the above information in the <documents></documents> xml tags, answer the given question STEP BY STEP. 
                The answer is:'''


SCIFACT_COT_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] <graph>
                Question: Is it true that [[CLAIM]]? True or false? 
                Based on the above information in the <documents></documents> and <graph></graph> xml tags, answer the given question step by step. 
                The answer is:'''


HOVER_TEXT_QA = '''<document> [[EVIDENCE]] </document>
                Based on the above information in the <document></document> xml tags, answer the following question. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''


HOVER_MINDMAP_QA = '''<documents> [[GRAPH]] </documents>\n
                Based on the above information in the <documents></documents> xml tags, answer the following question. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''


HOVER_TEXT_MINDMAP_QA = '''<document> [[EVIDENCE]] </document> and <graph>[[GRAPH]] <graph> \n
                Question: Is it true that [[CLAIM]]? True or false?
                Based on the above information in the <document></document>  and <graph></graph> xml tags, answer the given question. 
                The answer is:'''

HOVER_COT_TEXT_QA = '''<document> [[EVIDENCE]] </document>\n
                Based on the above information in the <document></document> xml tags, answer the following question step-by-step. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''

HOVER_COT_MINDMAP_QA = '''<documents> [[GRAPH]] </documents>\n
                Based on the above information in the <documents></documents> xml tags, answer the following question step by step. 
                Question: Is it true that [[CLAIM]]? True or false? 
                The answer is:'''



HOVER_COT_TEXT_MINDMAP_QA = '''<document> [[EVIDENCE]] </document> and <graph>[[GRAPH]] <graph> \n
                Question: Is it true that [[CLAIM]]? True or false?
                Based on the above information in the <document></document>  and <graph></graph> xml tags, answer the given question step by step. 
                The answer is:'''




MuSiQue_TEXT_QA = '''<documents> [[EVIDENCE]] </documents>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> xml tags, answer the question in the <question></question> xml tag. 
                Please just give the final answer.
                The answer should be provided in the following format:
                <answer>
                    [Final Answer Here]
                </answer>'''

MuSiQue_MINDMAP_QA = '''<graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <graph></graph> xml tags, answer the question in the <question></question> xml tag. 
                Please just give the final answer.
                The answer should be provided in the following format:
                <answer>
                    [Final Answer Here]
                </answer>'''



MuSiQue_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> and <graph></graph> xml tag, answer the question in the <question></question> xml tag.
                The answer should be provided in the following format:
                <answer>
                    [Final Answer Here]
                </answer>
                <explanation>
                    [Detailed Explanation Here]
                </explanation> '''


MuSiQue_COT_TEXT_QA = '''<documents> [[EVIDENCE]] </documents>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> xml tags, answer the question in the <question></question> xml tag step by step. 
                The answer should be provided in the following format:
                <answer>
                    [Final answer Here.]
                </answer>
                <reasoning>
                    [Reasoning Steps Here]
                </reasoning>'''

MuSiQue_COT_MINDMAP_QA = '''<graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <graph></graph> xml tags, answer the question in the <question></question> xml tag step by step. 
                The answer should be provided in the following format:
                <answer>
                    [Final answer Here.]
                </answer>
                <reasoning>
                    [Reasoning Steps Here]
                </reasoning>'''



MuSiQue_COT_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> and <graph></graph> xml tag, answer the question in the <question></question> xml tag step by step.
                The answer should be provided in the following format:
                <answer>
                    [Final Answer Here]
                </answer>
                <explanation>
                    [Detailed Explanation Here]
                </explanation> '''






STRATEGYQA_TEXT_QA = '''Documents: [[EVIDENCE]]
                Q: [[CLAIM]]?
                Please answer the question based on Documents. 
                Your final answer should be True or False, in the form <answer>{answer}</answer>, at the end of your response.
                A:'''




STRATEGYQA_COT_TEXT_QA = '''Documents: [[EVIDENCE]]
                Q: [[CLAIM]]?
                Please answer the question based on Documents. 
                Your final answer should be True or False, in the form <answer>{answer}</answer>, at the end of your response.
                A: Let's think step by step. '''






STRATEGYQA_MINDMAP_QA = '''Graph: [[GRAPH]]
                Q: [[CLAIM]]?
                Please answer the question based on Graph. 
                Your final answer should be True or False, in the form <answer>{answer}</answer>.
                A:'''


STRATEGYQA_COT_MINDMAP_QA = '''Graph: [[GRAPH]]
                Q: [[CLAIM]]?
                Please answer the question based on Graph. 
                Your final answer should be True or False, in the form <answer>{answer}</answer>, at the end of your response.
                A: Let's think step by step.'''



STRATEGYQA_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph>[[GRAPH]] <graph>
                Based on the above information in the <documents></documents> and <graph></graph> xml tags, answer the following question. 
                Question: [[CLAIM]]? True or False? 
                The answer is:'''

STRATEGYQA_COT_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph>[[GRAPH]] <graph>
                Based on the above information in the <documents></documents>  and <graph></graph> xml tags, answer the following question step by step. 
                Question: [[CLAIM]]? True or False? 
                The answer is:'''




HOTPOTQA_TEXT_QA = '''Documents: [[EVIDENCE]] 
                Q: [[CLAIM]]?
                Please answer the question based on Documents.
                Your final answer should be enclosed in an XML tag <answer>, like this: <answer>{final_answer}}</answer>, at the end of your response.
                A:'''



HOTPOTQA_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> and <graph></graph> xml tag, answer the question in the <question></question> xml tag.
                The answer should be provided in the following format:
                <answer>
                    [Final Answer Here]
                </answer>
                <explanation>
                    [Detailed Explanation Here]
                </explanation> '''


HOTPOTQA_COT_TEXT_QA = '''Documents: [[EVIDENCE]]
                Q: [[CLAIM]]?
                Please answer the question based on Documents. 
                Your final answer should be enclosed in an XML tag <answer>, like this: <answer>{final_answer}}</answer>, at the end of your response.
                A: Let's think step by step.'''



HOTPOTQA_MINDMAP_QA = '''Documents: [[GRAPH]] \n
                Q: [[CLAIM]]? \n
                Please answer the question based on the Documents. \n
                Your final answer should be enclosed in an XML tag <answer>, like this: <answer>{final_answer}}</answer>, at the end of your response.\n
                A:'''


HOTPOTQA_COT_MINDMAP_QA = '''Please answer the question based on Documents.
                Documents: [[GRAPH]] 
                Q: [[CLAIM]]?
                Let's think step by step.
                Your final answer should be enclosed in an XML tag <answer>, like this: <answer>{final_answer}}</answer>, at the end of your response.
                A: '''



HOTPOTQA_COT_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> and <graph></graph> xml tag, answer the question in the <question></question> xml tag step by step.
                The answer should be provided in the following format:
                <answer>
                    [Final Answer Here]
                </answer>
                <explanation>
                    [Detailed Explanation Here]
                </explanation>'''



WIKIMULTIHOPQA_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> and <graph></graph> xml tag, answer the question in the <question></question> xml tag.
                Please just give the final answer.
                The answer should be provided in the following format:
                <answer>
                    [Final Answer Here]
                </answer>'''



WIKIMULTIHOPQA_TEXT_QA = '''<documents> [[EVIDENCE]] </documents>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> xml tags, answer the question in the <question></question> xml tag. 
                Please just give the final answer.
                The answer should be provided in the following format:
                <answer>
                [Final Answer Here]
                </answer>'''




WIKIMULTIHOPQA_MINDMAP_QA = '''<graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <graph></graph> xml tags, answer the question in the <question></question> xml tag. 
                Please just give the final answer.
                The answer should be provided in the following format:
                <answer>
                    [Final Answer Here]
                </answer>
                '''


WIKIMULTIHOPQA_COT_TEXT_QA = '''<documents> [[EVIDENCE]] </documents>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> xml tags, answer the question in the <question></question> xml tag step by step.
                The answer should be provided in the following format:
                <answer>
                    [Final answer Here.]
                </answer>
                <reasoning>
                    [Reasoning Step Here]
                </reasoning>
                '''



WIKIMULTIHOPQA_COT_MINDMAP_QA = '''<graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <graph></graph> xml tags, answer the question in the <question></question> xml tag step by step. 
                The answer should be provided in the following format:
                <answer>
                    [Final answer Here.]
                </answer>
                <reasoning>
                    [Reasoning Step Here]
                </reasoning>
                '''



WIKIMULTIHOPQA_COT_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                Based on the above information in the <documents></documents> and <graph></graph> xml tag, answer the question in the <question></question> xml tag step by step.
                The answer should be provided in the following format:
                <answer>
                    [Final Answer Here]
                </answer>
                <reasoning>
                    [Reasoning Step Here]
                </reasoning>'''


QANGAROO_TEXT_QA = '''<documents> [[EVIDENCE]] </documents>
                    <question> [[CLAIM]]? </question>
                    <candidates> [[CANDIDATES]] </candidates>
                    Based on the information in the <documents></documents>, please choose the most appropriate answer from the candidates in the <candidates></candidates> that directly answer the question.
                    Please put the choosed answer in the <answer></answer> xml tag'''


QANGAROO_MINDMAP_QA = '''<graph> [[GRAPH]] </graph>
                    <question> [[CLAIM]]? </question>
                    <candidates> [[CANDIDATES]] </candidates>
                    Based on the above information in the <graph></graph>, please choose the most appropriate answer from the candidates in the <candidates></candidates> that directly answer the question.
                    Please put the choosed answer in the <answer></answer> xml tag'''


QANGAROO_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                <candidates> [[CANDIDATES]] </candidates>
                Based on the above information in the <documents></documents> and <graph></graph> xml tag, please choose the most appropriate answer from the candidates in the <candidates></candidates> that directly answer the question.
                Please put the choosed answer in the <answer></answer> xml tag.'''

QANGAROO_COT_TEXT_QA = '''<documents> [[EVIDENCE]] </documents>
                    <question> [[CLAIM]]? </question>
                    <candidates> [[CANDIDATES]] </candidates>
                    Based on the information in the <documents></documents>, please choose the most appropriate answer from the candidates in the <candidates></candidates> that directly answer the question step by step.
                    Please put the choosed answer in the <answer></answer> xml tag.'''

QANGAROO_COT_MINDMAP_QA = '''<graph> [[GRAPH]] </graph>
                    <question> [[CLAIM]]? </question>
                    <candidates> [[CANDIDATES]] </candidates>
                    Based on the above information in the <graph></graph>, please choose the most appropriate answer from the candidates in the <candidates></candidates> that directly answer the question step by step.
                    Please put the choosed answer in the <answer></answer> xml tag.'''

QANGAROO_COT_TEXT_MINDMAP_QA = '''<documents> [[EVIDENCE]] </documents> and <graph> [[GRAPH]] </graph>
                <question> [[CLAIM]]? </question>
                <candidates> [[CANDIDATES]] </candidates>
                Based on the above information in the <documents></documents> and <graph></graph> xml tag, please choose the most appropriate answer from the candidates in the <candidates></candidates> that directly answer the question step by step.
                Please put the choosed answer in the <answer></answer> xml tag.'''

class Prompt_Loader:
    def __init__(self, prompt_mode, paradigm, cot) -> None:
        if paradigm == 'fc':
            if prompt_mode == 'text':
                self.hover_fc = HOVER_TEXT_FC
                self.feverous_fc = FEVEROUS_TEXT_FC
                self.scifact_fc = SCIFACT_TEXT_FC

            elif prompt_mode == 'map':
                self.hover_fc = HOVER_MINDMAP_FC
                self.feverous_fc = FEVEROUS_MINDMAP_FC
                self.scifact_fc = SCIFACT_MINDMAP_FC

            elif prompt_mode == 'mix':
                self.hover_fc = HOVER_TEXT_MINDMAP_FC
                self.feverous_fc = FEVEROUS_TEXT_MINDMAP_FC
                self.scifact_fc = SCIFACT_TEXT_MINDMAP_FC
        elif paradigm == 'qa':
            if cot:
                if prompt_mode == 'text':
                    self.hover_fc = HOVER_COT_TEXT_QA
                    self.feverous_fc = FEVEROUS_COT_TEXT_QA
                    self.scifact_fc = SCIFACT_COT_TEXT_QA
                    self.hotpotqa_fc = HOTPOTQA_COT_TEXT_QA
                    self.wikimultihopqa_fc = WIKIMULTIHOPQA_COT_TEXT_QA
                    self.musique_fc = MuSiQue_COT_TEXT_QA
                    self.strategy_fc = STRATEGYQA_COT_TEXT_QA
                    self.qangaroo_fc = QANGAROO_COT_TEXT_QA
                    

                elif prompt_mode == 'map':
                    self.hover_fc = HOVER_COT_MINDMAP_QA
                    self.feverous_fc = FEVEROUS_COT_MINDMAP_QA
                    self.scifact_fc = SCIFACT_COT_MINDMAP_QA
                    self.hotpotqa_fc = HOTPOTQA_COT_MINDMAP_QA
                    self.wikimultihopqa_fc = WIKIMULTIHOPQA_COT_MINDMAP_QA
                    self.musique_fc = MuSiQue_COT_MINDMAP_QA
                    self.strategy_fc = STRATEGYQA_COT_MINDMAP_QA
                    self.qangaroo_fc = QANGAROO_COT_MINDMAP_QA

                elif prompt_mode == 'mix':
                    self.hover_fc = HOVER_COT_TEXT_MINDMAP_QA
                    self.feverous_fc = FEVEROUS_COT_TEXT_MINDMAP_QA
                    self.scifact_fc = SCIFACT_COT_TEXT_MINDMAP_QA
                    self.hotpotqa_fc = HOTPOTQA_COT_TEXT_MINDMAP_QA
                    self.wikimultihopqa_fc = WIKIMULTIHOPQA_COT_TEXT_MINDMAP_QA
                    self.musique_fc = MuSiQue_COT_TEXT_MINDMAP_QA
                    self.strategy_fc = STRATEGYQA_COT_TEXT_MINDMAP_QA
                    self.qangaroo_fc = QANGAROO_COT_TEXT_MINDMAP_QA

            else:
                if prompt_mode == 'text':
                    self.hover_fc = HOVER_TEXT_QA
                    self.feverous_fc = FEVEROUS_TEXT_QA
                    self.scifact_fc = SCIFACT_TEXT_QA
                    self.hotpotqa_fc = HOTPOTQA_TEXT_QA
                    self.wikimultihopqa_fc = WIKIMULTIHOPQA_TEXT_QA
                    self.musique_fc = MuSiQue_TEXT_QA
                    self.strategy_fc = STRATEGYQA_TEXT_QA
                    self.qangaroo_fc = QANGAROO_TEXT_QA
                    

                elif prompt_mode == 'map':
                    self.hover_fc = HOVER_MINDMAP_QA
                    self.feverous_fc = FEVEROUS_MINDMAP_QA
                    self.scifact_fc = SCIFACT_MINDMAP_QA
                    self.hotpotqa_fc = HOTPOTQA_MINDMAP_QA
                    self.wikimultihopqa_fc = WIKIMULTIHOPQA_MINDMAP_QA
                    self.musique_fc = MuSiQue_MINDMAP_QA
                    self.strategy_fc = STRATEGYQA_MINDMAP_QA
                    self.qangaroo_fc = QANGAROO_MINDMAP_QA

                elif prompt_mode == 'mix':
                    self.hover_fc = HOVER_TEXT_MINDMAP_QA
                    self.feverous_fc = FEVEROUS_TEXT_MINDMAP_QA
                    self.scifact_fc = SCIFACT_TEXT_MINDMAP_QA
                    self.hotpotqa_fc = HOTPOTQA_TEXT_MINDMAP_QA
                    self.wikimultihopqa_fc = WIKIMULTIHOPQA_TEXT_MINDMAP_QA
                    self.musique_fc = MuSiQue_TEXT_MINDMAP_QA
                    self.strategy_fc = STRATEGYQA_TEXT_MINDMAP_QA
                    self.qangaroo_fc = QANGAROO_TEXT_MINDMAP_QA

        
                

    def prompt_construction(self, claim, evidence, mindmap, dataset_name):
        template = None
        if dataset_name == 'HOVER':
            template = self.hover_fc
        elif dataset_name == 'FEVEROUS':
            template = self.feverous_fc
        elif dataset_name == 'SCIFACT':
            template = self.scifact_fc
        elif dataset_name == 'HOTPOTQA':
            template = self.hotpotqa_fc
            # print(template)
        elif dataset_name == '2WIKIMULTIHOPQA':
            template = self.wikimultihopqa_fc
        elif dataset_name == 'MuSiQue':
            template = self.musique_fc
        elif dataset_name == 'STRATEGYQA':
            template = self.strategy_fc
        else:
            raise NotImplementedError
        if dataset_name == '2WIKIMULTIHOPQA':
            prefix = []
            
            
            documents = []
            graphs = []
            for index, (text, graph) in enumerate(zip(evidence, mindmap)):
                documents.append(text)
                graphs.append(str(graph))
            return template.replace('[[EVIDENCE]]', ' '.join(documents)).replace('[[CLAIM]]', claim).replace('[[GRAPH]]', ' '.join(graphs))

        elif dataset_name == 'HOTPOTQA':
            documents = []
            graphs = []
            for index, (text, graph) in enumerate(zip(evidence, mindmap)):
                documents.append(text)
                graphs.append(str(graph))
            return template.replace('[[EVIDENCE]]', ' '.join(documents)).replace('[[CLAIM]]', claim).replace('[[GRAPH]]', ' '.join(graphs))
        elif dataset_name == 'MuSiQue':
            documents = []
            graphs = []
            for index, (text, graph) in enumerate(zip(evidence, mindmap)):
                documents.append(text)
                graphs.append(str(graph))
            return template.replace('[[EVIDENCE]]', ' '.join(documents)).replace('[[CLAIM]]', claim).replace('[[GRAPH]]', ' '.join(graphs))
        elif dataset_name == 'STRATEGYQA':
                documents = []
                graphs = []
                for index, (text, graph) in enumerate(zip(evidence, mindmap)):
                    documents.append(text)
                    graphs.append(str(graph))
                return template.replace('[[EVIDENCE]]', ' '.join(documents)).replace('[[CLAIM]]', claim).replace('[[GRAPH]]', ' '.join(graphs))
        
        elif dataset_name == 'SCIFACT':
                documents = []
                graphs = []
                if len(mindmap) != 0:
                    for index, (text, graph) in enumerate(zip(evidence, mindmap)):
                        documents.append(text)
                        graphs.append(str(graph))
                else:
                    for index, text in enumerate(evidence):
                        documents.append(text)
                return template.replace('[[EVIDENCE]]', ' '.join(documents)).replace('[[CLAIM]]', claim).replace('[[GRAPH]]', ' '.join(graphs))

        else:
            return template.replace('[[CLAIM]]', claim).replace('[[EVIDENCE]]', evidence).replace('[[GRAPH]]', str(mindmap[0]))
        # return template.replace('[[CLAIM]]', claim).replace('[[EVIDENCE]]', evidence).replace('[[GRAPH]]', mindmap)

    def prompt_construction_mc(self, claim, evidence, mindmap, candidates,  dataset_name):
        template = None
        if dataset_name == 'QANGAROO':
            template = self.qangaroo_fc
        else:
            raise NotImplementedError
        if dataset_name == 'QANGAROO':
            documents = []
            graphs = []
            for index, (text, graph) in enumerate(zip(evidence, mindmap)):
                documents.append(text)
                graphs.append(str(graph))
            return template.replace('[[EVIDENCE]]', ' '.join(documents)).replace('[[CLAIM]]', claim).replace('[[GRAPH]]', ' '.join(graphs)).replace('[[CANDIDATES]]',str(candidates)) 
        else:
            return template.replace('[[CLAIM]]', claim).replace('[[EVIDENCE]]', evidence).replace('[[GRAPH]]', str(mindmap[0]))