# -*- coding: utf-8 -*-
"""
Created on Sat Apr 13 16:28:50 2024

@author: admin-01
"""

import matplotlib.pyplot as plt
import pandas as pd

plt.rcParams.update({"font.size": 16})
distribution = 3
epsilon = 1
f_new = "result_unbal_{}_{}_new.csv".format(distribution, epsilon)
f_base = "result_unbal_{}_{}_baseline.csv".format(distribution, epsilon)
dnew = pd.read_csv(f_new)
dbase = pd.read_csv(f_base)
gammaarray = dnew["gamma"]
nlist = dnew.columns[1:]
plt.figure(figsize = (6,5))
#plt.yscale('log')
for n in nlist:
    #plt.plot(gammaarray, dnew[n], linewidth = 3)
    #plt.plot(gammaarray, dbase[n], linewidth = 3, linestyle = '--')
    plt.errorbar(gammaarray, dnew[n], elinewidth = 3, yerr = dnew[n]/5, \
                 marker = 'o', markersize = 6, linewidth = 2)
    plt.errorbar(gammaarray, dbase[n], elinewidth = 3, yerr = dbase[n]/5, \
             marker = 'o', markersize = 6, linewidth = 2, linestyle = '--')
plt.legend(['HLM, n=2000', 'WME, n=2000',\
            'HLM, n=5000', 'WME, n=5000',\
            'HLM, n=10000', 'WME, n=10000'], fontsize = 14)
plt.xlabel('$\gamma$')
plt.ylabel('mean squared error')
plt.scilimits(-1,2)
plt.tight_layout()
figname = "{}_{}_unbal.pdf".format(distribution, epsilon)
plt.savefig(figname, format = 'pdf')