import os
from PIL import Image

def combine_channels_to_rgb(red_folder, green_folder, blue_folder, output_folder):

    os.makedirs(output_folder, exist_ok=True)
    

    red_files = sorted(os.listdir(red_folder))
    green_files = sorted(os.listdir(green_folder))
    blue_files = sorted(os.listdir(blue_folder))
    

    if not (red_files == green_files == blue_files):
        raise ValueError("these names not the same")
    
    for file_name in red_files:

        red_path = os.path.join(red_folder, file_name)
        green_path = os.path.join(green_folder, file_name)
        blue_path = os.path.join(blue_folder, file_name)
        

        red_channel = Image.open(red_path).convert('L')
        green_channel = Image.open(green_path).convert('L')
        blue_channel = Image.open(blue_path).convert('L')
        

        rgb_image = Image.merge('RGB', (red_channel, green_channel, blue_channel))
        

        output_path = os.path.join(output_folder, file_name)

        rgb_image.save(output_path)
        print(f"Saved combined image to {output_path}")


red_folder = "D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/images_R"
green_folder = "D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/images_G"
blue_folder = "D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/images_B"
output_folder = "D:/2024/3DGS/PureEventFilter/data/lego_color_colmap_easy/images"


combine_channels_to_rgb(red_folder, green_folder, blue_folder, output_folder)