"""
Physical constants + some utility functions.
"""
BOHR_TO_ANGSTROM = 0.52917721067
ANGSTROM_TO_BOHR = 1.0 / BOHR_TO_ANGSTROM

HARTREE_TO_EV = 27.211386024367243
EV_TO_KCAL = 23.060548012069493
EV_TO_HARTREE = 1.0 / HARTREE_TO_EV
KCAL_TO_EV = 1.0 / EV_TO_KCAL
HARTREE_TO_KCAL = HARTREE_TO_EV * EV_TO_KCAL
KCAL_TO_HARTREE = 1.0 / HARTREE_TO_KCAL

HARTREE_TO_INV_CM = 219474.63
INV_CM_TO_HARTREE = 1.0 / HARTREE_TO_INV_CM
