[![Code License](https://img.shields.io/badge/Code%20License-Apache_2.0-green.svg)](https://github.com/agiresearch/OpenAGI/blob/main/LICENSE)


# Large Language Models as Urban Residents: An LLM Agent Framework for Personal Mobility Generation

## 📖 Description
This repository is the implemetation of LLMob from [Large Language Models as Urban Residents: An LLM Agent Framework for Personal Mobility Generation]. 
LLMob is a simple framework that takes advantage of Large Language Models (LLMs) for personal activity trajectory generation.

## ⭐ Key Components
- **./simulator/engine/person.py**: Generate personal activity trajectory according to real-world check-in data.
- **./simulator/engine/functions/traj_infer.py**: Personal activity trajectory generation function.
- **./simulator/engine/functions/PISC.py**: Personal activity pattern identification function.
- **./simulator/engine/memory/retrieval_helper.py**: Function related to motivation retrieval.
- **./simulator/prompt_template**: Prompt template used in this project.

## ⚙️ Usage

To get started with LLMob, follow these steps:

```bash
cd LLMob
conda env create -f environment.yml
conda activate llm
cd simulator/engine/
python person.py
```

## 📚 BibTex Citation

If you would like to cite our code or paper, please use:

```
Anonymized
```

## 🌷 Acknowledgments

This project refers to several open-source ChatGPT application:

- [Generative Agents: Interactive Simulacra of Human Behavior](https://github.com/joonspk-research/generative_agents)

- [MetaGPT](https://github.com/geekan/MetaGPT/tree/main)

The raw data used in this project is from [Foursquare API](https://location.foursquare.com/developer/).
