## FedExProx

### [File Structure]:
```
│   experiment.py               [Code for Experiment]
│   README.md                   [README]
|   x_star.npy                  [The solution determined using gradient descent before hand]
└─  result                      [Result folder]
      ├─    LinearRegression_FedExP_Full_Batch_localiter_{}_iteration.npy                 [Iteration Result for method 1: FedExP fully parallel]
      ├─    LinearRegression_FedExP_Full_Batch_localiter_{}_func_val.npy                  [Function suboptimality result for method 1: FedExP fully parallel]
      ├─    LinearRegression_FedExP_Mini_Batch_localiter_{}_tau_{}_iteration.npy          [Iteration Result for method 1: FedExP partial participation]
      ├─    LinearRegression_FedExP_Mini_Batch_localiter_{}_tau_{}_func_val.npy           [Function suboptimality result for method 1: FedExP partial participation]
      |
      ├─    LinearRegression_FedExProx_Full_Batch_gamma_{}_alpha_{}_iteration.npy         [Iteration Result for method 2: FedExProx fully parallel]
      ├─    LinearRegression_FedExProx_Full_Batch_gamma_{}_alpha_{}_func_val.npy          [Function suboptimality result for method 2: FedExProx fully parallel]
      ├─    LinearRegression_FedExProx_MiniBatch_gamma_{}_tau_{}_alpha_{}_iteration.npy   [Iteration Result for method 2: FedExProx partial participation]
      ├─    LinearRegression_FedExProx_MiniBatch_gamma_{}_tau_{}_alpha_{}_iteration.npy   [Function suboptimality result for method 2: FedExProx partial participation]
      |
      ├─    LinearRegression_FedProx_Full_Batch_gamma_{}_alpha_{}_iteration.npy           [Iteration Result for method 3: FedProx fully parallel]
      ├─    LinearRegression_FedProx_Full_Batch_gamma_{}_alpha_{}_func_val.npy            [Function suboptimality result for method 3: FedProx fully parallel]
      ├─    LinearRegression_FedProx_MiniBatch_gamma_{}_tau_{}_alpha_{}_iteration.npy     [Iteration Result for method 3: FedProx partial participation]
      ├─    LinearRegression_FedProx_MiniBatch_gamma_{}_tau_{}_alpha_{}_func_val.npy      [Function suboptimality result for method 3: FedProx partial participation]
      |
      ├─    LinearRegression_FedExProx_GraDS_Full_Batch_gamma_{}_iteration.npy            [Iteration Result for method 4: FedExProx-GraDS fully parallel]
      ├─    LinearRegression_FedExProx_GraDS_Full_Batch_gamma_{}_func_val.npy             [Function suboptimality result for method 4: FedExProx-GraDS fully parallel]
      ├─    LinearRegression_FedExProx_MiniBatch_gamma_{}_tau_{}_GraDS_iteration.npy      [Iteration Result for method 4: FedExProx-GraDS partial participation]
      ├─    LinearRegression_FedExProx_MiniBatch_gamma_{}_tau_{}_GraDS_func_val.npy       [Function suboptimality result for method 4: FedExProx-GraDS partial participation]
      |
      ├─    LinearRegression_FedExProx_StoPS_Full_Batch_gamma_{}_iteration.npy            [Iteration Result for method 5: FedExProx-StoPS fully parallel]
      ├─    LinearRegression_FedExProx_StoPS_Full_Batch_gamma_{}_func_val.npy             [Function suboptimality result for method 5: FedExProx-StoPS fully parallel]        
      ├─    LinearRegression_FedExProx_MiniBatch_gamma_{}_tau_{}_StoPS_iteration.npy      [Iteration Result for method 5: FedExProx-StoPS partial participation]
      └─    LinearRegression_FedExProx_MiniBatch_gamma_{}_tau_{}_StoPS_func_val.npy       [Function suboptimality result for method 5: FedExProx-StoPS partial participation]
```


### [Dependencies]:
Python packages dependencies:
- Numpy
- Scipy 
- Matplotlib


### [Instructions]:

Codes for running experiments are in file `experiment.py`,  all the algorithm (in total 4) are included in this experiment code.
In order to run the experiment, one must specify the index for the experiment and other relevant parameters.


```
-t          # The client minibatch size                                 [Required for partial participation]
-g          # Value of local stepsize gamma                             [Required for proximity operator]
-l          # Number of local iterations for GD                         [Required for FedExP]
-K          # The number of iterations                                  [Required for all methods]
-m          # The index of method                                       [Required for all methods]
-a          # The initial iterations of GD for determining the solution [Optional]
```

## [Experiments]:
There are in total **5** algorithms in the paper.
If we set `-m=1`, we are going to run the first algorithm FedExP.
The result obtained after running those experiments will be stored in the corresponding folder `.\result`.

## [Examples]:

**Algorithm 1**: FedExP
To run FedExP in the fully parallel setting, use the command
```commandline
  python experiment.py -m=1 -a=[GD_iterations] -K=[FedExP_iterations] -l=[local_training_iterations]
```
To run FedExP in the client partial participation setting, use the command
```commandline
  python experiment.py -m=1 -a=[GD_iterations] -K=[FedExP_iterations] -l=[local_training_iterations] -t=[minibatch size]
```

**Algorithm 2**: FedExProx
To run FedExProx in the fully parallel setting, use the command
```commandline
  python experiment.py -m=2 -a=[GD_iterations] -K=[FedExProx_iterations] -g=[local_stepsize]
```
To run FedExProx in the client partial participation setting, use the command
```commandline
  python experiment.py -m=2 -a=[GD_iterations] -K=[FedExProx_iterations] -g=[local_stepsize] -t=[minibatch size]
```

**Algorithm 3**: FedProx
To run FedExProx in the fully parallel setting, use the command
```commandline
  python experiment.py -m=3 -a=[GD_iterations] -K=[FedProx_iterations] -g=[local_stepsize]
```
To run FedExProx in the client partial participation setting, use the command
```commandline
  python experiment.py -m=3 -a=[GD_iterations] -K=[FedProx_iterations] -g=[local_stepsize] -t=[minibatch size]
```

**Algorithm 4**: FedExProx-GraDS
To run FedExProx in the fully parallel setting, use the command
```commandline
  python experiment.py -m=4 -a=[GD_iterations] -K=[FedExProx-GraDS_iterations] -g=[local_stepsize]
```
To run FedExProx in the client partial participation setting, use the command
```commandline
  python experiment.py -m=4 -a=[GD_iterations] -K=[FedExProx-GraDS_iterations] -g=[local_stepsize] -t=[minibatch size]
```

**Algorithm 5**: FedExProx-StoPS
To run FedExProx in the fully parallel setting, use the command
```commandline
  python experiment.py -m=5 -a=[GD_iterations] -K=[FedExProx-StoPS_iterations] -g=[local_stepsize]
```
To run FedExProx in the client partial participation setting, use the command
```commandline
  python experiment.py -m=5 -a=[GD_iterations] -K=[FedExProx-StoPS_iterations] -g=[local_stepsize] -t=[minibatch size]
```

## [Remarks]:
The current files in the `.\result` are examples of the file generated.