"""
Produces the 3D results of the broad comparison across architectures and
dynamics.

Full prediction learning with one-step supervised training.
"""
CONFIGS = [
    {
        "scenario": scene,
        "task": "predict",
        "net": net,
        "train": "one",
        "start_seed": s,
        "num_seeds": 1,
        "num_spatial_dims": 3,
        "num_points": 32,
        "num_test_samples": 10,
    }
    for s in range(20)
    for net in [
        "Conv;26;12;relu",  # 202'489 params, 13 receptive field per direction
        "UNet;11;2;relu",  # 200'322 params, 29 receptive field per direction
        "Res;25;6;relu",  # 202'876 params, 12 receptive field per direction
        "FNO;5;7;4;gelu",  # 196'246 params, inf receptive field
        "Dil;2;27;2;relu",  # 197'722 params, 20 receptive field per direction
    ]
    for scene in [
        "phy_unbal_adv",
        "diff_burgers",  # Uses the three-channel version in 3D
        "diff_ks",
        "phy_gs",
        "phy_sh",
    ]
]
