"""
Ablate the size of the training dataset both in terms of the temporal horizon
(length of the train trajectories) and the number of samples (number of
trajectories = number of different initial conditions).

Compares all major architecture classes in 1D across five scenarios.

Only full prediction at one-step supervised training is considered.
"""
CONFIGS = [
    {
        "scenario": scenario,
        "task": "predict",
        "net": net,
        "train": "one",
        "start_seed": s,
        "num_seeds": 10,
        "num_train_samples": num_train_samples,
        "train_temporal_horizon": train_temporal_horizon,
    }
    for s in [0, 10, 20, 30, 40]
    for net in [
        "Conv;34;10;relu",  # 31'757 params, 11 receptive field per direction
        "UNet;12;2;relu",  # 27'193 params, 29 receptive field per direction
        "Res;26;8;relu",  # 32'943 params, 16 receptive field per direction
        "FNO;12;18;4;gelu",  # 32'527 params, inf receptive field per direction
        "Dil;2;32;2;relu",  # 31'777 params, 20 receptive field per direction
    ]
    for train_temporal_horizon in [
        1,
        10,
        50,
    ]
    for num_train_samples in [
        1,
        2,
        3,
        4,
        5,
        10,
        15,
        20,
        25,
        30,
        40,
        50,
        70,
        100,
    ]
    for scenario in [
        "diff_adv",
        "diff_diff",
        "diff_burgers",
        "diff_kdv",
        "diff_ks",
    ]
]
