# Anonymized code submission for Latent Diffusion for Neural Spiking Data

Steps:

1. Install the required packages
```bash
pip install -r requirements.txt
```

2. Download monkey and human data from the following links:

- Monkey data: `https://dandiarchive.org/dandiset/000128`

- Human data: `https://datadryad.org/stash/downloads/file_stream/2547369`

Store them in `data/000128` and `data/phoneme/competitionData` respectively.

The configuration files for all experiments are in the `conf` directory.

Lorenz exps -- use the following notebooks
 - notebooks/train_ae_lorenz.ipynb
 - notebooks/train_diffusion_lorenz.ipynb
 - plotting_Lorenz_diffusion.ipynb

Monkey data -- use the following notebooks
 - notebooks/train_count_ae_on_monkey.ipynb
 - notebooks/train_diffusion_monkey_uncond_anglecond.ipynb
 - notebooks/train_diffusion_monkey_vel_cond.ipynb
 - notebooks/plotting_uncoditional_diffusion_monkey.ipynb
 - notebooks/plotting_theta_conditional_diffusion_monkey.ipynb
 - notebooks/rate_history.ipynb
 - notebooks/plotting_vel_cond_diffusion_monkey.ipynb


Human data -- use the following scripts and notebooks
 - ntldm/train_autoencoder_phoneme.py
 - ntldm/train_diffusion_phoneme.py
 - notebooks/eval_diffusion_phoneme.ipynb


LFADS baseline on monkey data -- use the scripts
 - ntldm/baseline_samplers/lfads.py
 
THE READER IS NOT AUTHORIZED TO SHARE OR DISSEMINATE THE CODE.