# Schedule Your Edit: A Simple yet Effective Diffusion Noise Schedule for Image Editing



**📖 Table of Contents**

- [Method Overview](#method-overview)
- [Getting Started](#getting-started)
    - [Environment Requirement](#environment-requirement)
- [Running Scripts](#running-scripts)
    - [Inference](#inference)
    - [Evaluation](#evaluation)
- [Qualitative Results](#qualitative-results)


## 🛠️ Method Overview
<span id="method-overview"></span>

Text-guided diffusion models have significantly advanced image editing, enabling high-quality and diverse modifications driven by text prompts. However, effective editing requires inverting the source image into a latent space, a process often hindered by prediction errors inherent in DDIM inversion. 
These errors accumulate during the diffusion process, resulting in inferior content preservation and edit fidelity, especially with conditional inputs. 
We address these challenges by investigating the primary contributors to error accumulation in DDIM inversion and identify the singularity problem in traditional noise schedules as a key issue. 
To resolve this, we introduce the *Logistic Schedule*, a novel noise schedule designed to eliminate singularities, improve inversion stability, and provide a better noise space for image editing. This schedule reduces noise prediction errors, enabling more faithful editing that preserves the original content of the source image. Our approach requires no additional retraining and is compatible with various existing editing methods. 
Experiments across eight editing tasks demonstrate the *Logistic Schedule*'s superior performance in content preservation and edit fidelity compared to traditional noise schedules, highlighting its adaptability and effectiveness.

![teaser](assets/homepage.jpg)
![outline](assets/inversion_process-derivatives.jpg)
![compare](assets/schedule_compare-and-derivatives.jpg)

Sure, here is the rephrased markdown:

## 🚀 Getting Started
<span id="getting-started"></span>

### Environment Requirements 🌍
<span id="environment-requirement"></span>

Different models require specific Python environments (e.g., different versions of diffusers). These requirements are listed in the "environment" folder as detailed below:

- `p2p_requirements.txt`: `run_editing_stylediffusion.py` and `run_editing_edit_friendly_p2p.py`
- `masactrl_requirements.txt`: `run_editing_masactrl.py`
- `pnp_requirements.txt`: `run_editing_pnp.py`
- `pix2pix_zero_requirements.txt`: `run_editing_pix2pix_zero.py`

For instance, to use the models in `run_editing_pnp.py`, install the environment with the following commands:

```shell
conda create -n pnp python=3.9 -y
conda activate pnp
pip3 install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118
pip install -r environment/pnp_requirements.txt
```

## 🏃🏼 Running Scripts
<span id="running-scripts"></span>

### Inference 📜
<span id="inference"></span>

**To Run:**

```bash
bash ./scripts/run_masactrl.sh
bash ./scripts/run_pnp.sh
bash ./scripts/run_pix2pix_zero.sh
bash ./scripts/stylediffusion.sh
```

### Evaluation 📐
<span id="evaluation"></span>

You can run evaluations using:

```shell
python evaluation/evaluate.py --metrics "structure_distance" "psnr_unedit_part" "lpips_unedit_part" "mse_unedit_part" "ssim_unedit_part" "clip_similarity_source_image" "clip_similarity_target_image" "clip_similarity_target_image_edit_part" --result_path evaluation_result.csv --tgt_methods 1_ddim+pnp 1_sye+pnp
```

The choices for `tgt_methods` can be found in `evaluation/evaluate.py` under the dictionary "all_tgt_image_folders".

```
output
  |-- ddim+pnp
    |-- annotation_images
      |-- ...
  |-- sye+pnp
    |-- annotation_images
      |-- ...
...    
```

## 🌟 Qualitative Results

<span id="qualitative-results"></span>

![results-main](assets/results-main.jpg)

![add_obj](assets/add_obj.jpg)

![i2i](assets/i2i.jpg)

![pose](assets/pose.jpg)

![pose](assets/attr_color.jpg)

![content](assets/attr_content.jpg)

![materials](assets/attr_materials.jpg)

![scene](assets/scene.jpg)

![style](assets/style.jpg)

