/*
 * Decompiled with CFR 0.152.
 */
package scienceworld.objects.devices;

import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$StringFormat$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scienceworld.objects.devices.Device;
import scienceworld.properties.ContainerProperties;
import scienceworld.properties.DeviceProperties;
import scienceworld.properties.GlassProp;
import scienceworld.properties.IsNotContainer;
import scienceworld.properties.IsUsable;
import scienceworld.properties.MaterialProperties;
import scienceworld.properties.MoveableProperties;
import scienceworld.struct.EnvObject;

@ScalaSignature(bytes="\u0006\u0001\u001d3AAB\u0004\u0001\u001d!)1\u0003\u0001C\u0001)!)a\u0003\u0001C\u0001/!)\u0011\u0007\u0001C!e!)1\b\u0001C!y!)\u0001\t\u0001C!\u0003\nYA\u000b[3s[>lW\r^3s\u0015\tA\u0011\"A\u0004eKZL7-Z:\u000b\u0005)Y\u0011aB8cU\u0016\u001cGo\u001d\u0006\u0002\u0019\u0005a1oY5f]\u000e,wo\u001c:mI\u000e\u00011C\u0001\u0001\u0010!\t\u0001\u0012#D\u0001\b\u0013\t\u0011rA\u0001\u0004EKZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"\u0001\u0005\u0001\u0002!\u001d,G\u000fR3wS\u000e,'+Z1eS:<GC\u0001\r*!\rIBDH\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1q\n\u001d;j_:\u0004\"a\b\u0014\u000f\u0005\u0001\"\u0003CA\u0011\u001b\u001b\u0005\u0011#BA\u0012\u000e\u0003\u0019a$o\\8u}%\u0011QEG\u0001\u0007!J,G-\u001a4\n\u0005\u001dB#AB*ue&twM\u0003\u0002&5!)!F\u0001a\u0001W\u0005\u0019qN\u00196\u0011\u00051zS\"A\u0017\u000b\u00059Z\u0011AB:ueV\u001cG/\u0003\u00021[\tIQI\u001c<PE*,7\r^\u0001\bkN,w+\u001b;i)\t\u0019\u0014\b\u0005\u0003\u001aiYr\u0012BA\u001b\u001b\u0005\u0019!V\u000f\u001d7feA\u0011\u0011dN\u0005\u0003qi\u0011qAQ8pY\u0016\fg\u000eC\u0003;\u0007\u0001\u00071&\u0001\u0006qCRLWM\u001c;PE*\fAbZ3u%\u00164WM]3oiN$\u0012!\u0010\t\u0004?yr\u0012BA )\u0005\r\u0019V\r^\u0001\u000fO\u0016$H)Z:de&\u0004H/[8o)\tq\"\tC\u0004D\u000bA\u0005\t\u0019\u0001#\u0002\t5|G-\u001a\t\u00033\u0015K!A\u0012\u000e\u0003\u0007%sG\u000f")
public class Thermometer
extends Device {
    public Option<String> getDeviceReading(EnvObject obj) {
        if (!obj.propMaterial().isDefined()) {
            return None$.MODULE$;
        }
        double objTemp = obj.propMaterial().get().temperatureC();
        return new Some<String>(new java.lang.StringBuilder(16).append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToDouble(objTemp)), "%.0f")).append(" degrees celsius").toString());
    }

    @Override
    public Tuple2<Object, String> useWith(EnvObject patientObj) {
        Option<String> currentMeasurement = this.getDeviceReading(patientObj);
        if (currentMeasurement.isEmpty()) {
            return new Tuple2<Object, String>(BoxesRunTime.boxToBoolean(true), "That thing doesn't appear to have a temperature that the thermometer can read. ");
        }
        return new Tuple2<Object, String>(BoxesRunTime.boxToBoolean(true), new java.lang.StringBuilder(42).append("the thermometer measures a temperature of ").append((Object)currentMeasurement.get()).toString());
    }

    @Override
    public Set<String> getReferents() {
        return (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"thermometer", this.name(), this.getDescriptName(this.getDescriptName$default$1())}));
    }

    @Override
    public String getDescription(int mode) {
        StringBuilder os = new StringBuilder();
        Option currentMeasurement = None$.MODULE$;
        currentMeasurement = this.getDeviceReading(this);
        StringBuilder stringBuilder = currentMeasurement.isDefined() ? os.append(new java.lang.StringBuilder(39).append("a ").append(this.getDescriptName(this.getDescriptName$default$1())).append(", currently reading a temperature of ").append(currentMeasurement.get()).toString()) : os.append(new java.lang.StringBuilder(2).append("a ").append(this.getDescriptName(this.getDescriptName$default$1())).toString());
        return os.toString();
    }

    public Thermometer() {
        this.name_$eq("thermometer");
        this.propMaterial_$eq(new Some<MaterialProperties>(new GlassProp()));
        this.propContainer_$eq(new Some<ContainerProperties>(new IsNotContainer()));
        this.propDevice_$eq(new Some<DeviceProperties>(new IsUsable()));
        this.propMoveable_$eq(new Some<MoveableProperties>(new MoveableProperties(true)));
    }
}

