/*
 * Decompiled with CFR 0.152.
 */
package scienceworld.goldagent;

import java.io.PrintWriter;
import java.io.Serializable;
import main.scala.scienceworld.runtime.SimplifierProcessor$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Predef$StringFormat$;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.runtime.java8.JFunction1$mcVD$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.sys.package$;
import scala.util.control.Breaks$;
import scienceworld.goldagent.RunHistory;
import scienceworld.goldagent.RunHistory$;
import scienceworld.runtime.AgentInterface;
import scienceworld.runtime.pythonapi.PythonInterface;

public final class ExampleGoldAgent$ {
    public static ExampleGoldAgent$ MODULE$;

    static {
        new ExampleGoldAgent$();
    }

    public void main(String[] args) {
        PythonInterface pythonInterface = new PythonInterface();
        int[] specificTasks = new int[]{0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
        String exportFilename = new StringBuilder(19).append("goldsequences-").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(specificTasks)).mkString("-")).append(".json").toString();
        String simplificationStr = "easy";
        ArrayBuffer errors = new ArrayBuffer();
        IntRef numVariationsTested = IntRef.create(0);
        ArrayBuffer errorHistories = new ArrayBuffer();
        ArrayBuffer<RunHistory> goldActionSequences = new ArrayBuffer<RunHistory>();
        List taskNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(pythonInterface.getTaskNames()).asScala()).toList();
        Predef$.MODULE$.println("TASK LIST: ");
        String[] taskList = pythonInterface.taskMaker().getTaskList();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), taskList.length).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            String taskName = taskList[i];
            int numVariations = pythonInterface.taskMaker().getMaxVariations(taskName);
            Predef$.MODULE$.println(new StringBuilder(18).append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToInteger(i)), "%5s")).append(": \t").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(taskName), "%60s")).append("  (").append(numVariations).append(" variations)").toString());
        });
        ArrayBuffer taskScores = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), taskNames.length()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)taskIdx -> Breaks$.MODULE$.breakable((JFunction0$mcV$sp & scala.Serializable)() -> {
            String taskName = (String)taskNames.apply(taskIdx);
            if (!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(specificTasks)).isEmpty() && !new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(specificTasks)).contains(BoxesRunTime.boxToInteger(taskIdx))) {
                taskScores.append(Predef$.MODULE$.wrapRefArray((Object[])new double[][]{(double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())}));
                throw Breaks$.MODULE$.break();
            }
            boolean curEpisode = false;
            LongRef totalSteps = LongRef.create(0L);
            ObjectRef<String> userInput = ObjectRef.create("look around");
            ArrayBuffer episodeScores = new ArrayBuffer();
            int maxTaskVariations = pythonInterface.getTaskMaxVariations(taskName);
            IntRef subsampleEveryNth = IntRef.create(1);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxTaskVariations).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)variationIdx -> {
                block3: {
                    if (variationIdx % subsampleEveryNth$1.elem != 0) break block3;
                    Predef$.MODULE$.println("---------------------------");
                    Predef$.MODULE$.println(new StringBuilder(11).append("   Task ").append(taskIdx).append("   ").append(taskName).toString());
                    Predef$.MODULE$.println(new StringBuilder(17).append("   Variation: ").append(variationIdx).append(" / ").append(maxTaskVariations).toString());
                    Predef$.MODULE$.println("---------------------------");
                    pythonInterface.load(taskName, variationIdx, simplificationStr, true);
                    Option<AgentInterface> agentInterface = pythonInterface.agentInterface();
                    Predef$.MODULE$.println(new StringBuilder(18).append("Task Description: ").append(agentInterface.get().getTaskDescription()).toString());
                    String[] goldActionSeq = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(pythonInterface.getGoldActionSequence()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
                    String foldDesc = "train";
                    if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(pythonInterface.getVariationsDev()).asScala()).toArray(ClassTag$.MODULE$.Int()))).contains(BoxesRunTime.boxToInteger(variationIdx))) {
                        foldDesc = "dev";
                    }
                    if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(pythonInterface.getVariationsTest()).asScala()).toArray(ClassTag$.MODULE$.Int()))).contains(BoxesRunTime.boxToInteger(variationIdx))) {
                        foldDesc = "test";
                    }
                    RunHistory history = new RunHistory(taskName, taskIdx, variationIdx, agentInterface.get().getTaskDescription(), simplificationStr, foldDesc);
                    String initialFl = pythonInterface.freeActionLook();
                    String initialInv = pythonInterface.freeActionInventory();
                    Tuple3<String, Object, Object> initialObs = agentInterface.get().step("look around");
                    history.addStep("look around", initialObs, initialFl, initialInv);
                    DoubleRef curScore = DoubleRef.create(0.0);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), goldActionSeq.length).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)actionIdx -> {
                        userInput$1.elem = goldActionSeq[actionIdx];
                        String freelookStr = pythonInterface.freeActionLook();
                        String inventoryStr = pythonInterface.freeActionInventory();
                        Predef$.MODULE$.println(new StringBuilder(3).append(">> ").append((String)userInput$1.elem).toString());
                        Tuple3<String, Object, Object> observation = ((AgentInterface)agentInterface.get()).step((String)userInput$1.elem);
                        curScore$1.elem = BoxesRunTime.unboxToDouble(observation._2());
                        Predef$.MODULE$.println("Observation: ");
                        Predef$.MODULE$.println(observation);
                        history.addStep((String)userInput$1.elem, observation, freelookStr, inventoryStr);
                        if (((AgentInterface)agentInterface.get()).isInErrorState()) {
                            Predef$.MODULE$.println("Action History:");
                            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), actionIdx).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> Predef$.MODULE$.println(new StringBuilder(3).append(i).append(": \t").append(goldActionSeq[i]).toString()));
                            Predef$.MODULE$.println("");
                            Predef$.MODULE$.println("ERROR STATE DETECTED!");
                            Predef$.MODULE$.println("ERROR MESSAGE: ");
                            Predef$.MODULE$.println(((AgentInterface)agentInterface.get()).getErrorStateMessage());
                            throw package$.MODULE$.exit(1);
                        }
                        ++totalSteps$1.elem;
                    });
                    history.addNote(agentInterface.get().getGoalProgressStr());
                    if (curScore.elem < 1.0) {
                        String errStr = new StringBuilder(90).append("ERROR: Score not 100% after running gold action sequence (Task: ").append(taskName).append(", VariationIdx: ").append(variationIdx).append(", Score: ").append(curScore.elem).append(")").toString();
                        Predef$.MODULE$.println(errStr);
                        errors.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{errStr}));
                        Predef$.MODULE$.println(new StringBuilder(15).append("Gold sequence: ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])goldActionSeq)).mkString(", ")).toString());
                        errorHistories.append(Predef$.MODULE$.wrapRefArray((Object[])new RunHistory[]{history}));
                    }
                    episodeScores.append(Predef$.MODULE$.wrapDoubleArray(new double[]{curScore.elem}));
                    ++numVariationsTested$1.elem;
                    goldActionSequences.append(Predef$.MODULE$.wrapRefArray((Object[])new RunHistory[]{history}));
                }
            });
            taskScores.append(Predef$.MODULE$.wrapRefArray((Object[])new double[][]{(double[])episodeScores.toArray(ClassTag$.MODULE$.Double())}));
            Predef$.MODULE$.println("ERROR HISTORIES:");
            errorHistories.foreach((Function1<RunHistory, Object> & Serializable & scala.Serializable)history -> {
                Predef$.MODULE$.println(history.toString());
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.println("");
            Predef$.MODULE$.println("---------------------------------");
            Predef$.MODULE$.println("Scores:");
            Predef$.MODULE$.println(new StringBuilder(17).append("Simplifications: ").append(SimplifierProcessor$.MODULE$.getSimplificationsUsed()).toString());
            Predef$.MODULE$.println("---------------------------------");
            Predef$.MODULE$.println(new StringBuilder(35).append("Total number of variations tested: ").append(numVariationsTested$1.elem).toString());
            Predef$.MODULE$.println(new StringBuilder(53).append("Total number of variations with errors in gold path: ").append(errors.length()).toString());
            Predef$.MODULE$.println("---------------------------------");
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), taskScores.length()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)taskIdx -> {
                String taskName = (String)taskNames.apply(taskIdx);
                Predef$.MODULE$.println(new StringBuilder(3).append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToInteger(taskIdx)), "%3s")).append(": ").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(taskName), "%60s")).append("\t").append(MODULE$.summaryStatistics((double[])taskScores.apply(taskIdx))).toString());
            });
            Predef$.MODULE$.println("---------------------------------");
        }));
        Predef$.MODULE$.println("Exporting gold action sequences...");
        this.exportGoldActionSequencesJSON(goldActionSequences, exportFilename);
        Predef$.MODULE$.println("Completed...");
    }

    public String summaryStatistics(double[] in) {
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        if (in.length == 0) {
            return "no samples";
        }
        DoubleRef min = DoubleRef.create(in[0]);
        DoubleRef max = DoubleRef.create(in[0]);
        DoubleRef avg = DoubleRef.create(0.0);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(in)).foreach((JFunction1$mcVD$sp & scala.Serializable)elem -> {
            block2: {
                if (elem < min$1.elem) {
                    min$1.elem = elem;
                }
                if (elem > max$1.elem) {
                    max$1.elem = elem;
                }
                if (!(elem >= 0.0)) break block2;
                avg$1.elem += elem;
            }
        });
        avg.elem /= (double)in.length;
        os.append(new StringBuilder(11).append("min: ").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToDouble(min.elem)), "%3.2f")), "%5s")).append("      ").toString());
        os.append(new StringBuilder(11).append("max: ").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToDouble(max.elem)), "%3.2f")), "%5s")).append("      ").toString());
        os.append(new StringBuilder(11).append("avg: ").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToDouble(avg.elem)), "%3.2f")), "%5s")).append("      ").toString());
        return os.toString();
    }

    public void exportGoldActionSequencesJSON(ArrayBuffer<RunHistory> goldActionSequences, String filenameOut) {
        Predef$.MODULE$.println(new StringBuilder(37).append("Exporting gold action sequences... (").append(filenameOut).append(")").toString());
        PrintWriter pw = new PrintWriter(filenameOut);
        int[] taskIdxs = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((TraversableOnce)goldActionSequences.map((Function1<RunHistory, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.taskIdx()), ArrayBuffer$.MODULE$.canBuildFrom())).toSet().toArray(ClassTag$.MODULE$.Int()))).sorted((Ordering)Ordering$Int$.MODULE$);
        ArrayBuffer taskJson = new ArrayBuffer();
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(taskIdxs)).foreach((JFunction1$mcVI$sp & scala.Serializable)taskIdx -> {
            block0: {
                ArrayBuffer elems = new ArrayBuffer();
                ArrayBuffer variations = (ArrayBuffer)((SeqLike)goldActionSequences.filter((Function1<RunHistory, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(ExampleGoldAgent$.$anonfun$exportGoldActionSequencesJSON$3(taskIdx, x$2)))).sortBy((Function1<RunHistory, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger(x$3.variationIdx()), Ordering$Int$.MODULE$);
                Predef$.MODULE$.println(new StringBuilder(22).append(" * Task ").append(taskIdx).append(" (variations: ").append(variations.length()).toString());
                if (variations.length() <= 0) break block0;
                variations.foreach((Function1<RunHistory, Object> & Serializable & scala.Serializable)variation -> {
                    elems.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(63).append("\t{\"variationIdx\": ").append(variation.variationIdx()).append(", \"fold\":\"").append(variation.foldDesc()).append("\", \"taskDescription\":\"").append(RunHistory$.MODULE$.sanitizeJSON(variation.taskDescription())).append("\", \"path\": \n").append(variation.toJSONArray(2)).append("}").toString()}));
                    return BoxedUnit.UNIT;
                });
                scala.collection.mutable.StringBuilder jsonOut = new scala.collection.mutable.StringBuilder();
                jsonOut.append(new StringBuilder(5).append("\"").append(taskIdx).append("\": {").toString());
                jsonOut.append(new StringBuilder(13).append("\"taskIdx\": ").append(taskIdx).append(", ").toString());
                jsonOut.append(new StringBuilder(16).append("\"taskName\": \"").append(((RunHistory)variations.apply(0)).taskName()).append("\", ").toString());
                jsonOut.append("\"goldActionSequences\": [\n");
                jsonOut.append(elems.mkString(", \n"));
                jsonOut.append("]} ");
                taskJson.append(Predef$.MODULE$.wrapRefArray((Object[])new String[]{jsonOut.toString()}));
            }
        });
        pw.print(new StringBuilder(2).append("{").append(taskJson.mkString(", \n")).append("}").toString());
        pw.flush();
        pw.close();
    }

    public static final /* synthetic */ boolean $anonfun$exportGoldActionSequencesJSON$3(int taskIdx$2, RunHistory x$2) {
        return x$2.taskIdx() == taskIdx$2;
    }

    private ExampleGoldAgent$() {
        MODULE$ = this;
    }
}

