/*
 * Decompiled with CFR 0.152.
 */
package language.runtime;

import java.io.File;
import java.io.Serializable;
import language.model.ActionRequestDef;
import language.model.ImportFile;
import language.model.Program;
import language.parser.Parser;
import language.runtime.Interpreter;
import language.runtime.runners.ActionRunner;
import language.struct.WalkControl;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.sys.package$;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.input.Reader;

public final class Reader$ {
    public static Reader$ MODULE$;

    static {
        new Reader$();
    }

    public Tuple3<Program, Object, Set<String>> parseProgramFromFile(Parser parser, String scriptFilename, String referringFilename, Set<String> filenamesAlreadyImported) {
        Tuple3 tuple3;
        Object object = new Object();
        try {
            Predef$.MODULE$.println(new StringBuilder(25).append(" * parseProgramFromFile: ").append(scriptFilename).toString());
            String fileAbsolute = new File(scriptFilename).getCanonicalPath();
            String pathAbsolute = fileAbsolute.substring(0, fileAbsolute.lastIndexOf(File.separator));
            filenamesAlreadyImported.add(fileAbsolute);
            String scriptStr = "";
            try {
                scriptStr = this.fileToString(fileAbsolute);
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println(new StringBuilder(49).append("ERROR: Could not import file (").append(fileAbsolute).append(") referenced by (").append(referringFilename).append(").").toString());
                throw package$.MODULE$.exit(1);
            }
            Tuple2<Program, Object> tuple2 = this.parseProgramFromString(parser, scriptStr, fileAbsolute);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Program program = tuple2._1();
            boolean success = tuple2._2$mcZ$sp();
            Tuple2<Program, Boolean> tuple22 = new Tuple2<Program, Boolean>(program, BoxesRunTime.boxToBoolean(success));
            Tuple2<Program, Boolean> tuple23 = tuple22;
            ObjectRef<Program> program2 = ObjectRef.create(tuple23._1());
            boolean success2 = tuple23._2$mcZ$sp();
            program2.elem = ((Program)program2.elem).inheritClassProperties();
            if (((Program)program2.elem).hasErrors()) {
                String[] errorStrs = ((Program)program2.elem).getErrors();
                Predef$.MODULE$.println(new StringBuilder(45).append(errorStrs.length).append(" error(s) were found after importing file (").append(scriptFilename).append("):").toString());
                new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])errorStrs)).foreach((Function1<String, Object> & Serializable & scala.Serializable)errorStr -> {
                    Predef$.MODULE$.println(errorStr);
                    return BoxedUnit.UNIT;
                });
                throw package$.MODULE$.exit(1);
            }
            if (((Program)program2.elem).importList().isDefined()) {
                ((Program)program2.elem).importList().get().foreach((Function1<ImportFile, Object> & Serializable & scala.Serializable)importFile -> {
                    Reader$.$anonfun$parseProgramFromFile$2(pathAbsolute, filenamesAlreadyImported, parser, scriptFilename, object, program2, importFile);
                    return BoxedUnit.UNIT;
                });
            }
            tuple3 = new Tuple3<Program, Boolean, Set<String>>((Program)program2.elem, BoxesRunTime.boxToBoolean(success2), filenamesAlreadyImported);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple3 = (Tuple3)ex.value();
            }
            throw ex;
        }
        return tuple3;
    }

    public String parseProgramFromFile$default$3() {
        return "";
    }

    public Set<String> parseProgramFromFile$default$4() {
        return (Set)Set$.MODULE$.apply(Nil$.MODULE$);
    }

    public Tuple2<Program, Object> parseProgramFromString(Parser parser, String script, String originalFilename) {
        Parsers.ParseResult<Program> parseResult = parser.parseAll(parser.program(), script);
        if (parseResult instanceof Parsers.Success) {
            Parsers.Success success = (Parsers.Success)parseResult;
            Program r = (Program)success.result();
            Program program = r;
            if (program != null) {
                Program program2 = program;
                Predef$.MODULE$.println("Program successfully parsed.");
                return new Tuple2<Program, Object>(program2, BoxesRunTime.boxToBoolean(true));
            }
            throw new MatchError(program);
        }
        if (parseResult instanceof Parsers.Error) {
            Parsers.Error error = (Parsers.Error)parseResult;
            String msg = error.msg();
            Reader<Object> next = error.next();
            String errorStr = new StringBuilder(17).append("line ").append(next.pos().line()).append(", column ").append(next.pos().column()).append(": ").append(msg).append("\n").append(next.pos().longString()).toString();
            Predef$.MODULE$.println(new StringBuilder(18).append("Failure Parsing: ").append(originalFilename).append("\n").append(errorStr).toString());
            return new Tuple2<Program, Object>(new Program(), BoxesRunTime.boxToBoolean(false));
        }
        if (parseResult instanceof Parsers.Failure) {
            Parsers.Failure failure = (Parsers.Failure)parseResult;
            String msg = failure.msg();
            Reader<Object> next = failure.next();
            String errorStr = new StringBuilder(17).append("line ").append(next.pos().line()).append(", column ").append(next.pos().column()).append(": ").append(msg).append("\n").append(next.pos().longString()).toString();
            Predef$.MODULE$.println(new StringBuilder(18).append("Failure Parsing: ").append(originalFilename).append("\n").append(errorStr).toString());
            return new Tuple2<Program, Object>(new Program(), BoxesRunTime.boxToBoolean(false));
        }
        Predef$.MODULE$.println("Unknown error while parsing.");
        return new Tuple2<Program, Object>(new Program(), BoxesRunTime.boxToBoolean(false));
    }

    public String parseProgramFromString$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public String fileToString(String filename) {
        void var3_3;
        BufferedSource file = Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec());
        String str = file.mkString();
        return var3_3;
    }

    public void main(String[] args) {
        String exampleScriptStr = new StringOps(Predef$.MODULE$.augmentString("println()\n        |")).stripMargin();
        String exampleScriptStr1 = new StringOps(Predef$.MODULE$.augmentString("println()\n        |println()\n        |println()\n        |def blah() = { println() }\n        |def blah(a=b) = { println() }\n        |def blah(a=b, c=d, e=f) = { println() }\n        |def blah(a=b, c=d, e=f) = { println() }\n        |")).stripMargin();
        Parser parser = new Parser();
        String scriptFilename = "tests/test3.env";
        Tuple3<Program, Object, Set<String>> tuple3 = this.parseProgramFromFile(parser, scriptFilename, this.parseProgramFromFile$default$3(), this.parseProgramFromFile$default$4());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Program program = tuple3._1();
        boolean success = BoxesRunTime.unboxToBoolean(tuple3._2());
        Set<String> importedFiles = tuple3._3();
        Tuple3<Program, Boolean, Set<String>> tuple32 = new Tuple3<Program, Boolean, Set<String>>(program, BoxesRunTime.boxToBoolean(success), importedFiles);
        Tuple3<Program, Boolean, Set<String>> tuple33 = tuple32;
        Program program2 = tuple33._1();
        boolean success2 = BoxesRunTime.unboxToBoolean(tuple33._2());
        Set<String> importedFiles2 = tuple33._3();
        if (!success2) {
            Predef$.MODULE$.println("Parse unsuccessful. ");
            throw package$.MODULE$.exit(1);
        }
        Predef$.MODULE$.println("Program:");
        Predef$.MODULE$.println(program2.toString());
        Predef$.MODULE$.println("");
        ActionRequestDef[] possibleActions = (ActionRequestDef[])((TraversableOnce)program2.actions().getOrElse((Function0<List> & Serializable & scala.Serializable)() -> List$.MODULE$.empty())).toArray(ClassTag$.MODULE$.apply(ActionRequestDef.class));
        ActionRunner actionRunner = new ActionRunner(possibleActions, program2.taxonomy());
        Predef$.MODULE$.println("Interpreter:");
        Interpreter interpreter = new Interpreter(program2.definesLUT(), program2.classLUT(), actionRunner);
        WalkControl result = interpreter.walkOneStep(program2.statements().get());
        if (!result.success()) {
            Predef$.MODULE$.println("Interpreter exited with error. ");
            throw package$.MODULE$.exit(1);
        }
        Predef$.MODULE$.println("Interpreter completed successfully. ");
        int numIter = 2;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numIter).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)curIter -> {
            Predef$.MODULE$.println("---------------------------------------");
            Predef$.MODULE$.println(new StringBuilder(11).append(" Iteration ").append(curIter).toString());
            Predef$.MODULE$.println("---------------------------------------");
        });
    }

    public static final /* synthetic */ void $anonfun$parseProgramFromFile$2(String pathAbsolute$1, Set filenamesAlreadyImported$1, Parser parser$1, String scriptFilename$1, Object nonLocalReturnKey1$1, ObjectRef program$1, ImportFile importFile) {
        Predef$.MODULE$.println(new StringBuilder(16).append("Importing file: ").append(importFile.filename()).toString());
        String importFilename = new File(new StringBuilder(0).append(pathAbsolute$1).append(File.separator).append(importFile.filename()).toString()).getCanonicalPath();
        if (!filenamesAlreadyImported$1.contains(importFilename)) {
            Tuple3<Program, Object, Set<String>> tuple3 = MODULE$.parseProgramFromFile(parser$1, importFilename, scriptFilename$1, filenamesAlreadyImported$1);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Program programImport = tuple3._1();
            boolean successImport = BoxesRunTime.unboxToBoolean(tuple3._2());
            Set<String> parsedFilesImport = tuple3._3();
            Tuple3<Program, Boolean, Set<String>> tuple32 = new Tuple3<Program, Boolean, Set<String>>(programImport, BoxesRunTime.boxToBoolean(successImport), parsedFilesImport);
            Tuple3<Program, Boolean, Set<String>> tuple33 = tuple32;
            Program programImport2 = tuple33._1();
            boolean successImport2 = BoxesRunTime.unboxToBoolean(tuple33._2());
            Set<String> parsedFilesImport2 = tuple33._3();
            filenamesAlreadyImported$1.$plus$plus$eq(parsedFilesImport2);
            if (!successImport2) {
                throw new NonLocalReturnControl<Tuple3<Program, Boolean, Set>>(nonLocalReturnKey1$1, new Tuple3<Program, Boolean, Set>(new Program(), BoxesRunTime.boxToBoolean(false), filenamesAlreadyImported$1));
            }
            program$1.elem = ((Program)program$1.elem).$plus(programImport2);
            program$1.elem = ((Program)program$1.elem).inheritClassProperties();
            if (((Program)program$1.elem).hasErrors()) {
                String[] errorStrs = ((Program)program$1.elem).getErrors();
                Predef$.MODULE$.println(new StringBuilder(45).append(errorStrs.length).append(" error(s) were found after importing file (").append(importFilename).append("):").toString());
                new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])errorStrs)).foreach((Function1<String, Object> & Serializable & scala.Serializable)errorStr -> {
                    Predef$.MODULE$.println(errorStr);
                    return BoxedUnit.UNIT;
                });
                throw package$.MODULE$.exit(1);
            }
        } else {
            Predef$.MODULE$.println(new StringBuilder(29).append("Already imported: ").append(importFilename).append(" (SKIPPING)").toString());
        }
    }

    private Reader$() {
        MODULE$ = this;
    }
}

