/*
 * Decompiled with CFR 0.152.
 */
package scienceworld.processes.genetics;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$StringFormat$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scienceworld.processes.genetics.ChromosomePair$;
import scienceworld.processes.genetics.Chromosomes;
import scienceworld.processes.genetics.GeneticTrait;
import scienceworld.processes.genetics.GeneticTrait$;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0007\u000e\u0001C!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003+\u0011!y\u0003A!b\u0001\n\u0003I\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u000bE\u0002A\u0011\u0001\u001a\t\u000fY\u0002!\u0019!C\u0001o!1a\b\u0001Q\u0001\naBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004P\u0001\u0001\u0006I!\u0011\u0005\b!\u0002\u0011\r\u0011\"\u0001A\u0011\u0019\t\u0006\u0001)A\u0005\u0003\")!\u000b\u0001C\u0001'\")q\u000b\u0001C\u00011\")\u0011\f\u0001C\u00015\")\u0001\r\u0001C\u0001C\")A\r\u0001C\u0001K\")1\u000e\u0001C\u0001Y\")Q\u000e\u0001C\u0001Y\")a\u000e\u0001C\u0001_\")\u0011\u000f\u0001C!e\u001e)1O\u0007E\u0001i\u001a)\u0011D\u0007E\u0001k\")\u0011G\u0006C\u0001m\")qO\u0006C\u0001q\nq1\t\u001b:p[>\u001cx.\\3QC&\u0014(BA\u000e\u001d\u0003!9WM\\3uS\u000e\u001c(BA\u000f\u001f\u0003%\u0001(o\\2fgN,7OC\u0001 \u00031\u00198-[3oG\u0016<xN\u001d7e\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0001\u0018M]3oiF*\u0012A\u000b\t\u0003W1j\u0011AG\u0005\u0003[i\u00111b\u00115s_6|7o\\7fg\u0006A\u0001/\u0019:f]R\f\u0004%A\u0004qCJ,g\u000e\u001e\u001a\u0002\u0011A\f'/\u001a8ue\u0001\na\u0001P5oSRtDcA\u001a5kA\u00111\u0006\u0001\u0005\u0006Q\u0015\u0001\rA\u000b\u0005\u0006_\u0015\u0001\rAK\u0001\u000ba\",gn\u001c;za\u0016\u001cX#\u0001\u001d\u0011\u0007\rJ4(\u0003\u0002;I\t)\u0011I\u001d:bsB\u00111\u0006P\u0005\u0003{i\u0011AbR3oKRL7\r\u0016:bSR\f1\u0002\u001d5f]>$\u0018\u0010]3tA\u0005\u0001\u0002\u000f[3o_RL\b/Z*ue&twm]\u000b\u0002\u0003B!!)\u0013'M\u001d\t\u0019u\t\u0005\u0002EI5\tQI\u0003\u0002GA\u00051AH]8pizJ!\u0001\u0013\u0013\u0002\rA\u0013X\rZ3g\u0013\tQ5JA\u0002NCBT!\u0001\u0013\u0013\u0011\u0005\tk\u0015B\u0001(L\u0005\u0019\u0019FO]5oO\u0006\t\u0002\u000f[3o_RL\b/Z*ue&twm\u001d\u0011\u0002\u001fADWM\\8usB,g+\u00197vKN\f\u0001\u0003\u001d5f]>$\u0018\u0010]3WC2,Xm\u001d\u0011\u0002\u001b\u001d,G\u000f\u0016:bSRt\u0015-\\3t)\u0005!\u0006c\u0001\"V\u0019&\u0011ak\u0013\u0002\u0004'\u0016$\u0018!D4fiBCWM\\8usB,7\u000fF\u00019\u000319W\r\u001e)iK:|G/\u001f9f)\tYf\fE\u0002$9nJ!!\u0018\u0013\u0003\r=\u0003H/[8o\u0011\u0015yf\u00021\u0001M\u0003%!(/Y5u\u001d\u0006lW-A\thKR\u0004\u0006.\u001a8pif\u0004XMV1mk\u0016$\"AY2\u0011\u0007\rbF\nC\u0003`\u001f\u0001\u0007A*A\u0006hKR<UM\\8usB,GC\u00014k!\r\u0019Cl\u001a\t\u0005G!\\4(\u0003\u0002jI\t1A+\u001e9mKJBQa\u0018\tA\u00021\u000b1cZ3u!\",gn\u001c;za\u0016\u001cFO]5oON$\u0012!Q\u0001\u0013O\u0016$\b\u000b[3o_RL\b/\u001a,bYV,7/A\u0011hKR$&/Y5u!\",gn\u001c;za\u0016DU/\\1o%\u0016\fG-\u00192mKN#(\u000f\u0006\u0002ca\")ql\u0005a\u0001\u0019\u0006AAo\\*ue&tw\rF\u0001M\u00039\u0019\u0005N]8n_N|W.\u001a)bSJ\u0004\"a\u000b\f\u0014\u0005Y\u0011C#\u0001;\u0002\u000f5\\'\t\\1oWR\t1\u0007")
public class ChromosomePair {
    private final Chromosomes parent1;
    private final Chromosomes parent2;
    private final GeneticTrait[] phenotypes;
    private final Map<String, String> phenotypeStrings;
    private final Map<String, String> phenotypeValues;

    public static ChromosomePair mkBlank() {
        return ChromosomePair$.MODULE$.mkBlank();
    }

    public Chromosomes parent1() {
        return this.parent1;
    }

    public Chromosomes parent2() {
        return this.parent2;
    }

    public GeneticTrait[] phenotypes() {
        return this.phenotypes;
    }

    public Map<String, String> phenotypeStrings() {
        return this.phenotypeStrings;
    }

    public Map<String, String> phenotypeValues() {
        return this.phenotypeValues;
    }

    public Set<String> getTraitNames() {
        return (Set)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.parent1().chromosomes())).map((Function1<GeneticTrait, String> & Serializable & scala.Serializable)x$1 -> x$1.traitName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet().$plus$plus(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.parent2().chromosomes())).map((Function1<GeneticTrait, String> & Serializable & scala.Serializable)x$2 -> x$2.traitName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet());
    }

    public GeneticTrait[] getPhenotypes() {
        ArrayBuffer out = new ArrayBuffer();
        this.getTraitNames().foreach((Function1<String, Object> & Serializable & scala.Serializable)traitName -> {
            ChromosomePair.$anonfun$getPhenotypes$1(this, out, traitName);
            return BoxedUnit.UNIT;
        });
        return (GeneticTrait[])out.toArray(ClassTag$.MODULE$.apply(GeneticTrait.class));
    }

    public Option<GeneticTrait> getPhenotype(String traitName) {
        Option<GeneticTrait> alleleP1 = this.parent1().getTrait(traitName);
        if (alleleP1.isEmpty()) {
            throw new RuntimeException(new StringBuilder(77).append("ERROR: ChromosomePair.gePhenotype(): One parent is missing critical genes (").append(alleleP1.get().traitName()).append(").").toString());
        }
        Option<GeneticTrait> alleleP2 = this.parent2().getTrait(traitName);
        if (alleleP2.isEmpty()) {
            throw new RuntimeException(new StringBuilder(77).append("ERROR: ChromosomePair.gePhenotype(): One parent is missing critical genes (").append(alleleP1.get().traitName()).append(").").toString());
        }
        if (alleleP1.get().isRecessiveValue() && alleleP2.get().isRecessiveValue()) {
            GeneticTrait phenotype = new GeneticTrait(alleleP1.get().traitName(), alleleP1.get().valueDominant(), alleleP1.get().valueRecessive(), alleleP1.get().strSuffix(), GeneticTrait$.MODULE$.RECESSIVE());
            return new Some<GeneticTrait>(phenotype);
        }
        GeneticTrait phenotype = new GeneticTrait(alleleP1.get().traitName(), alleleP1.get().valueDominant(), alleleP1.get().valueRecessive(), alleleP1.get().strSuffix(), GeneticTrait$.MODULE$.DOMINANT());
        return new Some<GeneticTrait>(phenotype);
    }

    public Option<String> getPhenotypeValue(String traitName) {
        if (!this.phenotypeValues().contains(traitName)) {
            return None$.MODULE$;
        }
        return new Some<String>((String)this.phenotypeValues().apply(traitName));
    }

    public Option<Tuple2<GeneticTrait, GeneticTrait>> getGenotype(String traitName) {
        ObjectRef<None$> traitP1 = ObjectRef.create(None$.MODULE$);
        ObjectRef<None$> traitP2 = ObjectRef.create(None$.MODULE$);
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.parent1().chromosomes())).foreach((Function1<GeneticTrait, Object> & Serializable & scala.Serializable)t -> {
            ChromosomePair.$anonfun$getGenotype$1(traitName, traitP1, t);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.parent2().chromosomes())).foreach((Function1<GeneticTrait, Object> & Serializable & scala.Serializable)t -> {
            ChromosomePair.$anonfun$getGenotype$2(traitName, traitP2, t);
            return BoxedUnit.UNIT;
        });
        if (((Option)traitP1.elem).isEmpty() || ((Option)traitP2.elem).isEmpty()) {
            return None$.MODULE$;
        }
        return new Some<Tuple2<GeneticTrait, GeneticTrait>>(new Tuple2(((Option)traitP1.elem).get(), ((Option)traitP2.elem).get()));
    }

    public Map<String, String> getPhenotypeStrings() {
        scala.collection.mutable.Map out = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        GeneticTrait[] phenotypes = this.getPhenotypes();
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])phenotypes)).foreach((Function1<GeneticTrait, Object> & Serializable & scala.Serializable)pTrait -> {
            ChromosomePair.$anonfun$getPhenotypeStrings$1(out, pTrait);
            return BoxedUnit.UNIT;
        });
        return out.toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> getPhenotypeValues() {
        scala.collection.mutable.Map out = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        GeneticTrait[] phenotypes = this.getPhenotypes();
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])phenotypes)).foreach((Function1<GeneticTrait, Object> & Serializable & scala.Serializable)pTrait -> {
            ChromosomePair.$anonfun$getPhenotypeValues$1(out, pTrait);
            return BoxedUnit.UNIT;
        });
        return out.toMap(Predef$.MODULE$.$conforms());
    }

    public Option<String> getTraitPhenotypeHumanReadableStr(String traitName) {
        if (!this.phenotypeStrings().contains(traitName)) {
            return None$.MODULE$;
        }
        return new Some<String>((String)this.phenotypeStrings().apply(traitName));
    }

    public String toString() {
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        String[] sortedNames = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.getTraitNames().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering$String$.MODULE$);
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])sortedNames)).foreach((Function1<String, scala.collection.mutable.StringBuilder> & Serializable & scala.Serializable)traitName -> {
            Option<Tuple2<GeneticTrait, GeneticTrait>> genotype = this.getGenotype((String)traitName);
            Option<GeneticTrait> phenotype = this.getPhenotype((String)traitName);
            return os.append(new StringBuilder(24).append("\t").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(traitName), "%20s")).append("\tGenotype\t").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(genotype.get()._1()), "%20s")).append("\t").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(genotype.get()._2()), "%20s")).append("\tPhenotype\t").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(phenotype.get()), "%20s")).append("\n").toString());
        });
        return os.toString();
    }

    public static final /* synthetic */ void $anonfun$getPhenotypes$1(ChromosomePair $this, ArrayBuffer out$2, String traitName) {
        Option<GeneticTrait> phenotype = $this.getPhenotype(traitName);
        out$2.append(Predef$.MODULE$.wrapRefArray((Object[])new GeneticTrait[]{phenotype.get()}));
    }

    public static final /* synthetic */ void $anonfun$getGenotype$1(String traitName$1, ObjectRef traitP1$1, GeneticTrait t) {
        block0: {
            String string = t.traitName();
            String string2 = traitName$1;
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            traitP1$1.elem = new Some<GeneticTrait>(t);
        }
    }

    public static final /* synthetic */ void $anonfun$getGenotype$2(String traitName$1, ObjectRef traitP2$1, GeneticTrait t) {
        block0: {
            String string = t.traitName();
            String string2 = traitName$1;
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            traitP2$1.elem = new Some<GeneticTrait>(t);
        }
    }

    public static final /* synthetic */ void $anonfun$getPhenotypeStrings$1(scala.collection.mutable.Map out$3, GeneticTrait pTrait) {
        String traitName = pTrait.traitName();
        String traitValueDesc = pTrait.mkHumanReadableDescStr();
        out$3.update(traitName, traitValueDesc);
    }

    public static final /* synthetic */ void $anonfun$getPhenotypeValues$1(scala.collection.mutable.Map out$4, GeneticTrait pTrait) {
        String traitName = pTrait.traitName();
        String traitValue = pTrait.getValue();
        out$4.update(traitName, traitValue);
    }

    public ChromosomePair(Chromosomes parent1, Chromosomes parent2) {
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.phenotypes = this.getPhenotypes();
        this.phenotypeStrings = this.getPhenotypeStrings();
        this.phenotypeValues = this.getPhenotypeValues();
    }
}

