/*
 * Decompiled with CFR 0.152.
 */
package scienceworld.objects.livingthing.plant;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scienceworld.objects.livingthing.LivingThing;
import scienceworld.processes.lifestage.LifeCycle;
import scienceworld.processes.lifestage.PlantLifeStages$;
import scienceworld.properties.ContainerProperties;
import scienceworld.properties.IsOpenUnclosableContainer;
import scienceworld.properties.LifeProperties;
import scienceworld.properties.LifePropertiesPlant;
import scienceworld.properties.MaterialProperties;
import scienceworld.properties.PlantMatterProp;
import scienceworld.struct.EnvObject;
import scienceworld.struct.EnvObject$;
import util.StringHelpers$;

@ScalaSignature(bytes="\u0006\u0001y2A\u0001C\u0005\u0001%!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)1\u0005\u0001C\u0001I!)\u0001\u0007\u0001C\u0001I!)\u0011\u0007\u0001C!9!)!\u0007\u0001C!g!)q\u0007\u0001C!q\t)\u0001\u000b\\1oi*\u0011!bC\u0001\u0006a2\fg\u000e\u001e\u0006\u0003\u00195\t1\u0002\\5wS:<G\u000f[5oO*\u0011abD\u0001\b_\nTWm\u0019;t\u0015\u0005\u0001\u0012\u0001D:dS\u0016t7-Z<pe2$7\u0001A\n\u0003\u0001M\u0001\"\u0001F\u000b\u000e\u0003-I!AF\u0006\u0003\u00171Kg/\u001b8h)\"LgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003%\ta![:TK\u0016$G#A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u000f\t{w\u000e\\3b]\u0006aq-\u001a;QY\u0006tG\u000fV=qKR\tQ\u0005\u0005\u0002'[9\u0011qe\u000b\t\u0003Q}i\u0011!\u000b\u0006\u0003UE\ta\u0001\u0010:p_Rt\u0014B\u0001\u0017 \u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051z\u0012\u0001D4fiBc\u0017M\u001c;OC6,\u0017\u0001\u0002;jG.\fAbZ3u%\u00164WM]3oiN$\u0012\u0001\u000e\t\u0004MU*\u0013B\u0001\u001c0\u0005\r\u0019V\r^\u0001\u000fO\u0016$H)Z:de&\u0004H/[8o)\t)\u0013\bC\u0004;\u000fA\u0005\t\u0019A\u001e\u0002\t5|G-\u001a\t\u0003=qJ!!P\u0010\u0003\u0007%sG\u000f")
public class Plant
extends LivingThing {
    public boolean isSeed() {
        return PlantLifeStages$.MODULE$.isSeed(this.lifecycle().get());
    }

    public String getPlantType() {
        return this.propLife().get().lifeformType();
    }

    public String getPlantName() {
        if (this.isSeed()) {
            String seedName = new StringBuilder(5).append(this.propLife().get().lifeformType()).append(" seed").toString();
            return this.getDescriptName(seedName);
        }
        String plantName = new StringBuilder(6).append(this.propLife().get().lifeformType()).append(" plant").toString();
        return this.getDescriptName(plantName);
    }

    @Override
    public boolean tick() {
        this.lifecycle().get().tick();
        return super.tick();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> getReferents() {
        void var1_1;
        Set out = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"living thing", "organism", this.name(), new StringBuilder(14).append(this.name()).append(" in the ").append(this.lifecycle().get().getCurStageName()).append(" stage").toString(), new StringBuilder(6).append(this.lifecycle().get().getCurStageName()).append(" plant").toString()}));
        out = (Set)out.$plus$plus(Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.getDescriptName(this.getDescriptName$default$1()), new StringBuilder(14).append(this.getDescriptName(this.getDescriptName$default$1())).append(" in the ").append(this.lifecycle().get().getCurStageName()).append(" stage").toString()})));
        if (this.propLife().get().isSickly()) {
            Set sicklyDesc = out.map((Function1<String, String> & Serializable & scala.Serializable)x$1 -> new StringBuilder(5).append("sick ").append((String)x$1).toString(), Set$.MODULE$.canBuildFrom());
            return (Set)out.$plus$plus(sicklyDesc);
        }
        return var1_1;
    }

    @Override
    public String getDescription(int mode) {
        Serializable serializable;
        scala.collection.mutable.StringBuilder os = new scala.collection.mutable.StringBuilder();
        String plantName = this.getPlantName();
        if (this.propLife().get().isDead()) {
            os.append(new StringBuilder(7).append("a dead ").append(plantName).toString());
            return os.toString();
        }
        if (this.isSeed()) {
            os.append(new StringBuilder(2).append("a ").append(plantName).toString());
            if (mode == EnvObject$.MODULE$.MODE_DETAILED()) {
                // empty if block
            }
            return os.toString();
        }
        os.append(new StringBuilder(16).append("a ").append(plantName).append(" in the ").append(this.lifecycle().get().getCurStageName()).append(" stage").toString());
        os.append(this.mkGeneticTraitsStr());
        Serializable serializable2 = this.propLife().get().isSickly() ? os.append(" (that looks unwell)") : BoxedUnit.UNIT;
        Set<EnvObject> cObjs = this.getContainedObjectsNotHidden();
        if (cObjs.size() > 0) {
            os.append(". ");
            serializable = os.append(new StringBuilder(19).append("On the ").append(plantName).append(" you see: ").append(StringHelpers$.MODULE$.objectListToStringDescription(cObjs, this, EnvObject$.MODULE$.MODE_CURSORY_DETAIL(), false)).append(". ").toString());
        } else {
            serializable = BoxedUnit.UNIT;
        }
        if (mode != EnvObject$.MODULE$.MODE_DETAILED()) {
            // empty if block
        }
        return os.toString();
    }

    public Plant() {
        this.name_$eq("plant");
        this.objType_$eq("plant");
        this.propLife_$eq(new Some<LifeProperties>(new LifePropertiesPlant()));
        this.propMaterial_$eq(new Some<MaterialProperties>(new PlantMatterProp()));
        this.propContainer_$eq(new Some<ContainerProperties>(new IsOpenUnclosableContainer()));
        this.lifecycle_$eq(new Some<LifeCycle>(PlantLifeStages$.MODULE$.mkPlantLifeCycle(this)));
    }
}

