'''
Author: 
Email: 
Date: 2023-01-27 19:30:48
LastEditTime: 2023-08-17 16:04:38
Description: 
'''
"""
Record video of agent episodes with the imageio library.
This script uses offscreen rendering.

Example:
    $ python demo_video_recording.py --environment Lift --robots Panda
"""

import argparse

import imageio
import numpy as np
from robosuite import load_controller_config
from controller.stack_policy import StackPolicy
from controller.lift_policy import LiftPolicy
from collector.gym_wrapper import GymStackWrapper
from collector.gym_wrapper import GymLiftWrapper

import robosuite.macros as macros
from robosuite import make

# Set the image convention to opencv so that the images are automatically rendered "right side up" when using imageio
# (which uses opencv convention)
macros.IMAGE_CONVENTION = "opencv"


# LiftCausal:      [xpr, xnr], \
# StackCausal:     [vert, diag], \
# WipeCausal:      [ll, lr], \
# DoorCausal:      [hhl, hhr], \


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--environment", type=str, default="LiftCausal")
    parser.add_argument("--robots", nargs="+", type=str, default="Kinova3", help="Which robot(s) to use in the env")
    parser.add_argument("--camera", type=str, default="agentview", help="Name of camera to render")
    parser.add_argument("--video_path", type=str, default="./log/video.mp4")
    parser.add_argument("--timesteps", type=int, default=200)
    parser.add_argument("--skip_frame", type=int, default=1)
    parser.add_argument("--height", type=int, default=512)
    parser.add_argument("--width", type=int, default=512)
    parser.add_argument("--control_freq", type=int, default=5)
    
    args = parser.parse_args()

    # initialize an environment with offscreen renderer
    env = make(
        args.environment,
        args.robots,
        has_renderer=False,
        has_offscreen_renderer=True,
        ignore_done=False,
        use_camera_obs=False,
        use_object_obs=True,
        # spurious_type='xnr',
        spurious_type='vert',
        control_freq=args.control_freq,
        controller_configs=load_controller_config(default_controller='OSC_POSITION'),
    )
    
    # env=GymStackWrapper(env)
    # policy=StackPolicy(Kp=10, Kd=1.0, atol=1e-3)
    env = GymLiftWrapper(env)
    policy = LiftPolicy(Kp=10, Kd=1.0, atol=1e-3)

    # create a video writer with imageio
    writer = imageio.get_writer(args.video_path, fps=20)
    num_episode = 1

    for e_i in range(num_episode):
        print('episode:', e_i)
        # obs = env.reset()
        # act_dim = env.action_dim
        obs, info = env.reset(return_info=True)
        policy.reset()
        frames = []
        for i in range(args.timesteps):
            # run a uniformly random agent
            action = policy.step(info)
            # print(action)
            obs, reward, done, info = env.step(action)
            # print(obs)

            # dump a frame from every K frames
            if i % args.skip_frame == 0:
                frame = env.env.sim.render(height=args.height, width=args.width, camera_name=args.camera)[::-1]
                writer.append_data(frame)

            if policy.check_success():
                print('success!')
                break
            if done:
                break
    
    writer.close()
    env.close()
