# ERA5

## Usage

To run this experiment, first download the ERA5 data using the following script:
```python
import cdsapi

client = cdsapi.Client()
client.retrieve(
    "reanalysis-era5-single-levels",
    {
        "product_type": "reanalysis",
        "variable": ["2m_temperature"],
        "year": range(2009, 2018),
        "month": ["01"],
        "day": [f"{i:02d}" for i in range(0, 31)],
        "time": ["00:00", "06:00", "12:00", "18:00"],
        "format": "grib",
        "area": [83, -169, 7, -35],
    },
    "era5_2m_temperature_2009-2017_01.grib",
)
```

Then, run `create_era5_data.py` to pre-process and generate the dataset. To train a hyper-diffusion model, run `train_hyperdiffusion.py` (providing the path to the dataset). Baseline models can be trained using `train_ddpm.py` and `train_dropout.py`.