import os
import numpy as np


import matplotlib

matplotlib.rcParams["pdf.fonttype"] = 42
matplotlib.rcParams["ps.fonttype"] = 42

# matplotlib.rcParams['text.usetex'] = True

import matplotlib.pyplot as plt

# plt.rcParams.update(
#     {"text.usetex": True, "font.family": "sans-serif", "font.sans-serif": ["Helvetica"]}
# )

plot_legend = False

selected_exprs = [
    "gp_sample_max",
    "branin_max",
    "goldstein_max",
    "phosphorus_max",
    "humid_max",
    "lake_max",
]

# selected_exprs = [
#     "gp_sample_top20",
#     "branin_top20",
#     "goldstein_top20",
#     "phosphorus_top20",
#     "humid_top20",
#     "lake_top20",
#     "gp_sample_top5",
#     "branin_top5",
#     "goldstein_top5",
#     "phosphorus_top5",
#     "humid_top5",
#     "lake_top5",
# ]

# selected_exprs = [
#     "gp_sample_multi",
#     "branin_multi",
#     "goldstein_multi",
#     "phosphorus_multi",
#     "humid_multi",
#     "lake_multi",
# ]


def get_acqs_for_expr(experiment):
    if experiment.endswith("max"):
        return [
            "bo_ei",
            "bo_pi",
            "bo_mes",
            "tightest",
            "uncertainty",
            "max_upper",
            "min_lower",
        ]

    return [
        "rand",
        "exprdesign",
        "tightest",
        "uncertainty",
        "max_upper",
        "min_lower",
    ]


labels = {
    "tightest": r"$\bar{\mathbf{x}}_t \wedge \bar{\mathbf{x}}_t'$",
    "uncertainty": r"$\bar{\mathbf{x}}_t \vee \bar{\mathbf{x}}_t'$",
    "max_upper": r"$\bar{\mathbf{x}}_t\ \vartriangle\ \bar{\mathbf{x}}_t'$",
    "min_lower": r"$\bar{\mathbf{x}}_t\ \triangledown\ \bar{\mathbf{x}}_t'$",
    "exprdesign": "Var",
    "rand": "Rand",
    "bo_ei": "EI",
    "bo_pi": "PI",
    "bo_mes": "MES",
}

styles = {
    "tightest": "-",
    "uncertainty": "-",
    "max_upper": (0, (5, 1)),  # densly dashed
    "min_lower": "-",
    "exprdesign": (0, (3, 5, 1, 5)),  # dashdotted
    "rand": (0, (1, 1)),  # dotted
    "bo_ei": (0, (3, 5, 1, 5)),  # dashdotted
    "bo_pi": (0, (3, 1, 1, 1, 1, 1)),  # densly dashdotdotted
    "bo_mes": (0, (1, 1)),  # densly dotted
}

colors = {
    "tightest": "tab:brown",
    "uncertainty": "tab:pink",
    "max_upper": "tab:gray",  # densly dashed
    "min_lower": "tab:olive",
    "exprdesign": "tab:cyan",  # dashdotted
    "rand": "tab:purple",  # dotted
    "bo_ei": "tab:cyan",  # dashdotted
    "bo_pi": "tab:orange",  # densly dashdotdotted
    "bo_mes": "tab:purple",  # densly dotted
}

settings = {
    "gp_sample_max": {
        "bbfunc": "gp_sample___xdim__1___xsize__100___noise_std__0.1___seed__0",
        "nrand": 15,
        "niter": 50,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "maximizer",
    },
    "gp_sample_top5": {
        "bbfunc": "gp_sample___xdim__1___xsize__100___noise_std__0.1___seed__0",
        "nrand": 15,
        "niter": 50,
        "niter_plot": 40,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "5_top_percentile",
    },
    "gp_sample_top20": {
        "bbfunc": "gp_sample___xdim__1___xsize__100___noise_std__0.1___seed__0",
        "nrand": 15,
        "niter": 50,
        "niter_plot": 40,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "20_top_percentile",
    },
    "gp_sample_multi": {
        "bbfunc": "gp_sample___xdim__1___xsize__100___noise_std__0.1___seed__0",
        "nrand": 15,
        "niter": 50,
        "n_init_obs": 3,
        "initseed": 999, #0,
        "mode": "boundary",
        "iset_type": "maximizer-10_top_percentile-20_top_percentile",
    },
    "branin_top5": {
        "bbfunc": "branin___xsize__100___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "5_top_percentile",
    },
    "branin_max": {
        "bbfunc": "branin___xsize__100___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "maximizer",
    },
    "branin_top20": {
        "bbfunc": "branin___xsize__100___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "20_top_percentile",
    },
    # "branin_top20": {
    #     "bbfunc": "branin___xsize__100___noise_std__0.1",
    #     "nrand": 15,
    #     "niter": 100,
    #     "n_init_obs": 3,
    #     "initseed": 0,
    #     "mode": "boundary",
    #     "iset_type": "maximizer-20_top_percentile",
    # },
    "branin_multi": {
        "bbfunc": "branin___xsize__100___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 999, # 0,
        "mode": "boundary",
        "iset_type": "maximizer-10_top_percentile-20_top_percentile",
    },
    "goldstein_max": {
        "bbfunc": "goldstein___xsize__100___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "niter_plot": 40,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "maximizer",
    },
    "goldstein_top5": {
        "bbfunc": "goldstein___xsize__100___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "5_top_percentile",
    },
    "goldstein_top20": {
        "bbfunc": "goldstein___xsize__100___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "20_top_percentile",
    },
    "goldstein_multi": {
        "bbfunc": "goldstein___xsize__100___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 999, # 0,
        "mode": "boundary",
        "iset_type": "maximizer-10_top_percentile-20_top_percentile",
    },
    "lake_max": {
        "bbfunc": "lake_zurich___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "maximizer",
    },
    "lake_top5": {
        "bbfunc": "lake_zurich___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "5_top_percentile",
    },
    "lake_top20": {
        "bbfunc": "lake_zurich___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "20_top_percentile",
    },
    "lake_multi": {
        "bbfunc": "lake_zurich___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 999, # 0,
        "mode": "boundary",
        "iset_type": "maximizer-10_top_percentile-20_top_percentile",
    },
    "phosphorus_max": {
        "bbfunc": "phosphorus___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "niter_plot": 80,
        "n_init_obs": 4,
        "initseed": 123,
        "mode": "boundary",
        "iset_type": "maximizer",
    },
    "phosphorus_top5": {
        "bbfunc": "phosphorus___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "5_top_percentile",
    },
    "phosphorus_top20": {
        "bbfunc": "phosphorus___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "20_top_percentile",
    },
    "phosphorus_multi": {
        "bbfunc": "phosphorus___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 999, # 0,
        "mode": "boundary",
        "iset_type": "maximizer-10_top_percentile-20_top_percentile",
    },
    "humid_max": {
        "bbfunc": "intel_lab_data_humidity___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "niter_plot": 40,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "maximizer",
    },
    "humid_top5": {
        "bbfunc": "intel_lab_data_humidity___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "niter_plot": 50,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "5_top_percentile",
    },
    "humid_top20": {
        "bbfunc": "intel_lab_data_humidity___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "niter_plot": 50,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "20_top_percentile",
    },
    "humid_multi": {
        "bbfunc": "intel_lab_data_humidity___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "niter_plot": 50,
        "n_init_obs": 3,
        "initseed": 999, # 0,
        "mode": "boundary",
        "iset_type": "maximizer-10_top_percentile-20_top_percentile",
    },
    "temp_top5": {
        "bbfunc": "intel_lab_data_temperature___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "5_top_percentile",
    },
    "temp_top20": {
        "bbfunc": "intel_lab_data_temperature___noise_std__0.1",
        "nrand": 15,
        "niter": 100,
        "n_init_obs": 3,
        "initseed": 0,
        "mode": "boundary",
        "iset_type": "20_top_percentile",
    },
}

for expr, setting in settings.items():

    if expr not in selected_exprs:
        continue

    bbfunc = setting["bbfunc"]
    nrand = setting["nrand"]
    niter = setting["niter"]

    niter_plot = niter
    if "niter_plot" in setting:
        niter_plot = min(niter, setting["niter_plot"])

    n_init_obs = setting["n_init_obs"]
    initseed = setting["initseed"]
    mode = setting["mode"]
    iset_type = setting["iset_type"]

    acquisitions = get_acqs_for_expr(expr)

    completed_acquisitions = []
    for acqfunc in acquisitions:
        regret_filename = f"out/{bbfunc}_REGRET_{iset_type}_{acqfunc}_nr{nrand}_it{niter}_seed{initseed}_init{n_init_obs}_{mode}.txt"
        if os.path.isfile(regret_filename):
            completed_acquisitions.append(acqfunc)
        else:
            print(f"{regret_filename} does not exist!")

    regrets = {}
    for acqfunc in completed_acquisitions:
        regret_filename = f"out/{bbfunc}_REGRET_{iset_type}_{acqfunc}_nr{nrand}_it{niter}_seed{initseed}_init{n_init_obs}_{mode}.txt"
        regrets[acqfunc] = np.loadtxt(regret_filename, delimiter=",")
        print(regrets[acqfunc].shape)

    fig, ax = plt.subplots(figsize=(3, 2.5), tight_layout=True)
    for acqfunc in completed_acquisitions:
        ax.errorbar(
            range(niter_plot),
            regrets[acqfunc].mean(axis=0)[:niter_plot],
            regrets[acqfunc].std(axis=0)[:niter_plot]
            / np.sqrt(regrets[acqfunc].shape[0]),
            linestyle=styles[acqfunc],
            label=labels[acqfunc],
            color=colors[acqfunc],
            alpha=0.7,
            errorevery=int(niter / 20),
        )

    if plot_legend:
        ax.legend()
        # ax.legend(loc='upper center', bbox_to_anchor=(0.5, 1.05),
        #           ncol=7, fancybox=True, shadow=True)

    ax.set_yscale("log")
    ax.set_ylabel("Regret")
    ax.set_xlabel("Iteration")
    fig.savefig(
        f"img/{bbfunc}_REGRET_{iset_type}_nr{nrand}_it{niter}_seed{initseed}_init{n_init_obs}_{mode}.pdf"
    )
