"""
find time epoch with the most observations (sensor information)
"""

import pandas as pd

sensor_df = pd.read_csv(
    "data.txt",
    delimiter=" ",
    header=None,
    names=[
        "date",
        "time",
        "epoch",
        "moteid",
        "temperature",
        "humidity",
        "light",
        "voltage",
    ],
)
moteid_df = pd.read_csv(
    "mote_locs.txt", delimiter=" ", header=None, names=["moteid", "x", "y"]
)

n_moteid_per_epoch = sensor_df.groupby(["date", "epoch"])["moteid"].count()
max_n_moteid = n_moteid_per_epoch.argmax()
print(
    "At epoch",
    max_n_moteid,
    "there are",
    n_moteid_per_epoch[max_n_moteid],
    "observations",
)

extracted_data = pd.merge(sensor_df[sensor_df["epoch"] == max_n_moteid], moteid_df)
extracted_data = extracted_data.astype({"x": float, "y": float, "temperature": float, "humidity": float, "light": float, "voltage": float})
print(extracted_data)

extracted_data.to_csv("extracted_data.csv", index=False)
