import os
import pandas as pd

urbancars_country_coobj = os.listdir('/media/exx/HDD/rwiddhic/aug_datasets/ConBias/UrbanCars-CoObj/country')
urbancars_urban_coobj = os.listdir('/media/exx/HDD/rwiddhic/aug_datasets/ConBias/UrbanCars-CoObj/urban')
urbancars_country_bg  = os.listdir('/media/exx/HDD/rwiddhic/aug_datasets/ConBias/UrbanCars-BG/country')
urbancars_urban_bg  = os.listdir('/media/exx/HDD/rwiddhic/aug_datasets/ConBias/UrbanCars-BG/urban')

metadata = pd.DataFrame(columns=['img_filename', 'y', 'place'])

for img in urbancars_country_coobj:
    metadata = metadata._append({'img_filename': f'/media/exx/HDD/rwiddhic/aug_datasets/ConBias/UrbanCars-CoObj/country/{img}', 'y': 0, 'place': 0}, ignore_index=True)

for img in urbancars_urban_coobj:
    metadata = metadata._append({'img_filename': f'/media/exx/HDD/rwiddhic/aug_datasets/ConBias/UrbanCars-CoObj/urban/{img}', 'y': 1, 'place': 0}, ignore_index=True)

for img in urbancars_country_bg:
    metadata = metadata._append({'img_filename': f'/media/exx/HDD/rwiddhic/aug_datasets/ConBias/UrbanCars-BG/country/{img}', 'y': 0, 'place': 1}, ignore_index=True)

for img in urbancars_urban_bg:
    metadata = metadata._append({'img_filename': f'/media/exx/HDD/rwiddhic/aug_datasets/ConBias/UrbanCars-BG/urban/{img}', 'y': 1, 'place': 1}, ignore_index=True)
#Sample 1300 images from the dataset
#metadata = metadata.sample(1300)
metadata.to_csv('/media/exx/HDD/rwiddhic/aug_datasets/ConBias/UrbanCars/additional_metadata_both_uc.csv', index=False)

# coco_gb = os.listdir('/media/exx/HDD/rwiddhic/aug_datasets/ConBias/COCO-GB/woman')
# coco_gb = [img for img in coco_gb if img.endswith('.png')]
# metadata = pd.DataFrame(columns=['img_filename', 'y', 'place'])
# for img in coco_gb:
#     metadata = metadata._append({'img_filename': f'/media/exx/HDD/rwiddhic/aug_datasets/ConBias/COCO-GB/woman/{img}', 'y': 0, 'place': 0}, ignore_index=True)

# #metadata = metadata.sample(260)
# metadata.to_csv('/media/exx/HDD/rwiddhic/aug_datasets/ConBias/COCO-GB/additional_metadata_coco.csv', index=False)

print("Shape of metadata: ", metadata.shape)