import numpy as np
from scipy.integrate import quad, dblquad


#x_upper_limit = np.inf
#y_upper_limit = np.inf


y_upper_limit = 10000
x_upper_limit = 10000

T= 1

def f(x):
    return np.exp(-x)


def pT(x):
    return 1 - np.exp(-T / x) if x != 0 else 1


def g(x, y):
    return np.exp((-x - y) / x) if x != 0 else 0


def E_X0_old_squared(q, c1, c2):
    def integrand1(x):
        return pT(x) * (c1 + x)**2 * f(x)

    def integrand2(x, y):
        return (1 - pT(x)) * g(x, y) * (c1 + c2)**2

    def integrand3(x, y):
        return (1 - pT(x)) * g(x, y) * (c1 + c2 + x)**2

    integral1, _ = quad(integrand1, 0, np.inf)
    integral2, _ = dblquad(integrand2, q, np.inf, lambda x: 0, lambda x: np.inf)
    integral3, _ = dblquad(integrand3, 0, q, lambda x: 0, lambda x: np.inf)

    return integral1 + integral2 + integral3


def E_X0_old(q, c1, c2):
    def integrand1(x):
        return pT(x) * (c1 + x) * f(x)

    def integrand2(x, y):
        return (1 - pT(x)) * g(x, y) * (c1 + c2)

    def integrand3(x, y):
        return (1 - pT(x)) * g(x, y) * (c1 + c2 + x)

    integral1, _ = quad(integrand1, 0, np.inf)
    integral2, _ = dblquad(integrand2, q, np.inf, lambda x: 0, lambda x: np.inf)
    integral3, _ = dblquad(integrand3, 0, q, lambda x: 0, lambda x: np.inf)

    return integral1 + integral2 + integral3

def E_X1_old_squared(q):
    def integrand(x, t):
        return (1 - pT(x)) * g(x, t) * (x - (t - q))**2

    integral, _ = dblquad(integrand, q, np.inf, lambda t: t - q, lambda t: np.inf)

    return integral

def E_X_new(q_minus_a_J, c1, c2):
    def integrand1(x):
        return pT(x) * x * f(x)

    def integrand2(x):
        return (1 - pT(x)) * c2 * f(x)

    def integrand3(x, y):
        return (1 - pT(x)) * g(x, y) * x

    integral1, _ = quad(integrand1, 0, np.inf)
    integral2, _ = quad(integrand2, 0, np.inf)
    integral3, _ = dblquad(integrand3, 0, q_minus_a_J, lambda x: 0, lambda x: np.inf)

    return c1 + integral1 + integral2 + integral3


def E_T_srv_PL(x_J, q, Lambda, c1, c2):
    EX0_old = E_X0_old(q, c1, c2)
    EX0_old_sq = E_X0_old_squared(q, c1, c2)
    EX1_old_sq = E_X1_old_squared(q)

    rho_ext = Lambda * EX0_old  # Assuming this is the correct interpretation

    numerator = Lambda * (EX0_old_sq + EX1_old_sq)
    denominator = 2 * (1 - Lambda * EX0_old) * (1 - Lambda * E_X_new(q, c1, c2))

    integral, _ = quad(lambda a: 1 / (1 - Lambda * E_X_new(q - a, c1, c2)), 0, x_J)

    return numerator / denominator + integral
