# Why Go Full? Elevating Federated Learning Through Partial Network Updates

In this supplementary material, we provide all the code necessary to fully implement the FedPart algorithm, along with all the code required to reproduce the comparison schemes mentioned in our paper. Our experimental results have been thoroughly verified and are fully reproducible. Below, we detail how to run the code.

## Installation

First, we recommend manually installing the latest version of PyTorch. We have only tested our code on `torch==2.1.0`, so we cannot guarantee functionality with other versions. For instructions on installing PyTorch, refer to this [link](https://pytorch.org/get-started/locally/). Please note, due to the high computational resource requirements of our experiments, it is advisable to use a CUDA-enabled version of PyTorch.

Next, you can simply install our code as a package by running:

```bash
pip install -e .
```

Finally, you can verify the successful installation of the package by running:

```bash
fling -v
```

## Quick Start

After installation, you can combine various federated learning algorithms with partial network training. In our paper, we experimented with the FedAvg, FedProx, and FedMOON algorithms and tested them on the CIFAR-10, CIFAR-100, Tiny-ImageNet, AGNews, and SogouNews datasets.

### FedAvg + FedPart

| Setting                          | Full Network Updates                                         | Partial Network Updates                                      |
| -------------------------------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
| CIFAR-10, FedAvg, ResNet-8       | ``python ./fedpart_args/cifar10/cifar10_fedavg_resnet8_config.py`` | ``python ./fedpart_args/cifar10/cifar10_fedpart_resnet8_config.py`` |
| CIFAR-10, FedAvg, ResNet-18      | ``python ./fedpart_args/cifar10/cifar10_fedavg_resnet18_config.py`` | ``python ./fedpart_args/cifar10/cifar10_fedpart_resnet18_config.py`` |
| CIFAR-100, FedAvg, ResNet-8      | ``python ./fedpart_args/cifar100/cifar100_fedavg_resnet8_config.py`` | ``python ./fedpart_args/cifar100/cifar100_fedpart_resnet8_config.py`` |
| CIFAR-100, FedAvg, ResNet-18     | ``python ./fedpart_args/cifar100/cifar100_fedavg_resnet18_config.py`` | ``python ./fedpart_args/cifar100/cifar100_fedpart_resnet18_config.py`` |
| Tiny-ImageNet, FedAvg, ResNet-8  | ``python ./fedpart_args/tiny_imagenet/tiny_imagenet_fedavg_resnet8_config.py`` | ``python ./fedpart_args/tiny_imagenet/tiny_imagenet_fedpart_resnet8_config.py`` |
| Tiny-ImageNet, FedAvg, ResNet-18 | ``python ./fedpart_args/tiny_imagenet/tiny_imagenet_fedavg_resnet18_config.py`` | ``python ./fedpart_args/tiny_imagenet/tiny_imagenet_fedpart_resnet18_config.py`` |
| AGNews, FedAvg, Transformer      | ``python ./fedpart_args/ag_news/agnews_fedavg_transformer_config.py`` | ``python ./fedpart_args/ag_news/agnews_fedpart_transformer_config.py`` |
| SogouNews, FedAvg, Transformer   | ``python ./fedpart_args/sogou_news/sogou_news_fedavg_transformer_config.py`` | ``python ./fedpart_args/sogou_news/sogou_news_fedpart_transformer_config.py`` |

### FedProx + FedPart

| Setting                          | Full Network Updates                                         | Partial Network Updates                                      |
| -------------------------------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
| CIFAR-10, FedProx, ResNet-8      | ``python ./fedpart_args/cifar10/cifar10_fedprox_resnet_fnu_config.py`` | ``python ./fedpart_args/cifar10/cifar10_fedprox_resnet_fedpart_config.py`` |
| CIFAR-100, FedProx, ResNet-8     | ``python ./fedpart_args/cifar100/cifar100_fedprox_resnet_fnu_config.py`` | ``python ./fedpart_args/cifar100/cifar100_fedprox_resnet_fedpart_config.py`` |
| Tiny-ImageNet, FedProx, ResNet-8 | ``python ./fedpart_args/tiny_imagenet/tiny_imagenet_fedprox_resnet_fnu_config.py`` | ``python ./fedpart_args/tiny_imagenet/tiny_imagenet_fedprox_resnet_fedpart_config.py`` |

### FedMOON + FedPart

| Setting                          | Full Network Updates                                         | Partial Network Updates                                      |
| -------------------------------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
| CIFAR-10, FedMOON, ResNet-8      | ``python ./fedpart_args/cifar10/cifar10_fedmoon_resnet_fnu_config.py`` | ``python ./fedpart_args/cifar10/cifar10_fedmoon_resnet_fedpart_config.py`` |
| CIFAR-100, FedMOON, ResNet-8     | ``python ./fedpart_args/cifar100/cifar100_fedmoon_resnet_fnu_config.py`` | ``python ./fedpart_args/cifar100/cifar100_fedmoon_resnet_fedpart_config.py`` |
| Tiny-ImageNet, FedMOON, ResNet-8 | ``python ./fedpart_args/tiny_imagenet/tiny_imagenet_fedmoon_resnet_fnu_config.py`` | ``python ./fedpart_args/tiny_imagenet/tiny_imagenet_fedmoon_resnet_fedpart_config.py`` |

## Acknowledgments

Our code is developed based on the open-source repository Fling. We would like to thank the authors of Fling for providing the foundational framework. You can find more about Fling at [Fling](https://github.com/kxzxvbk/Fling/tree/main/fling).
