# Divide-and-Conquer Posterior Sampling for Denoising Diffusion Priors


## Code installation

Install the code in editable mode

```bash
pip install -e .
```

This command will also download the code dependencies.

For convenience, the codes of these repositories were moved inside ``src`` folder
- https://github.com/gabrielvc/mcg_diff
- https://github.com/bahjat-kawar/ddrm
- https://github.com/openai/guided-diffusion
- https://github.com/NVlabs/RED-diff

to avoid installation conflicts.


## Large files

The model checkpoints, images, and datasets were ignored as they contain large files.
Make sure to create a folder ``large_files`` in the repository and the download the right files and folders.
To avoid path conflict, ensure insert the absolute path of your repository in ``src/local_paths.py`` script.

The ``large_files`` folder have the following the structure.

```
  large_files/
  ├── ddm-inv-problems/
  ├──── ffhq/
  |    └── validation_set/
  |       └── im1.png
  |       └── ...
  |    └── ffhq_mt.pt
  ├──── imagenet/
  |    └── validation_set/
  |       └── im1.png
  |       └── ...
  ├──── masks/
  |    └── inpainting_middle.pt
  |    └── ...
  |—— trajectories/
  |    └── raw_data/
  |       └── ucy/
  |          └── students_1.txt
  |          └── students_3.txt
  |    └── checkpoints/
  |       └── ucy_len_20_n_diff_steps_1000.pt
```


## A tour on the repository scripts

Both ``demo_images.py`` and ``demo_trajectory.py`` scripts can be used to solve inverse problems with an algorithm among the considered ones.
Use the the dataclass ``Config`` to customize the behavior of the script.

The script ``training_trajectory.py`` can be used to train the diffusion model for trajectories on ``ucy`` dataset.


## Downloading checkpoints

- [Imagnet](https://github.com/openai/guided-diffusion)
- [FFHQ](https://github.com/DPS2022/diffusion-posterior-sampling)
