#!/bin/bash

echo "Starting tmux sessions for 2D Quadrotor training..."

echo "Starting baseline..."
tmux new-session -d -s t_2dquad_base "source activate action_masking; python3 action_masking/experiments/benchmark_2d_quadrotor.py --approach=baseline"

for mm in "generator" "ray" "distribution"
do
    echo "Starting t_2dquad_$mm..."
    tmux new-session -d -s t_2dquad_$mm "source activate action_masking; python3 action_masking/experiments/benchmark_2d_quadrotor.py --approach=masking --masking-mode=$mm"
done
