#!/bin/bash

echo "Starting tmux sessions for 2D Quadrotor hyperparameter tuning..."

echo "Starting baseline..."
tmux new-session -d -s o_2dquad_base "source activate action_masking; python3 action_masking/experiments/benchmark_2d_quadrotor.py --approach=baseline --optimize"

for mm in "generator" "ray" "distribution"
do
    echo "Starting o_2dquad$mm..."
    tmux new-session -d -s o_2dquad$mm "source activate action_masking; python3 action_masking/experiments/benchmark_2d_quadrotor.py --approach=masking --masking-mode=$mm --optimize"
done
