import functools
import torch
import math
import pdb

@functools.lru_cache(maxsize=60)
def get_sines(x, max_freq):
    freqs = 2 ** torch.arange(0, max_freq, 2, device=x.device) * math.pi
    sines = torch.sin((x * freqs.view(1, -1)).squeeze(1))
    return sines