# Code for submission 1760: A Textbook Remedy for Domain Shifts: Knowledge Priors for Medical Image Analysis

## Directory Structure
* `concepts/` contains the generated concept bottlenecks from PubMed documents, each is a html file and you can open it in a browser.
* `models/` contains the code for the models used in the paper.
* `data/` contains the data used in the paper, will be released after the review process.

`models/cbm.py` is the main file for running our method, linear probe and pcbm-h.
`models/concept_generator.py` is the main file for generating the concept bottlenecks from medical documents.
`models/annotate_questions.py` is the main file for annotating concepts from clinical reports.
`models/train_binary.py` is the main file for training the binary classifier for each concept based on the annotated reports.
`models/models.py` contains the model architectures used in the paper.
`models/utils.py` contains the utility functions used in the paper.
`models/extract_features.py` contains the code for extracting image features using different pre-trained models.
`models/end2end.py`, `models/train_densenet.py` and `models/LSL.py` are the main files for training the ViT, DenseNet and LSL, respectively.


## Running the code
To run KnoBo:

```
python cbm.py --mode <the method>  \
              --question_type <the bottleneck>  \
              --model_name <the pretrained backbone>  \
              --number_of_features <number of concepts/features> \
              --data_dir <path to the data> \
              --modality <xray, skin or natural> \
              --binary_model_path <path to the binary grounding functions> \
              --prior <whether to add the prior loss> \
```