BEGIN TRANSACTION;
CREATE TABLE Courses (CourseID INTEGER PRIMARY KEY, Title TEXT, DepartmentID INTEGER REFERENCES Departments(DepartmentID), Semester TEXT, Year INTEGER);
INSERT INTO "Courses" VALUES(1,'Introduction to Computer Science',1,'Fall',2020);
INSERT INTO "Courses" VALUES(2,'Calculus I',2,'Spring',2020);
INSERT INTO "Courses" VALUES(3,'General Physics I',3,'Fall',2020);
INSERT INTO "Courses" VALUES(4,'Introductory Biology',4,'Spring',2020);
INSERT INTO "Courses" VALUES(5,'Composition and Rhetoric',5,'Fall',2020);
CREATE TABLE Departments (DepartmentID INTEGER PRIMARY KEY, DepartmentName TEXT, Description TEXT);
INSERT INTO "Departments" VALUES(1,'Computer Science','This department offers courses in computer science.');
INSERT INTO "Departments" VALUES(2,'Mathematics','The mathematics department provides a variety of math courses.');
INSERT INTO "Departments" VALUES(3,'Physics','Our physics department is known for its cutting-edge research facilities.');
INSERT INTO "Departments" VALUES(4,'Biology','We offer a comprehensive curriculum in biology at all levels.');
INSERT INTO "Departments" VALUES(5,'English','Our English department focuses on literature and writing.');
CREATE TABLE EnrolledStudents (EnrollmentID INTEGER PRIMARY KEY AUTOINCREMENT, StudentID INTEGER REFERENCES Students(StudentID), CourseID INTEGER REFERENCES Courses(CourseID));
INSERT INTO "EnrolledStudents" VALUES(1,1,1);
INSERT INTO "EnrolledStudents" VALUES(2,2,2);
INSERT INTO "EnrolledStudents" VALUES(3,3,3);
INSERT INTO "EnrolledStudents" VALUES(4,4,4);
INSERT INTO "EnrolledStudents" VALUES(5,5,5);
CREATE TABLE Instructors (InstructorID INTEGER PRIMARY KEY, Name TEXT, Email TEXT UNIQUE);
INSERT INTO "Instructors" VALUES(1,'Dr. John Doe','johndoe@xyzuniversity.edu');
INSERT INTO "Instructors" VALUES(2,'Professor Jane Smith','janesmith@abccollege.edu');
INSERT INTO "Instructors" VALUES(3,'Assoc Prof Michael Brown','michaelbrown@definstitute.edu');
INSERT INTO "Instructors" VALUES(4,'Asst Prof Emma Wilson','emmawilson@ghischool.edu');
INSERT INTO "Instructors" VALUES(5,'Adjunct Chris Jackson','chrisjackson@jkllacademy.edu');
CREATE TABLE Platforms (PlatformID INTEGER PRIMARY KEY, PlatformName TEXT, University TEXT);
INSERT INTO "Platforms" VALUES(1,'Canvas','XYZ University');
INSERT INTO "Platforms" VALUES(2,'Blackboard','ABC College');
INSERT INTO "Platforms" VALUES(3,'Moodle','DEF Institute');
INSERT INTO "Platforms" VALUES(4,'Google Classroom','GHI School');
INSERT INTO "Platforms" VALUES(5,'Schoology','JKL Academy');
CREATE TABLE Students (StudentID INTEGER PRIMARY KEY, FirstName TEXT, LastName TEXT);
INSERT INTO "Students" VALUES(1,'John','Doe');
INSERT INTO "Students" VALUES(2,'Jane','Smith');
INSERT INTO "Students" VALUES(3,'Michael','Brown');
INSERT INTO "Students" VALUES(4,'Emma','Wilson');
INSERT INTO "Students" VALUES(5,'Chris','Jackson');
DELETE FROM "sqlite_sequence";
INSERT INTO "sqlite_sequence" VALUES('EnrolledStudents',5);
COMMIT;
