#!/bin/bash

# Define the array of percent values
percents=(100)

# Define the array of interpolate_len values
horizon_lens=(128 192 288 336 396 512 768 1024 1536)

# Loop over each percent value
for percent in "${percents[@]}"; do
    # Loop over each interpolate_len value
    for horizon in "${horizon_lens[@]}"; do
        # Define model_id and log file name dynamically based on current percent and interpolate_len
        model_id="New050156__Linearinterpolate_ETTh1_interto${horizon}__${horizon}_336__p${percent}_lr3e-3_wd5e-4_lasso0_bs8192"
        log_file="${model_id}.log"

        # Run the Python script with current configurations
        nohup python3 -u run.py \
            --exp_name MTSF \
            --is_training 1 \
            --root_path ./dataset/ETT-small/ \
            --data_path ETTh1.csv \
            --data ETTh1 \
            --model_id "$model_id" \
            --model Linear_interpolate \
            --in_patch_stride 1 --in_patch_size 1 \
            --out_patch_stride 1 --out_patch_size 1 \
            --features M \
            --interpolate_len "$horizon" \
            --seq_len "$horizon" \
            --pred_len 336 \
            --label_len 5 \
            --des 'Exp' \
            --e_layers 3 \
            --d_model 768 \
            --enc_in 21 \
            --dec_in 21 \
            --c_out 21 \
            --d_ff 192 \
            --itr 5 \
            --batch_size 8192 \
            --train_epochs 100 \
            --learning_rate 0.003 \
            --weight_decay 0.0005 \
            --l1_lambda 0.0 \
            --percent "$percent" \
            --patience 10 \
            --coef 0.98 >> "$log_file"
        wait
    done
done


