from agentgym.task_suites.task_suite import TaskSuite
from agentgym.tools.banking_client import (
    BankAccount,
    get_balance,
    get_iban,
    get_most_recent_transactions,
    get_scheduled_transactions,
    schedule_transaction,
    send_money,
    update_scheduled_transaction,
)
from agentgym.tools.file_reader import Filesystem, read_file
from agentgym.tools.user_account import (
    UserAccount,
    get_user_info,
    update_password,
    update_user_info,
)
from agentgym.types import TaskEnvironment


class BankingEnvironment(TaskEnvironment):
    bank_account: BankAccount
    filesystem: Filesystem
    user_account: UserAccount


TOOLS = [
    # only those with @register_function
    get_iban.__name__,
    send_money.__name__,
    schedule_transaction.__name__,
    update_scheduled_transaction.__name__,
    get_balance.__name__,
    get_most_recent_transactions.__name__,
    get_scheduled_transactions.__name__,
    read_file.__name__,
    get_user_info.__name__,
    update_password.__name__,
    update_user_info.__name__,
]

task_suite = TaskSuite[BankingEnvironment]("banking", BankingEnvironment, TOOLS)
