import enum

import yaml


class StrEnum(str, enum.Enum):
    def __str__(self) -> str:
        return self.value

    def __repr__(self) -> str:
        return self.value


yaml.SafeDumper.add_multi_representer(
    StrEnum,
    yaml.representer.SafeRepresenter.represent_str,
)
