from typing import Annotated

from pydantic import BaseModel

from agentgym.functions_engine import Depends, register_function


class Filesystem(BaseModel):
    files: dict[str, str]


@register_function
def read_file(filesystem: Annotated[Filesystem, Depends("filesystem")], file_path: str) -> str:
    """
    Reads the contents of the file at the given path.

    :param file_path: The path to the file to read.
    """
    return filesystem.files.get(file_path, "")
