import fire
import pathlib
from collections import defaultdict

def main(
        eval_output_dir: str,
):
    commands = defaultdict(int)
    for eval_output in pathlib.Path(eval_output_dir).glob("**/*.eval.log"):
        if not eval_output.is_file():
            continue
        with open(eval_output) as f:
            eval_output = f.readlines()
        for line in eval_output:
            if line.startswith("Test Script:"):
                commands[line.split("Test Script:")[1].strip()] += 1
    for command, count in commands.items():
        if "pytest" not in command:
            print(f"{command}: {count}")

if __name__ == "__main__":
    fire.Fire(main)