import configparser
import json

import matplotlib.pyplot as plt
import os, sys
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
BASE_DIR = os.path.dirname(BASE_DIR)
sys.path.append(BASE_DIR)

import argparse
import pickle
from utils.utils import set_seed, read_config_file
import numpy as np
import os

def main(args=None):

    if args.config_file:
        config = read_config_file(args.config_file)
        files = config['General']['files']
        labels = config['General']['labels']
        smooth_gamma = config['General']['smooth_gamma']
    else:
        raise FileNotFoundError("no config file")

    # plt.figure(figsize=(14, 8))
    width = 0.2
    num_datasets = len(files)
    index = 0
    for _filename, _label in zip(files, labels):
        with open(_filename, "rb") as f:
            data = pickle.load(f)["all_length_score"]
            smoothed = [0]
            var_values = []
            keys = list(data.keys())
            for key in keys:
                mean = data[key]["bleu-mean"]
                smoothed.append(
                    mean * (1-smooth_gamma) + smoothed[-1] * smooth_gamma
                                )
                var_ = np.nanvar(data[key]["bleu"])
                var_values.append(var_)

            smoothed.pop(0)
            x = np.array(keys)
            y = np.array(smoothed)
            var_values = np.array(var_values)

            # 绘制均值和方差
            mean_values = y
            variance_values = var_values
            plt.plot(x, y, label=_label, linewidth=1.5)
            # plt.bar(x+index*width, mean_values, width=width, label=_label)
            # plt.errorbar(x+index*width, mean_values, yerr=variance_values, fmt='o', label=_label, color='black')

            index += 1


            # smoothed = [0]
            # var_values = []
            # for _d in data.values():
            #     smoothed.append(
            #         _d["mean"] * (1 - smooth_gamma) +
            #         smoothed[-1] * smooth_gamma
            #     )
            #     var_values.append(_d["var"])
            # smoothed.pop(0)
            #
            # y = np.array(smoothed)
            # var_values = np.array(var_values)
            # plt.plot(y, label=_label, linewidth=1.5)
            # plt.fill_between(y - (var_values), y + (var_values), alpha=0.1)
            # # plt.plot(smoothed, label=_label, linewidth=1.5)

    # 设置坐标轴标签
    plt.xlabel("token length")
    plt.ylabel("mean with variance")
    # plt.ylim(bottom=0, top=15)
    # 设置标题
    plt.title("bleu (smooth:{})".format(smooth_gamma))
    # plt.xticks(x,x)
    categories = [str(int(l / 1024)) + "k" for l in x]
    plt.xticks(x, categories)
    # plt.subplots_adjust(left=0.1, right=0.9, bottom=0.1, top=0.9)
    plt.legend()
    # plt.grid(axis='y')
    plt.savefig('rouge.png')
    plt.show()

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("-c", "--config_file", type=str, default="../conf/llama-3b-rouge-govreport-result11.json")
    args = parser.parse_args()
    main(args)
