#!/bin/bash

#model_path="/data/persist/models/vicuna/vicuna-13b-v1.3"
#model_path="/data/persist/models/llama2-7b-chat"
model_path="/data/persist/models/alpaca-7b"
#methods=("old" "rerope" "leaky-rerope" "dynamic-ntk" "lm-infinite" "streaming-llm" "weave-v10")
methods=("old")
# "weave" "weave1-to-duyan" "weave2-to-duyan")
#dataset="../datas/passkey_data_dup-100.json"
dataset="../datas/passkey_data.json"
batch_size=1
log_dir="../logs"
cuda="1"
hard_cuda=1
seed=0

source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

for method in "${methods[@]}"; do
  echo "############################ run passkey task: $method ############################"
  current_date=$(date "+%Y-%m-%d_%H-%M-%S")
  save_file="retrieval_acc_$(basename $model_path)_'$method'_$(basename $dataset)_'$seed'_'$current_date'.pkl"
  python_command="python evaluate_passkey_retrieval.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --hard_cuda $hard_cuda --cuda $cuda --seed $seed"

  echo $python_command
  eval $python_command || echo "completed"
done


