# Efficiently Enhancing Large Language Model Reasoning: Automated Process Labeling via Confidence Variation

This repository serves as supplementary material for the paper titled 'Efficiently Enhancing Large Language Model Reasoning: Automated Process Labeling via Confidence Variation,' abbreviated as AUTOCV, which is currently under review for presentation at NeurIPS 2024. It provides essential resources to assist reviewers in evaluating the quality and effectiveness of the work. **Please note that certain sections of the code have been omitted due to confidentiality, and we cannot guarantee flawless execution of the remaining code.** We are actively pursuing the application process and preparing the code for release to ensure compliance with open access standards.



## Directory Structrue 

```
AUTOCV
├── data_annotation.py
├── train.py
└── utils
    ├── process_verifier_models.py
    ├── states.py
    └── verifier_datasets.py
```



## Contents:

1. **data_annotation.py:**
   - This script is the key to automating the data annotation process via AUTOCV, as described in our paper. It serves two crucial purposes:

     1. Automatic process labeling: The script enables the automated labeling of processes, streamlining the data annotation workflow.
   
     2. Applying AUTOCV for process calculation hallucination identification: The script leverages AUTOCV, a technique introduced in our paper, to identify and detect instances of process calculation hallucinations. This capability is essential for ensuring the accuracy and reliability of the data annotation process.
   
2. **train.py:**
   - The `train.py` script is responsible for training the AUTOCV  verifeir model. It contains the training pipeline, including data loading, model initialization, optimization for both process-supervised verifiers and outcome-supervised verifiers.

3. **utils:**
   
   - This directory contains utility scripts and modules essential for various aspects of the AUTOCV project.
   
    a. **process_verifier_models.py:**
       - This module  implements functions related to processing verifier models.
   
    b. **states.py:**
       - The `states.py` module defines states or states-related functionalities crucial for the AUTOCV project. 
   
    c. **verifier_datasets.py:**
       - This module  contains classes or functions to handle verifier datasets. Verifier datasets are essential for training and validating the verifier models utilized in the AUTOCV framework.

## License 

This work is licensed under CC BY 4.0, a Creative Commons Attribution 4.0 International License. 



