function [r2_score,accuracy_s,accuracy,preds] = run_speed_decoders_fixed(T,speed)
    
    test_ratio = 0.3;
    
    labels = speed;
    n_ml = length(labels);
    
    T = zscore(T,1,1);
    T(isnan(T))=0;
    
    num_test = round(n_ml*test_ratio);
    is_test_template = [ones(num_test, 1); zeros(n_ml-num_test, 1)];
    random_shift = 500;
    is_test = boolean(circshift(is_test_template, random_shift, 1));

    is_train = ~is_test;
    num_test = sum(is_test);
    y_train = labels(is_train);
    y_test = labels(is_test);
    preds = zeros(2,num_test);
    preds(end,:) = y_test;
    
   
    X_train = T(is_train, :);
    X_test = T(is_test, :);

    % Run classification job
    mdl_X = regress_custom_cv(X_train, y_train);
    pred_train = predict(mdl_X, X_train);
    pred_test = predict(mdl_X, X_test);
    preds(1,:) = pred_test;

    accuracy = corr(pred_test,y_test);
    accuracy_s = corr(pred_test,y_test,'type','Spearman');
    
    r2_score = sqrt( mean( sum((pred_test -y_test).^2,2),1) );
end

